/*
 * Decompiled with CFR 0.152.
 */
package org.classdump.luna.compiler;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.classdump.luna.compiler.gen.ClassNameTranslator;
import org.classdump.luna.util.Check;

public class FunctionId {
    private final List<Integer> indices;
    public static final Comparator<FunctionId> LEXICOGRAPHIC_COMPARATOR = new Comparator<FunctionId>(){

        @Override
        public int compare(FunctionId a, FunctionId b) {
            int la = a.indices.size();
            int lb = b.indices.size();
            int len = Math.min(la, lb);
            for (int i = 0; i < len; ++i) {
                int bi;
                int ai = (Integer)a.indices.get(i);
                int diff = ai - (bi = ((Integer)b.indices.get(i)).intValue());
                if (diff == 0) continue;
                return diff;
            }
            return la - lb;
        }
    };
    private static final FunctionId ROOT = new FunctionId(Collections.emptyList());

    private FunctionId(List<Integer> indices) {
        this.indices = Objects.requireNonNull(indices);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FunctionId that = (FunctionId)o;
        return this.indices.equals(that.indices);
    }

    public int hashCode() {
        return this.indices.hashCode();
    }

    public static FunctionId root() {
        return ROOT;
    }

    public static FunctionId fromIndices(List<Integer> indices) {
        Objects.requireNonNull(indices);
        return indices.isEmpty() ? FunctionId.root() : new FunctionId(indices);
    }

    public String toString() {
        StringBuilder bld = new StringBuilder();
        Iterator<Integer> it = this.indices.iterator();
        bld.append("/");
        while (it.hasNext()) {
            int i = it.next();
            bld.append(i);
            if (!it.hasNext()) continue;
            bld.append("/");
        }
        return bld.toString();
    }

    public List<Integer> indices() {
        return this.indices;
    }

    public boolean isRoot() {
        return this.indices.isEmpty();
    }

    public FunctionId child(int index) {
        Check.nonNegative(index);
        ArrayList<Integer> childIndices = new ArrayList<Integer>(this.indices.size() + 1);
        childIndices.addAll(this.indices);
        childIndices.add(index);
        return new FunctionId(Collections.unmodifiableList(childIndices));
    }

    public FunctionId parent() {
        if (this.isRoot()) {
            return null;
        }
        List<Integer> subIndices = this.indices.subList(0, this.indices.size() - 1);
        return new FunctionId(subIndices);
    }

    public String toClassName(ClassNameTranslator tr) {
        Objects.requireNonNull(tr);
        for (Integer index : this.indices) {
            tr = tr.child(index);
        }
        return tr.className();
    }
}

