/*
 * Decompiled with CFR 0.152.
 */
package org.classdump.luna.compiler;

import java.util.List;
import java.util.Objects;
import org.classdump.luna.compiler.FunctionId;
import org.classdump.luna.compiler.ir.Code;
import org.classdump.luna.compiler.ir.UpVar;
import org.classdump.luna.compiler.ir.Var;

public class IRFunc {
    private final FunctionId id;
    private final List<Var> params;
    private final boolean vararg;
    private final List<UpVar> upvals;
    private final Code code;

    public IRFunc(FunctionId id, List<Var> params, boolean vararg, List<UpVar> upvals, Code code) {
        this.id = Objects.requireNonNull(id);
        this.params = Objects.requireNonNull(params);
        this.vararg = vararg;
        this.upvals = Objects.requireNonNull(upvals);
        this.code = Objects.requireNonNull(code);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IRFunc that = (IRFunc)o;
        return this.id.equals(that.id) && this.params.equals(that.params) && this.upvals.equals(that.upvals) && this.code.equals(that.code);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.params, this.code);
    }

    public FunctionId id() {
        return this.id;
    }

    public List<Var> params() {
        return this.params;
    }

    public boolean isVararg() {
        return this.vararg;
    }

    public List<UpVar> upvals() {
        return this.upvals;
    }

    public Code code() {
        return this.code;
    }

    public IRFunc update(Code code) {
        if (this.code.equals(code)) {
            return this;
        }
        return new IRFunc(this.id, this.params, this.vararg, this.upvals, code);
    }
}

