/*
 * Decompiled with CFR 0.152.
 */
package org.classdump.luna.compiler.analysis;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.classdump.luna.compiler.IRFunc;
import org.classdump.luna.compiler.analysis.AbstractUseDefVisitor;
import org.classdump.luna.compiler.analysis.LivenessInfo;
import org.classdump.luna.compiler.ir.AbstractVal;
import org.classdump.luna.compiler.ir.BasicBlock;
import org.classdump.luna.compiler.ir.BlockTermNode;
import org.classdump.luna.compiler.ir.BodyNode;
import org.classdump.luna.compiler.ir.Code;
import org.classdump.luna.compiler.ir.IRNode;
import org.classdump.luna.compiler.ir.Label;
import org.classdump.luna.compiler.ir.MultiVal;
import org.classdump.luna.compiler.ir.PhiVal;
import org.classdump.luna.compiler.ir.UpVar;
import org.classdump.luna.compiler.ir.Val;
import org.classdump.luna.compiler.ir.Var;
import org.classdump.luna.compiler.ir.VarStore;
import org.classdump.luna.compiler.util.CodeUtils;

public class LivenessAnalyser {
    private final IRFunc fn;
    private final Map<IRNode, Set<Var>> varLiveIn;
    private final Map<IRNode, Set<AbstractVal>> valLiveIn;
    private Map<Label, Set<Var>> endVarLiveIn;
    private Map<Label, Set<AbstractVal>> endValLiveIn;

    private LivenessAnalyser(IRFunc fn) {
        this.fn = Objects.requireNonNull(fn);
        this.varLiveIn = new HashMap<IRNode, Set<Var>>();
        this.valLiveIn = new HashMap<IRNode, Set<AbstractVal>>();
        this.endVarLiveIn = new HashMap<Label, Set<Var>>();
        this.endValLiveIn = new HashMap<Label, Set<AbstractVal>>();
    }

    public static LivenessInfo computeLiveness(IRFunc fn) {
        LivenessAnalyser analyser = new LivenessAnalyser(fn);
        return analyser.analyse();
    }

    public LivenessInfo analyse() {
        Code code = this.fn.code();
        Map<Label, Set<Label>> in = CodeUtils.inLabels(code);
        for (Label l : code.labels()) {
            this.endVarLiveIn.put(l, new HashSet());
            this.endValLiveIn.put(l, new HashSet());
        }
        Iterator<IRNode> ns = CodeUtils.nodeIterator(code);
        while (ns.hasNext()) {
            IRNode n = ns.next();
            this.varLiveIn.put(n, new HashSet());
            this.valLiveIn.put(n, new HashSet());
        }
        ArrayDeque<Label> open = new ArrayDeque<Label>();
        for (Label l : CodeUtils.labelsBreadthFirst(code)) {
            open.push(l);
        }
        while (!open.isEmpty()) {
            Label l;
            l = (Label)open.pop();
            LivenessVisitor visitor = new LivenessVisitor(this.endVarLiveIn.get(l), this.endValLiveIn.get(l));
            this.processBlock(visitor, code.block(l));
            for (Label inl : in.get(l)) {
                boolean changed = false;
                changed |= this.endVarLiveIn.get(inl).addAll(visitor.currentVarLiveIn());
                if (!(changed |= this.endValLiveIn.get(inl).addAll(visitor.currentValLiveIn()))) continue;
                if (open.contains(inl)) {
                    open.remove(inl);
                }
                open.push(inl);
            }
        }
        return this.result();
    }

    private static void mergeLiveOut(Map<IRNode, LivenessInfo.Entry> entries, IRNode m, IRNode n) {
        LivenessInfo.Entry e_m = entries.get(m);
        LivenessInfo.Entry e_n = entries.get(n);
        e_m.outVar().addAll(e_n.inVar());
        e_m.outVal().addAll(e_n.inVal());
    }

    private LivenessInfo result() {
        HashMap<IRNode, LivenessInfo.Entry> entries = new HashMap<IRNode, LivenessInfo.Entry>();
        Iterator<IRNode> nodeIterator = CodeUtils.nodeIterator(this.fn.code());
        while (nodeIterator.hasNext()) {
            IRNode node = nodeIterator.next();
            Set<Var> var_in = this.varLiveIn.get(node);
            Set<AbstractVal> val_in = this.valLiveIn.get(node);
            entries.put(node, new LivenessInfo.Entry(var_in, new HashSet<Var>(), val_in, new HashSet<AbstractVal>()));
        }
        Iterator<BasicBlock> blockIterator = this.fn.code().blockIterator();
        while (blockIterator.hasNext()) {
            BasicBlock b = blockIterator.next();
            for (int i = 0; i < b.body().size(); ++i) {
                BodyNode m = b.body().get(i);
                BlockTermNode n = i + 1 < b.body().size() ? (IRNode)b.body().get(i + 1) : b.end();
                LivenessAnalyser.mergeLiveOut(entries, m, n);
            }
            BlockTermNode end = b.end();
            LivenessInfo.Entry e_end = (LivenessInfo.Entry)entries.get(end);
            for (Label nxt : end.nextLabels()) {
                BasicBlock nextBlock = this.fn.code().block(nxt);
                BlockTermNode n = !nextBlock.body().isEmpty() ? (IRNode)nextBlock.body().get(0) : nextBlock.end();
                LivenessAnalyser.mergeLiveOut(entries, end, n);
            }
        }
        return new LivenessInfo(entries);
    }

    private boolean processBlock(LivenessVisitor visitor, BasicBlock block) {
        boolean changed = this.processNode(visitor, block.end());
        for (int i = block.body().size() - 1; i >= 0; --i) {
            changed |= this.processNode(visitor, block.body().get(i));
        }
        return changed;
    }

    private boolean processNode(LivenessVisitor visitor, IRNode node) {
        Objects.requireNonNull(node);
        Set<Var> varLive_in = this.varLiveIn.get(node);
        Set<AbstractVal> valLive_in = this.valLiveIn.get(node);
        node.accept(visitor);
        boolean varSame = visitor.currentVarLiveIn().equals(varLive_in);
        boolean valSame = visitor.currentValLiveIn().equals(valLive_in);
        if (!varSame) {
            varLive_in.clear();
            varLive_in.addAll(visitor.currentVarLiveIn());
        }
        if (!valSame) {
            valLive_in.clear();
            valLive_in.addAll(visitor.currentValLiveIn());
        }
        return !varSame || !valSame;
    }

    private class LivenessVisitor
    extends AbstractUseDefVisitor {
        private Set<Var> currentVarLiveIn;
        private Set<AbstractVal> currentValLiveIn;

        public LivenessVisitor(Set<Var> currentVarLiveIn, Set<AbstractVal> currentValLiveIn) {
            this.currentVarLiveIn = new HashSet<Var>((Collection)Objects.requireNonNull(currentVarLiveIn));
            this.currentValLiveIn = new HashSet<AbstractVal>((Collection)Objects.requireNonNull(currentValLiveIn));
        }

        public Set<Var> currentVarLiveIn() {
            return this.currentVarLiveIn;
        }

        public Set<AbstractVal> currentValLiveIn() {
            return this.currentValLiveIn;
        }

        @Override
        protected void def(Val v) {
            this.currentValLiveIn.remove(v);
        }

        @Override
        protected void use(Val v) {
            this.currentValLiveIn.add(v);
        }

        @Override
        protected void def(PhiVal pv) {
            this.currentValLiveIn.remove(pv);
        }

        @Override
        protected void use(PhiVal pv) {
            this.currentValLiveIn.add(pv);
        }

        @Override
        protected void def(MultiVal mv) {
        }

        @Override
        protected void use(MultiVal mv) {
        }

        @Override
        protected void def(Var v) {
            this.currentVarLiveIn.remove(v);
        }

        @Override
        protected void use(Var v) {
            this.currentVarLiveIn.add(v);
        }

        @Override
        protected void def(UpVar uv) {
        }

        @Override
        protected void use(UpVar uv) {
        }

        @Override
        public void visit(VarStore node) {
            this.use(node.src());
            this.use(node.var());
        }
    }
}

