/*
 * Decompiled with CFR 0.152.
 */
package org.classdump.luna.compiler.analysis;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import org.classdump.luna.compiler.ir.AbstractVal;
import org.classdump.luna.compiler.ir.IRNode;
import org.classdump.luna.compiler.ir.Var;

public class LivenessInfo {
    private final Map<IRNode, Entry> entries;

    public LivenessInfo(Map<IRNode, Entry> entries) {
        this.entries = Objects.requireNonNull(entries);
    }

    public Entry entry(IRNode node) {
        Objects.requireNonNull(node);
        Entry e = this.entries.get(node);
        if (e == null) {
            throw new NoSuchElementException("No liveness information for " + node);
        }
        return e;
    }

    public Iterable<Var> liveInVars(IRNode node) {
        return this.entry(node).inVar();
    }

    public Iterable<Var> liveOutVars(IRNode node) {
        return this.entry(node).outVar();
    }

    public Iterable<AbstractVal> liveInVals(IRNode node) {
        return this.entry(node).inVal();
    }

    public Iterable<AbstractVal> liveOutVals(IRNode node) {
        return this.entry(node).outVal();
    }

    public static class Entry {
        private final Set<Var> var_in;
        private final Set<Var> var_out;
        private final Set<AbstractVal> val_in;
        private final Set<AbstractVal> val_out;

        Entry(Set<Var> var_in, Set<Var> var_out, Set<AbstractVal> val_in, Set<AbstractVal> val_out) {
            this.var_in = Objects.requireNonNull(var_in);
            this.var_out = Objects.requireNonNull(var_out);
            this.val_in = Objects.requireNonNull(val_in);
            this.val_out = Objects.requireNonNull(val_out);
        }

        public Entry immutableCopy() {
            return new Entry(Collections.unmodifiableSet(new HashSet<Var>(this.var_in)), Collections.unmodifiableSet(new HashSet<Var>(this.var_out)), Collections.unmodifiableSet(new HashSet<AbstractVal>(this.val_in)), Collections.unmodifiableSet(new HashSet<AbstractVal>(this.val_out)));
        }

        public Set<Var> inVar() {
            return this.var_in;
        }

        public Set<Var> outVar() {
            return this.var_out;
        }

        public Set<AbstractVal> inVal() {
            return this.val_in;
        }

        public Set<AbstractVal> outVal() {
            return this.val_out;
        }
    }
}

