/*
 * Decompiled with CFR 0.152.
 */
package org.classdump.luna.compiler.analysis;

import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import org.classdump.luna.compiler.ir.AbstractVal;
import org.classdump.luna.compiler.ir.Var;

public class SlotAllocInfo {
    private final Map<AbstractVal, Integer> valSlots;
    private final Map<Var, Integer> varSlots;
    private final int numSlots;

    public SlotAllocInfo(Map<AbstractVal, Integer> valSlots, Map<Var, Integer> varSlots) {
        this.valSlots = Objects.requireNonNull(valSlots);
        this.varSlots = Objects.requireNonNull(varSlots);
        int n = 0;
        for (Integer i : varSlots.values()) {
            n = Math.max(n, i);
        }
        for (Integer i : valSlots.values()) {
            n = Math.max(n, i);
        }
        this.numSlots = n + 1;
    }

    public int slotOf(AbstractVal v) {
        Integer idx = this.valSlots.get(Objects.requireNonNull(v));
        if (idx != null) {
            return idx;
        }
        throw new NoSuchElementException("Undefined slot for value: " + v);
    }

    public int slotOf(Var v) {
        Integer idx = this.varSlots.get(Objects.requireNonNull(v));
        if (idx != null) {
            return idx;
        }
        throw new NoSuchElementException("Undefined slot for variable: " + v);
    }

    public int numSlots() {
        return this.numSlots;
    }
}

