/*
 * Decompiled with CFR 0.152.
 */
package org.classdump.luna.compiler.analysis;

import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.Set;
import org.classdump.luna.compiler.IRFunc;
import org.classdump.luna.compiler.analysis.NumericOperationType;
import org.classdump.luna.compiler.analysis.StaticMathImplementation;
import org.classdump.luna.compiler.analysis.TypeInfo;
import org.classdump.luna.compiler.analysis.Typer;
import org.classdump.luna.compiler.analysis.types.AbstractType;
import org.classdump.luna.compiler.analysis.types.FunctionType;
import org.classdump.luna.compiler.analysis.types.LiteralType;
import org.classdump.luna.compiler.analysis.types.LuaTypes;
import org.classdump.luna.compiler.analysis.types.ReturnType;
import org.classdump.luna.compiler.analysis.types.Type;
import org.classdump.luna.compiler.analysis.types.TypeSeq;
import org.classdump.luna.compiler.ir.AbstractVar;
import org.classdump.luna.compiler.ir.BasicBlock;
import org.classdump.luna.compiler.ir.BinOp;
import org.classdump.luna.compiler.ir.Call;
import org.classdump.luna.compiler.ir.Closure;
import org.classdump.luna.compiler.ir.Code;
import org.classdump.luna.compiler.ir.CodeVisitor;
import org.classdump.luna.compiler.ir.Label;
import org.classdump.luna.compiler.ir.LoadConst;
import org.classdump.luna.compiler.ir.MultiGet;
import org.classdump.luna.compiler.ir.MultiVal;
import org.classdump.luna.compiler.ir.PhiLoad;
import org.classdump.luna.compiler.ir.PhiStore;
import org.classdump.luna.compiler.ir.PhiVal;
import org.classdump.luna.compiler.ir.Ret;
import org.classdump.luna.compiler.ir.TCall;
import org.classdump.luna.compiler.ir.TabGet;
import org.classdump.luna.compiler.ir.TabNew;
import org.classdump.luna.compiler.ir.TabRawAppendMulti;
import org.classdump.luna.compiler.ir.TabSet;
import org.classdump.luna.compiler.ir.ToNumber;
import org.classdump.luna.compiler.ir.UnOp;
import org.classdump.luna.compiler.ir.UpLoad;
import org.classdump.luna.compiler.ir.UpStore;
import org.classdump.luna.compiler.ir.VList;
import org.classdump.luna.compiler.ir.Val;
import org.classdump.luna.compiler.ir.Var;
import org.classdump.luna.compiler.ir.VarInit;
import org.classdump.luna.compiler.ir.VarLoad;
import org.classdump.luna.compiler.ir.VarStore;
import org.classdump.luna.compiler.ir.Vararg;

class TyperVisitor
extends CodeVisitor {
    private final Map<Val, Type> valTypes = new HashMap<Val, Type>();
    private final Map<PhiVal, Type> phiValTypes = new HashMap<PhiVal, Type>();
    private final Map<MultiVal, TypeSeq> multiValTypes = new HashMap<MultiVal, TypeSeq>();
    private final Map<Label, VarState> varStates = new HashMap<Label, VarState>();
    private final Set<Var> allVars = new HashSet<Var>();
    private final Set<Var> reifiedVars = new HashSet<Var>();
    private final Set<Label> seen = new HashSet<Label>();
    private final Queue<Label> open = new ArrayDeque<Label>();
    private final Set<ReturnType> returnTypes = new HashSet<ReturnType>();
    private boolean changed;
    private VarState currentVarState;

    public TypeInfo valTypes() {
        return TypeInfo.of(this.valTypes, this.phiValTypes, this.multiValTypes, this.allVars, this.reifiedVars, this.returnType());
    }

    private static TypeSeq returnTypeToTypeSeq(ReturnType rt) {
        if (rt instanceof ReturnType.ConcreteReturnType) {
            return ((ReturnType.ConcreteReturnType)rt).typeSeq;
        }
        if (rt instanceof ReturnType.TailCallReturnType) {
            Type targetType = ((ReturnType.TailCallReturnType)rt).target;
            if (targetType instanceof FunctionType) {
                FunctionType ft = (FunctionType)targetType;
                return ft.returnTypes();
            }
            return TypeSeq.vararg();
        }
        throw new IllegalArgumentException("Illegal return type: " + rt);
    }

    private TypeSeq returnType() {
        TypeSeq ret = null;
        for (ReturnType rt : this.returnTypes) {
            TypeSeq ts = TyperVisitor.returnTypeToTypeSeq(rt);
            ret = ret != null ? ret.join(ts) : ts;
        }
        return ret != null ? ret : TypeSeq.vararg();
    }

    private static Type joinTypes(Type a, Type b) {
        return a == null ? b : (b == null ? a : a.join(b));
    }

    private VarState currentVarState() {
        return this.currentVarState;
    }

    private VarState varState(Label l) {
        VarState vs = this.varStates.get(l);
        if (vs == null) {
            VarState nvs = new VarState();
            this.varStates.put(l, nvs);
            return nvs;
        }
        return vs;
    }

    private void useStack() {
    }

    private void impure() {
        this.currentVarState.clearReifiedVars();
    }

    private void mayCallMetamethod() {
        this.useStack();
        this.impure();
    }

    private void assign(Val v, Type t) {
        Objects.requireNonNull(v);
        Objects.requireNonNull(t);
        Type ot = this.valTypes.put(v, t);
        if (!t.equals(ot)) {
            this.changed = ot == null ? true : true;
        }
    }

    private void assign(PhiVal pv, Type t) {
        Objects.requireNonNull(pv);
        Objects.requireNonNull(t);
        Type ot = this.phiValTypes.get(pv);
        if (ot != null) {
            Type nt = ot.join(t);
            if (!ot.equals(nt)) {
                this.phiValTypes.put(pv, nt);
                this.changed = true;
            }
        } else {
            this.phiValTypes.put(pv, t);
            this.changed = true;
        }
    }

    private void assign(MultiVal mv, TypeSeq ts) {
        Objects.requireNonNull(mv);
        Objects.requireNonNull(ts);
        TypeSeq ots = this.multiValTypes.put(mv, ts);
        if (!ts.equals(ots)) {
            this.changed = ots == null ? true : true;
        }
    }

    private Type typeOf(Val v) {
        Type t = this.valTypes.get(v);
        if (t == null) {
            throw new IllegalStateException(v + " not assigned to yet");
        }
        return t;
    }

    private Type typeOf(PhiVal pv) {
        Type t = this.phiValTypes.get(pv);
        if (t == null) {
            throw new IllegalStateException(pv + " not assigned to yet");
        }
        return t;
    }

    private TypeSeq typeOf(MultiVal mv) {
        TypeSeq tseq = this.multiValTypes.get(mv);
        if (tseq == null) {
            throw new IllegalStateException(mv + " not assigned to yet");
        }
        return tseq;
    }

    @Override
    public void visit(IRFunc func) {
        Code code = func.code();
        VarState vs = this.varState(code.entryLabel());
        for (Var p : func.params()) {
            vs.store(p, LuaTypes.DYNAMIC);
        }
        this.visit(code);
    }

    @Override
    public void visit(Code code) {
        this.open.add(code.entryLabel());
        while (!this.open.isEmpty()) {
            this.visit(code.block(this.open.poll()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void visit(BasicBlock block) {
        boolean firstTimeVisit = this.seen.add(block.label());
        this.currentVarState = this.varState(block.label()).copy();
        this.changed = false;
        try {
            super.visit(block);
            for (Label nxt : block.end().nextLabels()) {
                VarState vs = this.varState(nxt);
                if (!vs.joinWith(this.currentVarState)) continue;
                this.changed = true;
            }
            if (firstTimeVisit || this.changed) {
                for (Label nxt : block.end().nextLabels()) {
                    this.open.add(nxt);
                }
            }
        }
        finally {
            this.changed = false;
            this.currentVarState = null;
        }
    }

    @Override
    public void visit(LoadConst.Nil node) {
        this.assign(node.dest(), (Type)LuaTypes.NIL);
    }

    @Override
    public void visit(LoadConst.Bool node) {
        this.assign(node.dest(), LuaTypes.BOOLEAN.newLiteralType(node.value()));
    }

    @Override
    public void visit(LoadConst.Int node) {
        this.assign(node.dest(), LuaTypes.NUMBER_INTEGER.newLiteralType(node.value()));
    }

    @Override
    public void visit(LoadConst.Flt node) {
        this.assign(node.dest(), LuaTypes.NUMBER_FLOAT.newLiteralType(node.value()));
    }

    @Override
    public void visit(LoadConst.Str node) {
        this.assign(node.dest(), LuaTypes.STRING.newLiteralType(node.value()));
    }

    private static StaticMathImplementation staticMath(BinOp.Op op) {
        switch (op) {
            case ADD: {
                return StaticMathImplementation.MAY_BE_INTEGER;
            }
            case SUB: {
                return StaticMathImplementation.MAY_BE_INTEGER;
            }
            case MUL: {
                return StaticMathImplementation.MAY_BE_INTEGER;
            }
            case MOD: {
                return StaticMathImplementation.MAY_BE_INTEGER;
            }
            case POW: {
                return StaticMathImplementation.MUST_BE_FLOAT;
            }
            case DIV: {
                return StaticMathImplementation.MUST_BE_FLOAT;
            }
            case IDIV: {
                return StaticMathImplementation.MAY_BE_INTEGER;
            }
            case BAND: {
                return StaticMathImplementation.MUST_BE_INTEGER;
            }
            case BOR: {
                return StaticMathImplementation.MUST_BE_INTEGER;
            }
            case BXOR: {
                return StaticMathImplementation.MUST_BE_INTEGER;
            }
            case SHL: {
                return StaticMathImplementation.MUST_BE_INTEGER;
            }
            case SHR: {
                return StaticMathImplementation.MUST_BE_INTEGER;
            }
        }
        return null;
    }

    private static boolean stringable(Type t) {
        return t.isSubtypeOf(LuaTypes.STRING) || t.isSubtypeOf(LuaTypes.NUMBER);
    }

    @Override
    public void visit(BinOp node) {
        Type result;
        Type l = this.typeOf(node.left());
        Type r = this.typeOf(node.right());
        LiteralType<?> emulatedResult = Typer.emulateOp(node.op(), l, r);
        if (emulatedResult != null) {
            result = emulatedResult;
        } else {
            StaticMathImplementation math = TyperVisitor.staticMath(node.op());
            if (math != null) {
                NumericOperationType ot = math.opType(l, r);
                result = ot.toType();
                if (ot == NumericOperationType.Any) {
                    this.mayCallMetamethod();
                }
            } else {
                switch (node.op()) {
                    case CONCAT: {
                        if (TyperVisitor.stringable(l) && TyperVisitor.stringable(r)) {
                            result = LuaTypes.STRING;
                            break;
                        }
                        result = LuaTypes.ANY;
                        this.mayCallMetamethod();
                        break;
                    }
                    case EQ: 
                    case NEQ: 
                    case LT: 
                    case LE: {
                        result = LuaTypes.BOOLEAN;
                        this.mayCallMetamethod();
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException("Illegal binary operation: " + (Object)((Object)node.op()));
                    }
                }
            }
        }
        this.assign(node.dest(), result);
    }

    @Override
    public void visit(UnOp node) {
        Type result;
        Type a = this.typeOf(node.arg());
        LiteralType<?> emulatedResult = Typer.emulateOp(node.op(), a);
        if (emulatedResult != null) {
            result = emulatedResult;
        } else {
            switch (node.op()) {
                case UNM: {
                    result = StaticMathImplementation.MAY_BE_INTEGER.opType(a).toType();
                    break;
                }
                case BNOT: {
                    result = StaticMathImplementation.MUST_BE_INTEGER.opType(a).toType();
                    break;
                }
                case NOT: {
                    result = LuaTypes.BOOLEAN;
                    break;
                }
                case LEN: {
                    result = a.isSubtypeOf(LuaTypes.STRING) ? LuaTypes.NUMBER_INTEGER : LuaTypes.ANY;
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Illegal unary operation: " + (Object)((Object)node.op()));
                }
            }
        }
        this.assign(node.dest(), result);
    }

    @Override
    public void visit(TabNew node) {
        this.mayCallMetamethod();
        this.assign(node.dest(), (Type)LuaTypes.TABLE);
    }

    @Override
    public void visit(TabGet node) {
        this.mayCallMetamethod();
        this.assign(node.dest(), (Type)LuaTypes.ANY);
    }

    @Override
    public void visit(TabSet node) {
        this.mayCallMetamethod();
    }

    @Override
    public void visit(TabRawAppendMulti node) {
    }

    @Override
    public void visit(VarLoad node) {
        Type t = this.currentVarState().load(node.var());
        this.assign(node.dest(), t);
    }

    @Override
    public void visit(VarInit node) {
        this.currentVarState().store(node.var(), this.typeOf(node.src()));
    }

    @Override
    public void visit(VarStore node) {
        this.currentVarState().store(node.var(), this.typeOf(node.src()));
    }

    @Override
    public void visit(UpLoad node) {
        this.assign(node.dest(), (Type)LuaTypes.ANY);
    }

    @Override
    public void visit(UpStore node) {
    }

    @Override
    public void visit(Vararg node) {
        TypeSeq varargType = TypeSeq.empty().withVararg();
        this.assign(node.dest(), varargType);
    }

    protected TypeSeq vlistType(VList vlist) {
        Type[] fixed = new Type[vlist.addrs().size()];
        for (int i = 0; i < vlist.addrs().size(); ++i) {
            fixed[i] = this.typeOf(vlist.addrs().get(i));
        }
        return vlist.suffix() != null ? this.typeOf(vlist.suffix()).prefixedBy(fixed) : TypeSeq.of(fixed);
    }

    @Override
    public void visit(Ret node) {
        this.returnTypes.add(new ReturnType.ConcreteReturnType(this.vlistType(node.args())));
    }

    @Override
    public void visit(TCall node) {
        this.returnTypes.add(new ReturnType.TailCallReturnType(this.typeOf(node.target()), this.vlistType(node.args())));
    }

    protected TypeSeq callReturnType(Val target, VList args) {
        TypeSeq argTypes = this.vlistType(args);
        return TypeSeq.empty().withVararg();
    }

    @Override
    public void visit(Call node) {
        TypeSeq returnType = this.callReturnType(node.fn(), node.args());
        this.assign(node.dest(), returnType);
        this.impure();
        this.useStack();
    }

    @Override
    public void visit(MultiGet node) {
        this.assign(node.dest(), this.typeOf(node.src()).get(node.idx()));
    }

    @Override
    public void visit(PhiStore node) {
        this.assign(node.dest(), this.typeOf(node.src()));
    }

    @Override
    public void visit(PhiLoad node) {
        this.assign(node.dest(), this.typeOf(node.src()));
    }

    @Override
    public void visit(Closure node) {
        for (AbstractVar av : node.args()) {
            if (!(av instanceof Var)) continue;
            Var v = (Var)av;
            this.currentVarState().load(v);
            this.reifiedVars.add(v);
        }
        AbstractType t = LuaTypes.FUNCTION;
        this.assign(node.dest(), (Type)t);
    }

    @Override
    public void visit(ToNumber node) {
        Type t = this.typeOf(node.src());
        Type result = t.isSubtypeOf(LuaTypes.NUMBER) ? t : LuaTypes.NUMBER;
        this.assign(node.dest(), result);
    }

    private class VarState {
        private final Map<Var, Type> types;

        private VarState(Map<Var, Type> types) {
            this.types = Objects.requireNonNull(types);
        }

        public VarState() {
            this(new HashMap<Var, Type>());
        }

        public VarState copy() {
            return new VarState(new HashMap<Var, Type>(this.types));
        }

        public void store(Var v, Type t) {
            Objects.requireNonNull(v);
            TyperVisitor.this.allVars.add(v);
            this.types.put(v, Objects.requireNonNull(t));
        }

        public Type load(Var v) {
            Objects.requireNonNull(v);
            TyperVisitor.this.allVars.add(v);
            Type t = this.types.get(Objects.requireNonNull(v));
            if (t == null) {
                throw new IllegalStateException(v + " used before stored into");
            }
            return t;
        }

        public boolean joinWith(VarState that) {
            Type t;
            Objects.requireNonNull(that);
            HashMap<Var, Type> result = new HashMap<Var, Type>();
            for (Var v : this.types.keySet()) {
                t = TyperVisitor.joinTypes(this.types.get(v), that.types.get(v));
                result.put(v, Objects.requireNonNull(t));
            }
            for (Var v : that.types.keySet()) {
                t = TyperVisitor.joinTypes(this.types.get(v), that.types.get(v));
                result.put(v, Objects.requireNonNull(t));
            }
            if (!result.equals(this.types)) {
                this.types.clear();
                this.types.putAll(result);
                return true;
            }
            return false;
        }

        public void clearReifiedVars() {
            for (Var v : this.types.keySet()) {
                if (!TyperVisitor.this.reifiedVars.contains(v)) continue;
                this.store(v, LuaTypes.ANY);
            }
        }
    }
}

