/*
 * Decompiled with CFR 0.152.
 */
package org.classdump.luna.compiler.analysis.types;

import java.util.Objects;
import org.classdump.luna.compiler.analysis.types.AbstractType;
import org.classdump.luna.compiler.analysis.types.ConcreteType;
import org.classdump.luna.compiler.analysis.types.DynamicType;
import org.classdump.luna.compiler.analysis.types.Type;
import org.classdump.luna.compiler.analysis.types.TypeSeq;

public class FunctionType
extends ConcreteType {
    protected final AbstractType supertype;
    protected final TypeSeq typeSeq;
    protected final TypeSeq returnTypes;

    FunctionType(AbstractType supertype, TypeSeq arg, TypeSeq ret) {
        super(supertype, supertype.name);
        this.supertype = Objects.requireNonNull(supertype);
        this.typeSeq = Objects.requireNonNull(arg);
        this.returnTypes = Objects.requireNonNull(ret);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FunctionType that = (FunctionType)o;
        return this.typeSeq.equals(that.typeSeq) && this.returnTypes.equals(that.returnTypes);
    }

    public int hashCode() {
        int result = this.typeSeq.hashCode();
        result = 31 * result + this.returnTypes.hashCode();
        return result;
    }

    @Override
    public String toString() {
        return this.name + this.argumentTypes().toString() + "->" + this.returnTypes().toString();
    }

    @Deprecated
    public String toExplicitString() {
        return "(" + this.argumentTypes().toString() + ") -> (" + this.returnTypes().toString() + ")";
    }

    public TypeSeq argumentTypes() {
        return this.typeSeq;
    }

    public TypeSeq returnTypes() {
        return this.returnTypes;
    }

    @Override
    public boolean isSubtypeOf(Type that) {
        Objects.requireNonNull(that);
        if (this.equals(that)) {
            return true;
        }
        if (that instanceof FunctionType) {
            FunctionType ft = (FunctionType)that;
            return ft.argumentTypes().isSubsumedBy(this.argumentTypes()) && this.returnTypes().isSubsumedBy(ft.returnTypes());
        }
        return this.supertype().isSubtypeOf(that);
    }

    @Override
    public Type join(Type that) {
        Objects.requireNonNull(that);
        if (this.isSubtypeOf(that)) {
            return that;
        }
        if (that instanceof FunctionType) {
            FunctionType ft = (FunctionType)that;
            TypeSeq arg = this.argumentTypes().meet(ft.argumentTypes());
            TypeSeq ret = this.returnTypes().join(ft.returnTypes());
            return arg != null && ret != null ? new FunctionType(this.supertype, arg, ret) : null;
        }
        return this.supertype().join(that);
    }

    @Override
    public Type meet(Type that) {
        Objects.requireNonNull(that);
        if (this.isSubtypeOf(that)) {
            return this;
        }
        if (that.isSubtypeOf(this)) {
            return that;
        }
        if (that instanceof FunctionType) {
            FunctionType ft = (FunctionType)that;
            TypeSeq arg = this.argumentTypes().join(ft.argumentTypes());
            TypeSeq ret = this.returnTypes().meet(ft.returnTypes());
            return arg != null && ret != null ? new FunctionType(this.supertype, arg, ret) : null;
        }
        return null;
    }

    @Override
    public Type restrict(Type that) {
        if (that instanceof FunctionType) {
            FunctionType thatFt = (FunctionType)that;
            return new FunctionType(this.supertype, this.argumentTypes().restrict(thatFt.argumentTypes()), this.returnTypes().restrict(thatFt.returnTypes()));
        }
        return that instanceof DynamicType ? that : this;
    }

    @Override
    public boolean isConsistentWith(Type that) {
        if (that instanceof FunctionType) {
            FunctionType thatFunc = (FunctionType)that;
            return this.argumentTypes().isConsistentWith(thatFunc.argumentTypes()) && this.returnTypes().isConsistentWith(thatFunc.returnTypes());
        }
        return super.isConsistentWith(that);
    }
}

