/*
 * Decompiled with CFR 0.152.
 */
package org.classdump.luna.compiler.gen.asm.helpers;

import java.util.Arrays;
import java.util.Objects;
import org.classdump.luna.shaded.org.objectweb.asm.Type;
import org.classdump.luna.shaded.org.objectweb.asm.tree.AbstractInsnNode;
import org.classdump.luna.shaded.org.objectweb.asm.tree.FrameNode;
import org.classdump.luna.shaded.org.objectweb.asm.tree.InsnNode;
import org.classdump.luna.shaded.org.objectweb.asm.tree.IntInsnNode;
import org.classdump.luna.shaded.org.objectweb.asm.tree.LdcInsnNode;
import org.classdump.luna.shaded.org.objectweb.asm.tree.MethodInsnNode;
import org.classdump.luna.shaded.org.objectweb.asm.tree.TypeInsnNode;

public abstract class ASMUtils {
    private ASMUtils() {
    }

    public static Type arrayTypeFor(Class<?> clazz) {
        return ASMUtils.arrayTypeFor(clazz, 1);
    }

    public static Type arrayTypeFor(Class<?> clazz, int dimensions) {
        Objects.requireNonNull(clazz);
        if (dimensions < 1) {
            throw new IllegalArgumentException("dimensions must be at least 1");
        }
        String prefix = "[";
        for (int i = 1; i < dimensions; ++i) {
            prefix = prefix + "[";
        }
        return Type.getType(prefix + Type.getType(clazz).getDescriptor());
    }

    public static Type typeForClassName(String className) {
        Objects.requireNonNull(className);
        return Type.getType("L" + className.replace(".", "/") + ";");
    }

    public static Type[] fillTypes(Type t, int n) {
        Object[] result = new Type[n];
        Arrays.fill(result, t);
        return result;
    }

    public static FrameNode frameSame() {
        return new FrameNode(3, 0, null, 0, null);
    }

    public static FrameNode frameSame1(Class clazz) {
        return new FrameNode(4, 0, null, 1, new Object[]{Type.getInternalName(clazz)});
    }

    public static AbstractInsnNode checkCast(Class clazz) {
        return new TypeInsnNode(192, Type.getInternalName(clazz));
    }

    public static AbstractInsnNode loadInt(int i) {
        switch (i) {
            case -1: {
                return new InsnNode(2);
            }
            case 0: {
                return new InsnNode(3);
            }
            case 1: {
                return new InsnNode(4);
            }
            case 2: {
                return new InsnNode(5);
            }
            case 3: {
                return new InsnNode(6);
            }
            case 4: {
                return new InsnNode(7);
            }
            case 5: {
                return new InsnNode(8);
            }
        }
        if (i >= -128 && i <= 127) {
            return new IntInsnNode(16, i);
        }
        if (i >= Short.MIN_VALUE && i <= Short.MAX_VALUE) {
            return new IntInsnNode(17, i);
        }
        return new LdcInsnNode((Object)i);
    }

    public static AbstractInsnNode loadLong(long l) {
        if (l == 0L) {
            return new InsnNode(9);
        }
        if (l == 1L) {
            return new InsnNode(10);
        }
        return new LdcInsnNode(l);
    }

    public static AbstractInsnNode loadDouble(double d) {
        if (Double.valueOf(d).equals(0.0)) {
            return new InsnNode(14);
        }
        if (d == 1.0) {
            return new InsnNode(15);
        }
        return new LdcInsnNode(d);
    }

    public static MethodInsnNode ctor(Type of, Type ... args) {
        return new MethodInsnNode(183, of.getInternalName(), "<init>", Type.getMethodDescriptor(Type.VOID_TYPE, args), false);
    }

    public static MethodInsnNode ctor(Class clazz, Class ... args) {
        Type[] argTypes = new Type[args.length];
        for (int i = 0; i < args.length; ++i) {
            argTypes[i] = Type.getType(args[i]);
        }
        return ASMUtils.ctor(Type.getType(clazz), argTypes);
    }
}

