/*
 * Decompiled with CFR 0.152.
 */
package org.classdump.luna.compiler.gen.asm.helpers;

import java.util.Objects;
import org.classdump.luna.compiler.gen.asm.helpers.ASMUtils;
import org.classdump.luna.shaded.org.objectweb.asm.Type;
import org.classdump.luna.shaded.org.objectweb.asm.tree.AbstractInsnNode;
import org.classdump.luna.shaded.org.objectweb.asm.tree.FieldInsnNode;
import org.classdump.luna.shaded.org.objectweb.asm.tree.InsnList;
import org.classdump.luna.shaded.org.objectweb.asm.tree.InsnNode;
import org.classdump.luna.shaded.org.objectweb.asm.tree.LdcInsnNode;
import org.classdump.luna.shaded.org.objectweb.asm.tree.MethodInsnNode;
import org.classdump.luna.shaded.org.objectweb.asm.tree.TypeInsnNode;

public class BoxedPrimitivesMethods {
    private BoxedPrimitivesMethods() {
    }

    public static AbstractInsnNode loadNull() {
        return new InsnNode(1);
    }

    public static AbstractInsnNode loadBoxedBoolean(boolean value) {
        return new FieldInsnNode(178, Type.getInternalName(Boolean.class), value ? "TRUE" : "FALSE", Type.getDescriptor(Boolean.class));
    }

    public static AbstractInsnNode booleanValue() {
        return new MethodInsnNode(182, Type.getInternalName(Boolean.class), "booleanValue", Type.getMethodDescriptor(Type.BOOLEAN_TYPE, new Type[0]), false);
    }

    public static AbstractInsnNode intValue(Class clazz) {
        return new MethodInsnNode(182, Type.getInternalName(clazz), "intValue", Type.getMethodDescriptor(Type.INT_TYPE, new Type[0]), false);
    }

    public static AbstractInsnNode longValue(Class clazz) {
        return new MethodInsnNode(182, Type.getInternalName(clazz), "longValue", Type.getMethodDescriptor(Type.LONG_TYPE, new Type[0]), false);
    }

    public static AbstractInsnNode doubleValue(Class clazz) {
        return new MethodInsnNode(182, Type.getInternalName(clazz), "doubleValue", Type.getMethodDescriptor(Type.DOUBLE_TYPE, new Type[0]), false);
    }

    public static MethodInsnNode box(Type from, Type to) {
        return new MethodInsnNode(184, to.getInternalName(), "valueOf", Type.getMethodDescriptor(to, from), false);
    }

    public static MethodInsnNode box(Type from, Class to) {
        return BoxedPrimitivesMethods.box(from, Type.getType(to));
    }

    public static AbstractInsnNode unbox(Class clazz, Type requiredType) {
        if (requiredType.equals(Type.LONG_TYPE)) {
            return BoxedPrimitivesMethods.longValue(clazz);
        }
        if (requiredType.equals(Type.INT_TYPE)) {
            return BoxedPrimitivesMethods.intValue(clazz);
        }
        if (requiredType.equals(Type.DOUBLE_TYPE)) {
            return BoxedPrimitivesMethods.doubleValue(clazz);
        }
        throw new UnsupportedOperationException("Unsupported primitive type: " + requiredType);
    }

    public static InsnList loadBoxedConstant(Object k, Class<?> castTo) {
        InsnList il = new InsnList();
        if (k == null) {
            il.add(BoxedPrimitivesMethods.loadNull());
        } else if (k instanceof Boolean) {
            il.add(BoxedPrimitivesMethods.loadBoxedBoolean((Boolean)k));
        } else if (k instanceof Double || k instanceof Float) {
            il.add(ASMUtils.loadDouble(((Number)k).doubleValue()));
            il.add(BoxedPrimitivesMethods.box(Type.DOUBLE_TYPE, Type.getType(Double.class)));
        } else if (k instanceof Number) {
            il.add(ASMUtils.loadLong(((Number)k).longValue()));
            il.add(BoxedPrimitivesMethods.box(Type.LONG_TYPE, Type.getType(Long.class)));
        } else if (k instanceof String) {
            il.add(new LdcInsnNode(k));
        } else {
            throw new UnsupportedOperationException("Illegal constant type: " + k.getClass());
        }
        if (castTo != null) {
            Objects.requireNonNull(k);
            if (!castTo.isAssignableFrom(k.getClass())) {
                il.add(new TypeInsnNode(192, Type.getInternalName(castTo)));
            }
        }
        return il;
    }

    public static InsnList loadBoxedConstant(Object k) {
        return BoxedPrimitivesMethods.loadBoxedConstant(k, null);
    }

    public static AbstractInsnNode loadNumericValue(Number n, Type requiredType) {
        if (n instanceof Double || n instanceof Float) {
            if (requiredType.equals(Type.LONG_TYPE)) {
                return ASMUtils.loadLong(n.longValue());
            }
            if (requiredType.equals(Type.INT_TYPE)) {
                return ASMUtils.loadInt(n.intValue());
            }
            if (requiredType.equals(Type.DOUBLE_TYPE)) {
                return ASMUtils.loadDouble(n.doubleValue());
            }
            throw new UnsupportedOperationException("Unsupported required type: " + requiredType);
        }
        if (requiredType.equals(Type.LONG_TYPE)) {
            return ASMUtils.loadLong(n.longValue());
        }
        if (requiredType.equals(Type.INT_TYPE)) {
            return ASMUtils.loadInt(n.intValue());
        }
        if (requiredType.equals(Type.DOUBLE_TYPE)) {
            return ASMUtils.loadDouble(n.doubleValue());
        }
        throw new UnsupportedOperationException("Unsupported required type: " + requiredType);
    }
}

