/*
 * Decompiled with CFR 0.152.
 */
package org.classdump.luna.compiler.ir;

import java.util.Objects;
import org.classdump.luna.ByteString;
import org.classdump.luna.compiler.ir.BodyNode;
import org.classdump.luna.compiler.ir.IRVisitor;
import org.classdump.luna.compiler.ir.Val;

public abstract class LoadConst
extends BodyNode {
    private final Val dest;

    private LoadConst(Val dest) {
        this.dest = Objects.requireNonNull(dest);
    }

    public Val dest() {
        return this.dest;
    }

    public static class Str
    extends LoadConst {
        private final ByteString value;

        public Str(Val dest, ByteString value) {
            super(dest);
            this.value = Objects.requireNonNull(value);
        }

        @Override
        public void accept(IRVisitor visitor) {
            visitor.visit(this);
        }

        public ByteString value() {
            return this.value;
        }
    }

    public static class Flt
    extends LoadConst {
        private final double value;

        public Flt(Val dest, double value) {
            super(dest);
            this.value = value;
        }

        @Override
        public void accept(IRVisitor visitor) {
            visitor.visit(this);
        }

        public double value() {
            return this.value;
        }
    }

    public static class Int
    extends LoadConst {
        private final long value;

        public Int(Val dest, long value) {
            super(dest);
            this.value = value;
        }

        @Override
        public void accept(IRVisitor visitor) {
            visitor.visit(this);
        }

        public long value() {
            return this.value;
        }
    }

    public static class Bool
    extends LoadConst {
        private final boolean value;

        public Bool(Val dest, boolean value) {
            super(dest);
            this.value = value;
        }

        @Override
        public void accept(IRVisitor visitor) {
            visitor.visit(this);
        }

        public boolean value() {
            return this.value;
        }
    }

    public static class Nil
    extends LoadConst {
        public Nil(Val dest) {
            super(dest);
        }

        @Override
        public void accept(IRVisitor visitor) {
            visitor.visit(this);
        }
    }
}

