/*
 * Decompiled with CFR 0.152.
 */
package org.classdump.luna.compiler.tf;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.classdump.luna.compiler.FunctionId;
import org.classdump.luna.compiler.IRFunc;
import org.classdump.luna.compiler.Module;
import org.classdump.luna.compiler.analysis.DependencyAnalyser;
import org.classdump.luna.compiler.analysis.DependencyInfo;

public abstract class ModuleFilter {
    private ModuleFilter() {
    }

    private static Set<FunctionId> reachableFromMain(Module m) {
        Objects.requireNonNull(m);
        HashSet<FunctionId> visited = new HashSet<FunctionId>();
        ArrayDeque<IRFunc> open = new ArrayDeque<IRFunc>();
        open.add(m.main());
        while (!open.isEmpty()) {
            IRFunc fn = (IRFunc)open.pop();
            if (visited.add(fn.id())) continue;
            DependencyInfo depInfo = DependencyAnalyser.analyse(fn);
            for (FunctionId id : depInfo.nestedRefs()) {
                open.add(m.get(id));
            }
        }
        return Collections.unmodifiableSet(visited);
    }

    public static Module prune(Module m) {
        Objects.requireNonNull(m);
        Set<FunctionId> reachable = ModuleFilter.reachableFromMain(m);
        ArrayList<IRFunc> fns = new ArrayList<IRFunc>();
        for (IRFunc fn : m.fns()) {
            if (!reachable.contains(fn.id())) continue;
            fns.add(fn);
        }
        if (!fns.equals(m.fns())) {
            return new Module(fns);
        }
        return m;
    }
}

