/*
 * Decompiled with CFR 0.152.
 */
package org.classdump.luna.exec;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Objects;
import org.classdump.luna.load.ChunkClassLoader;
import org.classdump.luna.runtime.Dispatch;

class StackTraceback {
    public static final Entry TAIL_CALLS = MiscEntry.fromString("...tail calls...");
    private static final String JAVA_PREFIX = "[Java]: ";
    private final Entry[] entries;

    StackTraceback(Entry[] entries) {
        this.entries = Objects.requireNonNull(entries);
    }

    private static StackTraceback fromCollection(Collection<Entry> entries) {
        return new StackTraceback(Objects.requireNonNull(entries.toArray(new Entry[entries.size()])));
    }

    public String toString() {
        StringBuilder bld = new StringBuilder();
        bld.append("stack traceback:\n");
        for (Entry e : this.entries) {
            bld.append('\t').append(e.toString()).append('\n');
        }
        return bld.toString();
    }

    private static boolean isSuppressed(StackTraceElement elem, String[] suppressedClassPrefixes) {
        if (elem != null && suppressedClassPrefixes != null) {
            String className = elem.getClassName();
            for (String prefix : suppressedClassPrefixes) {
                if (!className.startsWith(prefix)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isLuaClass(ChunkClassLoader chunkClassLoader, String className) {
        return chunkClassLoader != null && className != null && chunkClassLoader.isInstalled(className);
    }

    public static StackTraceback getStackTraceback(Throwable throwable, StackTraceElement[] currentStackTrace, ChunkClassLoader chunkClassLoader, String[] suppress) {
        Objects.requireNonNull(throwable);
        ArrayDeque<Entry> entries = new ArrayDeque<Entry>();
        StackTraceElement[] causeStackTrace = throwable.getStackTrace();
        int numOmitted = 0;
        if (currentStackTrace != null) {
            StackTraceElement cur;
            StackTraceElement cau;
            int i;
            for (i = 0; i < Math.min(causeStackTrace.length, currentStackTrace.length) && (cau = causeStackTrace[causeStackTrace.length - 1 - i]).equals(cur = currentStackTrace[currentStackTrace.length - 1 - i]); ++i) {
            }
            numOmitted = i;
        }
        int suppressedSince = 0;
        int omittedSince = numOmitted;
        for (int i = causeStackTrace.length - 1 - numOmitted; i >= 0; --i) {
            String className;
            StackTraceElement elem = causeStackTrace[i];
            if (elem.getClassName().equals(Dispatch.class.getName())) {
                if (!elem.getMethodName().equals("evaluateTailCalls")) continue;
                if (suppressedSince > 0 || omittedSince > 0) {
                    entries.push(MiscJavaEntry.suppressedOrOmitted(suppressedSince, omittedSince));
                    suppressedSince = 0;
                    omittedSince = 0;
                }
                entries.push(TAIL_CALLS);
                continue;
            }
            if (StackTraceback.isSuppressed(elem, suppress)) {
                ++suppressedSince;
                continue;
            }
            if (suppressedSince > 0 || omittedSince > 0) {
                entries.push(MiscJavaEntry.suppressedOrOmitted(suppressedSince, omittedSince));
                suppressedSince = 0;
                omittedSince = 0;
            }
            if (StackTraceback.isLuaClass(chunkClassLoader, className = elem.getClassName()) && (elem.getMethodName().equals("invoke") || elem.getMethodName().equals("resume"))) {
                String fileName = elem.getFileName();
                int line = elem.getLineNumber();
                do {
                    int j;
                    if ((j = i - 1) < 0) continue;
                    StackTraceElement nextElem = causeStackTrace[j];
                    if (!Objects.equals(className, nextElem.getClassName()) || !Objects.equals(fileName, nextElem.getFileName())) break;
                    --i;
                    int l = nextElem.getLineNumber();
                    if (l < 0) continue;
                    line = l;
                } while (i >= 0);
                entries.push(LuaCallEntry.of(fileName, line, className));
                continue;
            }
            entries.push(JavaCallEntry.fromStackTraceElement(elem));
        }
        if (suppressedSince > 0 || omittedSince > 0) {
            entries.push(MiscJavaEntry.suppressedOrOmitted(suppressedSince, omittedSince));
        }
        return StackTraceback.fromCollection(entries);
    }

    private static class MiscEntry
    extends Entry {
        private final String s;

        MiscEntry(String s) {
            this.s = Objects.requireNonNull(s);
        }

        public static MiscEntry fromString(String s) {
            return new MiscEntry(s);
        }

        public String toString() {
            return "(" + this.s + ")";
        }
    }

    private static class LuaCallEntry
    extends Entry {
        private final String sourceFileName;
        private final int sourceLine;
        private final String functionName;

        LuaCallEntry(String sourceFileName, int sourceLine, String functionName) {
            this.sourceFileName = sourceFileName;
            this.sourceLine = sourceLine;
            this.functionName = Objects.requireNonNull(functionName);
        }

        public static LuaCallEntry of(String sourceFileName, int sourceLine, String functionName) {
            return new LuaCallEntry(sourceFileName, sourceLine, functionName);
        }

        public String toString() {
            return (this.sourceFileName != null ? this.sourceFileName : "?") + ":" + (this.sourceLine >= 0 ? Integer.valueOf(this.sourceLine) : "?") + ": in function <" + this.functionName + ">";
        }
    }

    private static class MiscJavaEntry
    extends Entry {
        private final String s;

        MiscJavaEntry(String s) {
            this.s = Objects.requireNonNull(s);
        }

        public static MiscJavaEntry suppressedOrOmitted(int suppressed, int omitted) {
            if (suppressed > 0 || omitted > 0) {
                StringBuilder bld = new StringBuilder();
                if (suppressed > 0) {
                    bld.append(suppressed).append(" suppressed");
                    if (omitted > 0) {
                        bld.append(", ");
                    }
                }
                if (omitted > 0) {
                    bld.append(omitted).append(" omitted");
                }
                bld.append(")");
                return new MiscJavaEntry(bld.toString());
            }
            throw new IllegalArgumentException("suppressed or omitted must be positive (got " + suppressed + " and " + omitted + ")");
        }

        public String toString() {
            return "[Java]: (" + this.s + ")";
        }
    }

    private static class JavaCallEntry
    extends Entry {
        private final StackTraceElement stackTraceElement;

        JavaCallEntry(StackTraceElement stackTraceElement) {
            this.stackTraceElement = Objects.requireNonNull(stackTraceElement);
        }

        public static JavaCallEntry fromStackTraceElement(StackTraceElement element) {
            return new JavaCallEntry(element);
        }

        public String toString() {
            return StackTraceback.JAVA_PREFIX + this.stackTraceElement.toString();
        }
    }

    private static abstract class Entry {
        private Entry() {
        }
    }
}

