/*
 * Decompiled with CFR 0.152.
 */
package org.classdump.luna.impl;

import java.util.NoSuchElementException;
import org.classdump.luna.Conversions;
import org.classdump.luna.Table;
import org.classdump.luna.TableFactory;
import org.classdump.luna.util.TraversableHashMap;

public class DefaultTable
extends Table {
    private final TraversableHashMap<Object, Object> values = new TraversableHashMap();
    private static final TableFactory FACTORY_INSTANCE = new Factory();

    public static TableFactory factory() {
        return FACTORY_INSTANCE;
    }

    @Override
    public Object rawget(Object key) {
        return (key = Conversions.normaliseKey(key)) != null ? this.values.get(key) : null;
    }

    @Override
    public void rawset(Object key, Object value) {
        if ((key = Conversions.normaliseKey(key)) == null) {
            throw new IllegalArgumentException("table index is nil");
        }
        if (key instanceof Double && Double.isNaN((Double)key)) {
            throw new IllegalArgumentException("table index is NaN");
        }
        if ((value = Conversions.canonicalRepresentationOf(value)) == null) {
            this.values.remove(key);
        } else {
            this.values.put(key, value);
        }
        this.updateBasetableModes(key, value);
    }

    @Override
    public Object initialKey() {
        return this.values.getFirstKey();
    }

    @Override
    public Object successorKeyOf(Object key) {
        try {
            return this.values.getSuccessorOf(key);
        }
        catch (NullPointerException | NoSuchElementException ex) {
            throw new IllegalArgumentException("invalid key to 'next'", ex);
        }
    }

    @Override
    protected void setMode(boolean weakKeys, boolean weakValues) {
    }

    static class Factory
    implements TableFactory {
        Factory() {
        }

        @Override
        public Table newTable() {
            return this.newTable(0, 0);
        }

        @Override
        public Table newTable(int array, int hash) {
            return new DefaultTable();
        }
    }
}

