/*
 * Decompiled with CFR 0.152.
 */
package org.classdump.luna.impl;

import java.util.Collection;
import java.util.Iterator;
import org.classdump.luna.runtime.ReturnBuffer;

class PairCachingReturnBuffer
implements ReturnBuffer {
    private static final Object[] EMPTY_ARRAY = new Object[0];
    public static final int MIN_BUF_SIZE = 3;
    private static final int DEFAULT_PREFERRED_BUF_SIZE = 8;
    private final int preferredBufSize;
    private int size;
    private Object _0;
    private Object _1;
    private Object[] _buf;
    private Object tailCallTarget;
    private boolean tailCall;

    public PairCachingReturnBuffer(int preferredBufSize) {
        if (preferredBufSize < 3) {
            throw new IllegalArgumentException("Preferred array size must be at least 3");
        }
        this.preferredBufSize = preferredBufSize;
        this._0 = null;
        this._1 = null;
        this._buf = new Object[preferredBufSize];
        this.size = 0;
        this.tailCallTarget = null;
        this.tailCall = false;
    }

    public PairCachingReturnBuffer() {
        this(8);
    }

    @Override
    public boolean isCall() {
        return this.tailCall;
    }

    @Override
    public Object getCallTarget() {
        if (this.tailCall) {
            return this.tailCallTarget;
        }
        throw new IllegalStateException("Not a tail call");
    }

    protected void unsetTailCall() {
        this.tailCall = false;
        this.tailCallTarget = null;
    }

    protected void _setTailCall(Object target) {
        this.tailCall = true;
        this.tailCallTarget = target;
    }

    @Override
    public int size() {
        return this.size;
    }

    private void ensureBufSizeAtLeast(int sizeAtLeast) {
        int sz;
        int n = sz = sizeAtLeast > this.preferredBufSize ? sizeAtLeast : this.preferredBufSize;
        if (sz != this._buf.length) {
            this._buf = new Object[sz];
        } else {
            int oldSize = this.size - 2;
            for (int i = sizeAtLeast; i < oldSize; ++i) {
                this._buf[i] = null;
            }
        }
    }

    private void _set(Object a, Object b, int bufSize, int size) {
        this._0 = a;
        this._1 = b;
        this.ensureBufSizeAtLeast(bufSize);
        this.size = size;
    }

    private void _setArray(Object[] a) {
        int sz = a.length;
        int asz = sz - 2;
        if (asz > 0) {
            this.ensureBufSizeAtLeast(asz);
            System.arraycopy(a, 2, this._buf, 0, asz);
        } else {
            this.ensureBufSizeAtLeast(0);
        }
        Object o0 = null;
        Object o1 = null;
        switch (sz) {
            default: {
                o1 = a[1];
            }
            case 1: {
                o0 = a[0];
            }
            case 0: 
        }
        this._0 = o0;
        this._1 = o1;
        this.size = sz;
    }

    private void _setCollection(Collection<?> collection) {
        int sz = collection.size();
        this.ensureBufSizeAtLeast(Math.max(0, sz - 2));
        Iterator<?> it = collection.iterator();
        this._0 = it.hasNext() ? it.next() : null;
        this._1 = it.hasNext() ? it.next() : null;
        for (int i = 0; i < sz - 2; ++i) {
            this._buf[i] = it.next();
        }
        this.size = sz;
    }

    @Override
    public void setTo() {
        this.unsetTailCall();
        this._set(null, null, 0, 0);
    }

    @Override
    public void setTo(Object a) {
        this.unsetTailCall();
        this._set(a, null, 0, 1);
    }

    @Override
    public void setTo(Object a, Object b) {
        this.unsetTailCall();
        this._set(a, b, 0, 2);
    }

    @Override
    public void setTo(Object a, Object b, Object c) {
        this.unsetTailCall();
        this._set(a, b, 1, 3);
        this._buf[0] = c;
    }

    @Override
    public void setTo(Object a, Object b, Object c, Object d) {
        this.unsetTailCall();
        this._set(a, b, 2, 4);
        this._buf[0] = c;
        this._buf[1] = d;
    }

    @Override
    public void setTo(Object a, Object b, Object c, Object d, Object e) {
        this.unsetTailCall();
        this._set(a, b, 3, 5);
        this._buf[0] = c;
        this._buf[1] = d;
        this._buf[2] = e;
    }

    @Override
    public void setToContentsOf(Object[] a) {
        this.unsetTailCall();
        this._setArray(a);
    }

    @Override
    public void setToContentsOf(Collection<?> collection) {
        this.unsetTailCall();
        this._setCollection(collection);
    }

    @Override
    public void setToCall(Object target) {
        this._setTailCall(target);
        this._set(null, null, 0, 0);
    }

    @Override
    public void setToCall(Object target, Object arg1) {
        this._setTailCall(target);
        this._set(arg1, null, 0, 1);
    }

    @Override
    public void setToCall(Object target, Object arg1, Object arg2) {
        this._setTailCall(target);
        this._set(arg1, arg2, 0, 2);
    }

    @Override
    public void setToCall(Object target, Object arg1, Object arg2, Object arg3) {
        this._setTailCall(target);
        this._set(arg1, arg2, 1, 3);
        this._buf[0] = arg3;
    }

    @Override
    public void setToCall(Object target, Object arg1, Object arg2, Object arg3, Object arg4) {
        this._setTailCall(target);
        this._set(arg1, arg2, 2, 4);
        this._buf[0] = arg3;
        this._buf[1] = arg4;
    }

    @Override
    public void setToCall(Object target, Object arg1, Object arg2, Object arg3, Object arg4, Object arg5) {
        this._setTailCall(target);
        this._set(arg1, arg2, 3, 5);
        this._buf[0] = arg3;
        this._buf[1] = arg4;
        this._buf[2] = arg5;
    }

    @Override
    public void setToCallWithContentsOf(Object target, Object[] args) {
        this._setTailCall(target);
        this._setArray(args);
    }

    @Override
    public void setToCallWithContentsOf(Object target, Collection<?> args) {
        this._setTailCall(target);
        this._setCollection(args);
    }

    @Override
    public Object[] getAsArray() {
        switch (this.size) {
            case 0: {
                return EMPTY_ARRAY;
            }
            case 1: {
                return new Object[]{this._0};
            }
            case 2: {
                return new Object[]{this._0, this._1};
            }
        }
        Object[] result = new Object[this.size];
        result[0] = this._0;
        result[1] = this._1;
        System.arraycopy(this._buf, 0, result, 2, this.size - 2);
        return result;
    }

    @Override
    public Object get(int idx) {
        if (idx < 0) {
            return null;
        }
        switch (idx) {
            case 0: {
                return this._0;
            }
            case 1: {
                return this._1;
            }
        }
        return idx < this.size ? this._buf[idx - 2] : null;
    }

    @Override
    public Object get0() {
        return this._0;
    }

    @Override
    public Object get1() {
        return this._1;
    }

    @Override
    public Object get2() {
        return this._buf[0];
    }

    @Override
    public Object get3() {
        return this._buf[1];
    }

    @Override
    public Object get4() {
        return this._buf[2];
    }
}

