/*
 * Decompiled with CFR 0.152.
 */
package org.classdump.luna.lib;

import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import org.classdump.luna.ByteString;
import org.classdump.luna.Conversions;
import org.classdump.luna.LuaFormat;
import org.classdump.luna.LuaObject;
import org.classdump.luna.MetatableProvider;
import org.classdump.luna.Table;
import org.classdump.luna.Userdata;
import org.classdump.luna.ValueTypeNamer;
import org.classdump.luna.lib.BadArgumentException;
import org.classdump.luna.lib.NameMetamethodValueTypeNamer;
import org.classdump.luna.lib.UnexpectedArgumentException;
import org.classdump.luna.runtime.Coroutine;
import org.classdump.luna.runtime.LuaFunction;
import org.classdump.luna.util.Check;

public class ArgumentIterator
implements Iterator<Object> {
    private final ValueTypeNamer namer;
    private final String name;
    private final Object[] args;
    private int index;

    private ArgumentIterator(ValueTypeNamer namer, String name, Object[] args, int index) {
        this.namer = Objects.requireNonNull(namer);
        this.name = Objects.requireNonNull(name);
        this.args = Objects.requireNonNull(args);
        this.index = Check.nonNegative(index);
    }

    ArgumentIterator(ValueTypeNamer namer, String name, Object[] args) {
        this(namer, name, args, 0);
    }

    public static ArgumentIterator of(MetatableProvider metatableProvider, String name, Object[] args) {
        return new ArgumentIterator(new NameMetamethodValueTypeNamer(metatableProvider), name, Arrays.copyOf(args, args.length));
    }

    @Override
    public boolean hasNext() {
        return this.index < this.args.length;
    }

    @Override
    public Object next() {
        Object o = this.peek();
        this.skip();
        return o;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public int position() {
        return this.index;
    }

    public int size() {
        return this.args.length;
    }

    public int remaining() {
        return Math.max(this.args.length - this.index, 0);
    }

    public void skip() {
        ++this.index;
        if (this.index < 0) {
            throw new IllegalStateException("index overflow");
        }
    }

    public void goTo(int index) {
        this.index = Check.nonNegative(index);
    }

    public void rewind() {
        this.goTo(0);
    }

    public Object[] copyAll() {
        return Arrays.copyOf(this.args, this.args.length);
    }

    public Object[] copyRemaining() {
        return this.index <= this.args.length ? Arrays.copyOfRange(this.args, this.index, this.args.length) : new Object[]{};
    }

    private BadArgumentException badArgument(Throwable cause) {
        return new BadArgumentException(this.index + 1, this.name, cause);
    }

    public Object peek() {
        if (this.index < this.args.length) {
            return this.args[this.index];
        }
        throw new NoSuchElementException("value expected");
    }

    private Object peek(String expectedType) {
        try {
            return this.peek();
        }
        catch (NoSuchElementException ex) {
            throw new UnexpectedArgumentException(expectedType, "no value");
        }
    }

    private Number peekNumber() {
        Object arg = this.peek(LuaFormat.TYPENAME_NUMBER.toString());
        Number n = Conversions.numericalValueOf(arg);
        if (n != null) {
            return n;
        }
        throw new UnexpectedArgumentException(LuaFormat.TYPENAME_NUMBER.toString(), this.namer.typeNameOf(arg).toString());
    }

    public Object nextAny() {
        Object result;
        try {
            result = this.peek();
        }
        catch (RuntimeException ex) {
            throw this.badArgument(ex);
        }
        this.skip();
        return result;
    }

    public boolean nextBoolean() {
        boolean result;
        try {
            result = Conversions.booleanValueOf(this.peek());
        }
        catch (RuntimeException ex) {
            throw this.badArgument(ex);
        }
        this.skip();
        return result;
    }

    public Number nextNumber() {
        Number result;
        try {
            result = this.peekNumber();
        }
        catch (RuntimeException ex) {
            throw this.badArgument(ex);
        }
        this.skip();
        return result;
    }

    public long nextInteger() {
        long result;
        try {
            result = Conversions.toIntegerValue(this.peekNumber());
        }
        catch (RuntimeException ex) {
            throw this.badArgument(ex);
        }
        this.skip();
        return result;
    }

    public double nextFloat() {
        return this.nextNumber().doubleValue();
    }

    public int nextInt() {
        int result;
        try {
            long l = Conversions.toIntegerValue(this.peekNumber());
            result = (int)l;
            if (l != (long)result) {
                throw new IllegalArgumentException("integer does not fit in 32 bits");
            }
        }
        catch (RuntimeException ex) {
            throw this.badArgument(ex);
        }
        this.skip();
        return result;
    }

    public int nextIntRange(int min, int max, String rangeName) {
        int result;
        try {
            long value = Conversions.toIntegerValue(this.peekNumber());
            if (value < (long)min || value > (long)max) {
                throw new IndexOutOfBoundsException((rangeName != null ? rangeName : "value") + " out of range");
            }
            result = (int)value;
        }
        catch (RuntimeException ex) {
            throw this.badArgument(ex);
        }
        this.skip();
        return result;
    }

    public int nextIntRange(int min, int max) {
        return this.nextIntRange(min, max, null);
    }

    public ByteString nextString() {
        ByteString result;
        try {
            Object arg = this.peek(LuaFormat.TYPENAME_STRING.toString());
            ByteString v = Conversions.stringValueOf(arg);
            if (v == null) {
                throw new UnexpectedArgumentException(LuaFormat.TYPENAME_STRING.toString(), this.namer.typeNameOf(arg).toString());
            }
            result = v;
        }
        catch (RuntimeException ex) {
            throw this.badArgument(ex);
        }
        this.skip();
        return result;
    }

    public ByteString nextStrictString() {
        ByteString result;
        block4: {
            try {
                Object arg = this.peek(LuaFormat.TYPENAME_STRING.toString());
                if (arg instanceof ByteString) {
                    result = (ByteString)arg;
                    break block4;
                }
                if (arg instanceof String) {
                    result = ByteString.of((String)arg);
                    break block4;
                }
                throw new UnexpectedArgumentException(LuaFormat.TYPENAME_STRING.toString(), this.namer.typeNameOf(arg).toString());
            }
            catch (RuntimeException ex) {
                throw this.badArgument(ex);
            }
        }
        this.skip();
        return result;
    }

    private <T> T nextStrict(ByteString expectedTypeName, Class<T> clazz) {
        Object result;
        try {
            Object typed;
            Object arg = this.peek(expectedTypeName.toString());
            if (arg == null || !clazz.isAssignableFrom(arg.getClass())) {
                throw new UnexpectedArgumentException(expectedTypeName.toString(), this.namer.typeNameOf(arg).toString());
            }
            result = typed = arg;
        }
        catch (RuntimeException ex) {
            throw this.badArgument(ex);
        }
        this.skip();
        return (T)result;
    }

    public LuaFunction nextFunction() {
        return this.nextStrict(LuaFormat.TYPENAME_FUNCTION, LuaFunction.class);
    }

    public Table nextTable() {
        return this.nextStrict(LuaFormat.TYPENAME_TABLE, Table.class);
    }

    public Coroutine nextCoroutine() {
        return this.nextStrict(LuaFormat.TYPENAME_THREAD, Coroutine.class);
    }

    public <T extends Userdata> T nextUserdata(String typeName, Class<T> clazz) {
        return (T)((Userdata)this.nextStrict(ByteString.of(typeName), Objects.requireNonNull(clazz)));
    }

    public Userdata<Object> nextUserdata() {
        return this.nextUserdata(LuaFormat.TYPENAME_USERDATA.toString(), Userdata.class);
    }

    public LuaObject nextLuaObject() {
        return this.nextStrict(LuaFormat.TYPENAME_LUAOBJECT, LuaObject.class);
    }

    public <T> T nextOfClass(Class<T> aClass) {
        return this.nextStrict(ByteString.of(aClass.getTypeName()), aClass);
    }

    public Object nextOptionalAny(Object defaultValue) {
        return this.hasNext() ? this.nextAny() : defaultValue;
    }

    public boolean nextOptionalBoolean(boolean defaultValue) {
        return this.hasNext() ? this.nextBoolean() : defaultValue;
    }

    public long nextOptionalInteger(long defaultValue) {
        return this.hasNext() && this.peek() != null ? this.nextInteger() : defaultValue;
    }

    public double nextOptionalFloat(double defaultValue) {
        return this.hasNext() && this.peek() != null ? this.nextFloat() : defaultValue;
    }

    public int nextOptionalInt(int defaultValue) {
        return this.hasNext() && this.peek() != null ? this.nextInt() : defaultValue;
    }

    public ByteString nextOptionalString(ByteString defaultValue) {
        return this.hasNext() && this.peek() != null ? this.nextString() : defaultValue;
    }

    public LuaFunction nextOptionalFunction(LuaFunction defaultValue) {
        return this.hasNext() && this.peek() != null ? this.nextFunction() : defaultValue;
    }

    public Table nextOptionalTable(Table defaultValue) {
        return this.hasNext() && this.peek() != null ? this.nextTable() : defaultValue;
    }

    public Coroutine nextOptionalCoroutine(Coroutine defaultValue) {
        return this.hasNext() && this.peek() != null ? this.nextCoroutine() : defaultValue;
    }
}

