/*
 * Decompiled with CFR 0.152.
 */
package org.classdump.luna.lib;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import org.classdump.luna.ByteString;
import org.classdump.luna.ByteStringBuilder;
import org.classdump.luna.Conversions;
import org.classdump.luna.LuaObject;
import org.classdump.luna.LuaRuntimeException;
import org.classdump.luna.Metatables;
import org.classdump.luna.Ordering;
import org.classdump.luna.PlainValueTypeNamer;
import org.classdump.luna.StateContext;
import org.classdump.luna.Table;
import org.classdump.luna.Variable;
import org.classdump.luna.env.RuntimeEnvironment;
import org.classdump.luna.lib.AbstractLibFunction;
import org.classdump.luna.lib.ArgumentIterator;
import org.classdump.luna.lib.AssertionFailedException;
import org.classdump.luna.lib.BadArgumentException;
import org.classdump.luna.lib.ModuleLib;
import org.classdump.luna.load.ChunkLoader;
import org.classdump.luna.load.LoaderException;
import org.classdump.luna.runtime.Dispatch;
import org.classdump.luna.runtime.ExecutionContext;
import org.classdump.luna.runtime.IllegalOperationAttemptException;
import org.classdump.luna.runtime.LuaFunction;
import org.classdump.luna.runtime.ProtectedResumable;
import org.classdump.luna.runtime.ResolvedControlThrowable;
import org.classdump.luna.runtime.ReturnBuffer;
import org.classdump.luna.runtime.UnresolvedControlThrowable;

public final class BasicLib {
    public static final ByteString MT_METATABLE = ByteString.constOf("__metatable");
    public static final ByteString MT_NAME = ByteString.constOf("__name");
    public static final ByteString MT_PAIRS = ByteString.constOf("__pairs");
    public static final ByteString MT_TOSTRING = ByteString.constOf("__tostring");
    public static final ByteString TYPENAME_LIGHT_USERDATA = ByteString.constOf("light userdata");
    static final LuaFunction ASSERT = new Assert();
    static final LuaFunction COLLECTGARBAGE = new CollectGarbage();
    static final LuaFunction ERROR = new Error();
    static final LuaFunction GETMETATABLE = new GetMetatable();
    static final LuaFunction IPAIRS = new IPairs();
    static final LuaFunction NEXT = new Next();
    static final LuaFunction PAIRS = new Pairs();
    static final LuaFunction PCALL = new PCall();
    static final LuaFunction RAWEQUAL = new RawEqual();
    static final LuaFunction RAWGET = new RawGet();
    static final LuaFunction RAWLEN = new RawLen();
    static final LuaFunction RAWSET = new RawSet();
    static final LuaFunction SELECT = new Select();
    static final LuaFunction SETMETATABLE = new SetMetatable();
    static final LuaFunction TONUMBER = new ToNumber();
    static final LuaFunction TOSTRING = new ToString();
    static final LuaFunction TYPE = new Type();
    static final LuaFunction XPCALL = new XPCall();
    public static final ByteString _VERSION = ByteString.constOf("Lua 5.3");

    public static LuaFunction assertFn() {
        return ASSERT;
    }

    static LuaFunction collectgarbage() {
        return COLLECTGARBAGE;
    }

    public static LuaFunction dofile(Object env, ChunkLoader loader, FileSystem fileSystem) {
        return new DoFile(fileSystem, loader, env);
    }

    public static LuaFunction error() {
        return ERROR;
    }

    public static LuaFunction getmetatable() {
        return GETMETATABLE;
    }

    public static LuaFunction ipairs() {
        return IPAIRS;
    }

    public static LuaFunction load(Object env, ChunkLoader loader) {
        return new Load(loader, env);
    }

    public static LuaFunction loadfile(Object env, ChunkLoader loader, FileSystem fileSystem) {
        return new LoadFile(fileSystem, loader, env);
    }

    public static LuaFunction next() {
        return NEXT;
    }

    public static LuaFunction pairs() {
        return PAIRS;
    }

    public static LuaFunction pcall() {
        return PCALL;
    }

    public static LuaFunction print(OutputStream out, Object env) {
        return new Print(out, env);
    }

    public static LuaFunction rawequal() {
        return RAWEQUAL;
    }

    public static LuaFunction rawget() {
        return RAWGET;
    }

    public static LuaFunction rawlen() {
        return RAWLEN;
    }

    public static LuaFunction rawset() {
        return RAWSET;
    }

    public static LuaFunction select() {
        return SELECT;
    }

    public static LuaFunction setmetatable() {
        return SETMETATABLE;
    }

    public static LuaFunction tonumber() {
        return TONUMBER;
    }

    public static LuaFunction tostring() {
        return TOSTRING;
    }

    public static LuaFunction type() {
        return TYPE;
    }

    public static LuaFunction xpcall() {
        return XPCALL;
    }

    private BasicLib() {
    }

    public static void installInto(StateContext context, Table env, RuntimeEnvironment runtimeEnvironment, ChunkLoader loader) {
        Objects.requireNonNull(context);
        Objects.requireNonNull(env);
        OutputStream out = runtimeEnvironment != null ? runtimeEnvironment.standardOutput() : null;
        FileSystem fileSystem = runtimeEnvironment != null ? runtimeEnvironment.fileSystem() : null;
        env.rawset("assert", (Object)BasicLib.assertFn());
        env.rawset("collectgarbage", (Object)BasicLib.collectgarbage());
        if (loader != null && fileSystem != null) {
            env.rawset("dofile", (Object)BasicLib.dofile(env, loader, fileSystem));
        }
        env.rawset("error", (Object)BasicLib.error());
        env.rawset("_G", (Object)env);
        env.rawset("getmetatable", (Object)BasicLib.getmetatable());
        env.rawset("ipairs", (Object)BasicLib.ipairs());
        if (loader != null) {
            env.rawset("load", (Object)BasicLib.load(env, loader));
        }
        if (loader != null && fileSystem != null) {
            env.rawset("loadfile", (Object)BasicLib.loadfile(env, loader, fileSystem));
        }
        env.rawset("next", (Object)BasicLib.next());
        env.rawset("pairs", (Object)BasicLib.pairs());
        env.rawset("pcall", (Object)BasicLib.pcall());
        if (out != null) {
            env.rawset("print", (Object)BasicLib.print(out, env));
        }
        env.rawset("rawequal", (Object)BasicLib.rawequal());
        env.rawset("rawget", (Object)BasicLib.rawget());
        env.rawset("rawlen", (Object)BasicLib.rawlen());
        env.rawset("rawset", (Object)BasicLib.rawset());
        env.rawset("select", (Object)BasicLib.select());
        env.rawset("setmetatable", (Object)BasicLib.setmetatable());
        env.rawset("tostring", (Object)BasicLib.tostring());
        env.rawset("tonumber", (Object)BasicLib.tonumber());
        env.rawset("type", (Object)BasicLib.type());
        env.rawset("_VERSION", (Object)_VERSION);
        env.rawset("xpcall", (Object)BasicLib.xpcall());
        ModuleLib.addToLoaded(env, "_G", env);
    }

    static LuaFunction loadTextChunkFromFile(FileSystem fileSystem, ChunkLoader loader, String fileName, ByteString modeString, Object env) throws LoaderException {
        LuaFunction fn;
        try {
            Path p = fileSystem.getPath(fileName, new String[0]);
            if (!modeString.contains((byte)116)) {
                throw new LuaRuntimeException((Object)("attempt to load a text chunk (mode is '" + modeString + "')"));
            }
            byte[] bytes = Files.readAllBytes(p);
            ByteString chunkText = ByteString.copyOf(bytes);
            fn = loader.loadTextChunk(new Variable(env), fileName, chunkText.toString());
        }
        catch (IOException | InvalidPathException ex) {
            throw new LoaderException(ex, fileName);
        }
        if (fn == null) {
            throw new LuaRuntimeException((Object)"loader returned nil");
        }
        return fn;
    }

    static class DoFile
    extends AbstractLibFunction {
        private final FileSystem fileSystem;
        private final ChunkLoader loader;
        private final Object env;

        public DoFile(FileSystem fileSystem, ChunkLoader loader, Object env) {
            this.fileSystem = Objects.requireNonNull(fileSystem);
            this.loader = Objects.requireNonNull(loader);
            this.env = env;
        }

        @Override
        protected String name() {
            return "dofile";
        }

        @Override
        protected void invoke(ExecutionContext context, ArgumentIterator args) throws ResolvedControlThrowable {
            LuaFunction fn;
            ByteString fileName = args.nextOptionalString(null);
            if (fileName == null) {
                throw new UnsupportedOperationException("not supported: 'dofile' from stdin");
            }
            try {
                fn = BasicLib.loadTextChunkFromFile(this.fileSystem, this.loader, fileName.toString(), Load.DEFAULT_MODE, this.env);
            }
            catch (LoaderException ex) {
                throw new LuaRuntimeException((Object)ex.getLuaStyleErrorMessage());
            }
            try {
                Dispatch.call(context, fn);
            }
            catch (UnresolvedControlThrowable ct) {
                ct.resolve(this, null);
            }
        }

        @Override
        public void resume(ExecutionContext context, Object suspendedState) throws ResolvedControlThrowable {
        }
    }

    static class LoadFile
    extends AbstractLibFunction {
        private final FileSystem fileSystem;
        private final ChunkLoader loader;
        private final Object defaultEnv;

        public LoadFile(FileSystem fileSystem, ChunkLoader loader, Object defaultEnv) {
            this.fileSystem = Objects.requireNonNull(fileSystem);
            this.loader = Objects.requireNonNull(loader);
            this.defaultEnv = defaultEnv;
        }

        @Override
        protected String name() {
            return "loadfile";
        }

        @Override
        protected void invoke(ExecutionContext context, ArgumentIterator args) throws ResolvedControlThrowable {
            LuaFunction fn;
            String chunkName;
            ByteString fileName = args.nextOptionalString(null);
            ByteString modeString = args.nextOptionalString(Load.DEFAULT_MODE);
            Object env = args.nextOptionalAny(this.defaultEnv);
            boolean isStdin = fileName == null;
            String string = chunkName = isStdin ? "stdin" : fileName.toString();
            if (isStdin) {
                context.getReturnBuffer().setTo(null, "not supported: loadfile from stdin");
                return;
            }
            try {
                fn = BasicLib.loadTextChunkFromFile(this.fileSystem, this.loader, chunkName, modeString, env);
            }
            catch (LoaderException ex) {
                context.getReturnBuffer().setTo(null, ex.getLuaStyleErrorMessage());
                return;
            }
            assert (fn != null);
            context.getReturnBuffer().setTo(fn);
        }
    }

    static class Load
    extends AbstractLibFunction {
        static final ByteString DEFAULT_MODE = ByteString.constOf("bt");
        private final ChunkLoader loader;
        private final Object defaultEnv;

        public Load(ChunkLoader loader, Object env) {
            this.loader = Objects.requireNonNull(loader);
            this.defaultEnv = env;
        }

        @Override
        protected String name() {
            return "load";
        }

        @Override
        protected void invoke(ExecutionContext context, ArgumentIterator args) throws ResolvedControlThrowable {
            String chunkName;
            LuaFunction chunk;
            LuaFunction luaFunction = chunk = args.hasNext() && Conversions.stringValueOf(args.peek()) != null ? args.nextString() : args.nextFunction();
            assert (chunk != null);
            if (args.hasNext() && args.peek() != null) {
                chunkName = "[string \"" + args.nextString() + "\"]";
            } else {
                if (args.hasNext()) {
                    args.skip();
                }
                chunkName = chunk instanceof ByteString ? "[string \"" + chunk + "\"]" : "=(load)";
            }
            ByteString modeString = args.nextOptionalString(DEFAULT_MODE);
            Object env = args.nextOptionalAny(this.defaultEnv);
            if (!modeString.contains((byte)116)) {
                ByteStringBuilder bld = new ByteStringBuilder();
                bld.append("attempt to load a text chunk (mode is '").append(modeString).append("')");
                context.getReturnBuffer().setTo(null, bld.toByteString());
            } else if (chunk instanceof ByteString) {
                this.loadFromString(context, chunkName, env, (ByteString)((Object)chunk));
            } else {
                LuaFunction fn = chunk;
                this.loadFromFunction(context, false, chunkName, env, new ByteStringBuilder(), fn);
            }
        }

        private void loadFromString(ExecutionContext context, String chunkName, Object env, ByteString chunkText) {
            LuaFunction fn;
            try {
                fn = this.loader.loadTextChunk(new Variable(env), chunkName, chunkText.toString());
            }
            catch (LoaderException ex) {
                context.getReturnBuffer().setTo(null, ex.getLuaStyleErrorMessage());
                return;
            }
            if (fn != null) {
                context.getReturnBuffer().setTo(fn);
            } else {
                context.getReturnBuffer().setTo(null, "loader returned nil");
            }
        }

        private void loadFromFunction(ExecutionContext context, boolean resuming, String chunkName, Object env, ByteStringBuilder bld, LuaFunction fn) throws ResolvedControlThrowable {
            ByteString chunkText = null;
            try {
                while (chunkText == null) {
                    if (!resuming) {
                        Dispatch.call(context, fn);
                    }
                    resuming = false;
                    Object o = context.getReturnBuffer().get0();
                    if (o == null) {
                        chunkText = bld.toByteString();
                        continue;
                    }
                    ByteString s = Conversions.stringValueOf(o);
                    if (s != null) {
                        bld.append(s);
                        continue;
                    }
                    context.getReturnBuffer().setTo(null, "reader function must return a string");
                    return;
                }
            }
            catch (UnresolvedControlThrowable ct) {
                throw ct.resolve(this, new State(chunkName, env, bld, fn));
            }
            assert (chunkText != null);
            this.loadFromString(context, chunkName, env, chunkText);
        }

        @Override
        public void resume(ExecutionContext context, Object suspendedState) throws ResolvedControlThrowable {
            State state = (State)suspendedState;
            this.loadFromFunction(context, true, state.chunkName, state.env, state.bld, state.fn);
        }

        private static class State {
            public final String chunkName;
            public final Object env;
            public final ByteStringBuilder bld;
            public final LuaFunction fn;

            private State(String chunkName, Object env, ByteStringBuilder bld, LuaFunction fn) {
                this.chunkName = chunkName;
                this.env = env;
                this.bld = bld;
                this.fn = fn;
            }
        }
    }

    static class CollectGarbage
    extends AbstractLibFunction {
        CollectGarbage() {
        }

        @Override
        protected String name() {
            return "collectgarbage";
        }

        @Override
        protected void invoke(ExecutionContext context, ArgumentIterator args) throws ResolvedControlThrowable {
            if (args.hasNext()) {
                throw new UnsupportedOperationException();
            }
        }
    }

    static class Select
    extends AbstractLibFunction {
        Select() {
        }

        @Override
        protected String name() {
            return "select";
        }

        private static boolean isHash(Object o) {
            if (o instanceof ByteString) {
                return ((ByteString)o).startsWith((byte)35);
            }
            if (o instanceof String) {
                return ((String)o).startsWith("#");
            }
            return false;
        }

        @Override
        protected void invoke(ExecutionContext context, ArgumentIterator args) throws ResolvedControlThrowable {
            Object index;
            Object object = index = args.hasNext() ? args.peek() : null;
            if (Select.isHash(index)) {
                int count = args.size() - 1;
                context.getReturnBuffer().setTo(count);
            } else {
                int from;
                int idx = args.nextIntRange(-args.size() + 1, Integer.MAX_VALUE, "index");
                int n = from = idx >= 0 ? idx : args.size() + idx;
                if (from < 1) {
                    throw new BadArgumentException(1, this.name(), "index out of range");
                }
                Object[] r = args.copyAll();
                Object[] result = from > r.length ? new Object[]{} : Arrays.copyOfRange(r, from, r.length);
                context.getReturnBuffer().setToContentsOf(result);
            }
        }
    }

    static class RawLen
    extends AbstractLibFunction {
        RawLen() {
        }

        @Override
        protected String name() {
            return "rawlen";
        }

        @Override
        protected void invoke(ExecutionContext context, ArgumentIterator args) throws ResolvedControlThrowable {
            long result;
            Object arg1 = args.nextOptionalAny(null);
            if (arg1 instanceof Table) {
                Table table = (Table)arg1;
                result = table.rawlen();
            } else if (arg1 instanceof ByteString) {
                ByteString s = (ByteString)arg1;
                result = s.length();
            } else if (arg1 instanceof String) {
                String s = (String)arg1;
                result = Dispatch.len(s);
            } else {
                throw new BadArgumentException(1, this.name(), "table or string expected");
            }
            context.getReturnBuffer().setTo(result);
        }
    }

    static class RawSet
    extends AbstractLibFunction {
        RawSet() {
        }

        @Override
        protected String name() {
            return "rawset";
        }

        @Override
        protected void invoke(ExecutionContext context, ArgumentIterator args) throws ResolvedControlThrowable {
            Table table = args.nextTable();
            Object key = args.nextAny();
            Object value = args.nextAny();
            table.rawset(key, value);
            context.getReturnBuffer().setTo(table);
        }
    }

    static class RawGet
    extends AbstractLibFunction {
        RawGet() {
        }

        @Override
        protected String name() {
            return "rawget";
        }

        @Override
        protected void invoke(ExecutionContext context, ArgumentIterator args) throws ResolvedControlThrowable {
            Table table = args.nextTable();
            Object key = args.nextAny();
            context.getReturnBuffer().setTo(table.rawget(key));
        }
    }

    static class RawEqual
    extends AbstractLibFunction {
        RawEqual() {
        }

        @Override
        protected String name() {
            return "rawequal";
        }

        @Override
        protected void invoke(ExecutionContext context, ArgumentIterator args) throws ResolvedControlThrowable {
            Object a = args.nextAny();
            Object b = args.nextAny();
            context.getReturnBuffer().setTo(Ordering.isRawEqual(a, b));
        }
    }

    static class XPCall
    extends AbstractLibFunction
    implements ProtectedResumable {
        public static final int MAX_DEPTH = 220;

        XPCall() {
        }

        @Override
        protected String name() {
            return "xpcall";
        }

        private static void prependTrue(ExecutionContext context) {
            ReturnBuffer rbuf = context.getReturnBuffer();
            ArrayList<Object> result = new ArrayList<Object>();
            result.add(Boolean.TRUE);
            result.addAll(Arrays.asList(rbuf.getAsArray()));
            rbuf.setToContentsOf(result);
        }

        private static void prependFalseAndTrim(ExecutionContext context) {
            ReturnBuffer rbuf = context.getReturnBuffer();
            Object errorObject = rbuf.get0();
            rbuf.setTo(Boolean.FALSE, errorObject);
        }

        private void handleError(ExecutionContext context, LuaFunction handler, int depth, Object errorObject) throws ResolvedControlThrowable {
            boolean isError = true;
            while (isError && depth < 220) {
                ++depth;
                try {
                    Dispatch.call(context, (Object)handler, errorObject);
                    isError = false;
                }
                catch (UnresolvedControlThrowable ct) {
                    throw ct.resolve(this, new SavedState(handler, depth));
                }
                catch (Exception e) {
                    errorObject = Conversions.toErrorObject(e);
                    isError = true;
                }
            }
            if (!isError) {
                XPCall.prependFalseAndTrim(context);
            } else {
                context.getReturnBuffer().setTo(Boolean.FALSE, "error in error handling");
            }
        }

        @Override
        protected void invoke(ExecutionContext context, ArgumentIterator args) throws ResolvedControlThrowable {
            Object callTarget = args.hasNext() ? args.peek() : null;
            args.skip();
            LuaFunction handler = args.nextFunction();
            Object[] callArgs = args.copyRemaining();
            Object errorObject = null;
            boolean isError = false;
            try {
                Dispatch.call(context, callTarget, callArgs);
            }
            catch (UnresolvedControlThrowable ct) {
                throw ct.resolve(this, new SavedState(handler, 0));
            }
            catch (Exception e) {
                errorObject = Conversions.toErrorObject(e);
                isError = true;
            }
            if (!isError) {
                XPCall.prependTrue(context);
            } else {
                this.handleError(context, handler, 0, errorObject);
            }
        }

        @Override
        public void resume(ExecutionContext context, Object suspendedState) throws ResolvedControlThrowable {
            SavedState ss = (SavedState)suspendedState;
            if (ss.depth == 0) {
                XPCall.prependTrue(context);
            } else {
                XPCall.prependFalseAndTrim(context);
            }
        }

        @Override
        public void resumeError(ExecutionContext context, Object suspendedState, Object error) throws ResolvedControlThrowable {
            SavedState ss = (SavedState)suspendedState;
            this.handleError(context, ss.handler, ss.depth, error);
        }

        private static class SavedState {
            public final LuaFunction handler;
            public final int depth;

            private SavedState(LuaFunction handler, int depth) {
                this.handler = handler;
                this.depth = depth;
            }
        }
    }

    static class PCall
    extends AbstractLibFunction
    implements ProtectedResumable {
        PCall() {
        }

        @Override
        protected String name() {
            return "pcall";
        }

        @Override
        protected void invoke(ExecutionContext context, ArgumentIterator args) throws ResolvedControlThrowable {
            Object callTarget = args.nextAny();
            Object[] callArgs = args.copyRemaining();
            try {
                Dispatch.call(context, callTarget, callArgs);
            }
            catch (UnresolvedControlThrowable ct) {
                throw ct.resolve(this, null);
            }
            catch (Exception ex) {
                this.resumeError(context, null, Conversions.toErrorObject(ex));
                return;
            }
            this.resume(context, null);
        }

        @Override
        public void resume(ExecutionContext context, Object suspendedState) throws ResolvedControlThrowable {
            ReturnBuffer rbuf = context.getReturnBuffer();
            ArrayList<Object> result = new ArrayList<Object>();
            result.add(Boolean.TRUE);
            result.addAll(Arrays.asList(rbuf.getAsArray()));
            rbuf.setToContentsOf(result);
        }

        @Override
        public void resumeError(ExecutionContext context, Object suspendedState, Object error) throws ResolvedControlThrowable {
            context.getReturnBuffer().setTo(Boolean.FALSE, error);
        }
    }

    static class Assert
    extends AbstractLibFunction {
        Assert() {
        }

        @Override
        protected String name() {
            return "assert";
        }

        @Override
        protected void invoke(ExecutionContext context, ArgumentIterator args) throws ResolvedControlThrowable {
            if (!Conversions.booleanValueOf(args.nextAny())) {
                Object message;
                ByteString stringMessage;
                AssertionFailedException ex = args.hasNext() ? ((stringMessage = Conversions.stringValueOf(message = args.nextAny())) != null ? new AssertionFailedException(stringMessage) : new AssertionFailedException(message)) : new AssertionFailedException("assertion failed!");
                throw ex;
            }
            context.getReturnBuffer().setToContentsOf(args.copyAll());
        }
    }

    static class Error
    extends AbstractLibFunction {
        Error() {
        }

        @Override
        protected String name() {
            return "error";
        }

        @Override
        protected void invoke(ExecutionContext context, ArgumentIterator args) throws ResolvedControlThrowable {
            Object arg1 = args.nextOptionalAny(null);
            throw new LuaRuntimeException(arg1);
        }
    }

    static class SetMetatable
    extends AbstractLibFunction {
        SetMetatable() {
        }

        @Override
        protected String name() {
            return "setmetatable";
        }

        private Table nilOrTable(ArgumentIterator args) {
            if (args.hasNext()) {
                Object o = args.peek();
                if (o instanceof Table) {
                    return (Table)o;
                }
                if (o == null) {
                    return null;
                }
            }
            throw new BadArgumentException(2, this.name(), "nil or table expected");
        }

        @Override
        protected void invoke(ExecutionContext context, ArgumentIterator args) throws ResolvedControlThrowable {
            Table t = args.nextTable();
            Table mt = this.nilOrTable(args);
            if (Metatables.getMetamethod(context, MT_METATABLE, t) != null) {
                throw new IllegalOperationAttemptException("cannot change a protected metatable");
            }
            t.setMetatable(mt);
            context.getReturnBuffer().setTo(t);
        }
    }

    static class GetMetatable
    extends AbstractLibFunction {
        GetMetatable() {
        }

        @Override
        protected String name() {
            return "getmetatable";
        }

        @Override
        protected void invoke(ExecutionContext context, ArgumentIterator args) throws ResolvedControlThrowable {
            Object arg = args.nextAny();
            Object meta = Metatables.getMetamethod(context, MT_METATABLE, arg);
            Object result = meta != null ? meta : context.getMetatable(arg);
            context.getReturnBuffer().setTo(result);
        }
    }

    static class ToNumber
    extends AbstractLibFunction {
        ToNumber() {
        }

        public static Long toNumber(ByteString s, int base) {
            try {
                return Long.parseLong(s.toString().trim(), base);
            }
            catch (NumberFormatException ex) {
                return null;
            }
        }

        @Override
        protected String name() {
            return "tonumber";
        }

        @Override
        protected void invoke(ExecutionContext context, ArgumentIterator args) throws ResolvedControlThrowable {
            if (args.size() < 2) {
                Object o = args.nextAny();
                Number n = Conversions.numericalValueOf(o);
                context.getReturnBuffer().setTo(n);
            } else {
                args.skip();
                args.nextInteger();
                args.rewind();
                ByteString s = args.nextStrictString();
                int base = args.nextIntRange(2, 36, "base");
                context.getReturnBuffer().setTo(ToNumber.toNumber(s, base));
            }
        }
    }

    static class ToString
    extends AbstractLibFunction {
        static final ByteString KEY = ByteString.constOf("tostring");

        ToString() {
        }

        @Override
        protected String name() {
            return "tostring";
        }

        @Override
        protected void invoke(ExecutionContext context, ArgumentIterator args) throws ResolvedControlThrowable {
            Object arg = args.nextAny();
            Object meta = Metatables.getMetamethod(context, MT_TOSTRING, arg);
            if (meta != null) {
                try {
                    Dispatch.call(context, meta, arg);
                }
                catch (UnresolvedControlThrowable ct) {
                    throw ct.resolve(this, null);
                }
                this.resume(context, null);
            } else {
                ByteString s = Conversions.toHumanReadableString(arg);
                context.getReturnBuffer().setTo(s);
            }
        }

        @Override
        public void resume(ExecutionContext context, Object suspendedState) throws ResolvedControlThrowable {
            Object result = context.getReturnBuffer().get0();
            context.getReturnBuffer().setTo(result);
        }
    }

    static class IPairs
    extends AbstractLibFunction {
        IPairs() {
        }

        @Override
        protected String name() {
            return "ipairs";
        }

        @Override
        protected void invoke(ExecutionContext context, ArgumentIterator args) throws ResolvedControlThrowable {
            LuaObject t = args.nextLuaObject();
            context.getReturnBuffer().setTo(INext.INSTANCE, t, 0L);
        }
    }

    static class Pairs
    extends AbstractLibFunction {
        Pairs() {
        }

        @Override
        protected String name() {
            return "pairs";
        }

        @Override
        protected void invoke(ExecutionContext context, ArgumentIterator args) throws ResolvedControlThrowable {
            LuaObject t = args.nextLuaObject();
            Object metamethod = Metatables.getMetamethod(context, MT_PAIRS, t);
            if (metamethod != null) {
                try {
                    Dispatch.call(context, metamethod, t);
                }
                catch (UnresolvedControlThrowable ct) {
                    throw ct.resolve(this, null);
                }
                ReturnBuffer rbuf = context.getReturnBuffer();
                rbuf.setTo(rbuf.get0(), rbuf.get1(), rbuf.get2());
            } else {
                ReturnBuffer rbuf = context.getReturnBuffer();
                rbuf.setTo(NEXT, t, null);
            }
        }

        @Override
        public void resume(ExecutionContext context, Object suspendedState) throws ResolvedControlThrowable {
            ReturnBuffer rbuf = context.getReturnBuffer();
            rbuf.setTo(rbuf.get0(), rbuf.get1(), rbuf.get2());
        }
    }

    static class INext
    extends AbstractLibFunction {
        public static final INext INSTANCE = new INext();

        INext() {
        }

        @Override
        protected String name() {
            return "inext";
        }

        @Override
        protected void invoke(ExecutionContext context, ArgumentIterator args) throws ResolvedControlThrowable {
            LuaObject luaObject = args.nextLuaObject();
            long index = args.nextInteger();
            ++index;
            try {
                Dispatch.index(context, luaObject, (Object)index);
            }
            catch (UnresolvedControlThrowable ct) {
                throw ct.resolve(this, index);
            }
            Object result = context.getReturnBuffer().get0();
            INext.processResult(context, index, result);
        }

        @Override
        public void resume(ExecutionContext context, Object suspendedState) throws ResolvedControlThrowable {
            long index = (Long)suspendedState;
            Object result = context.getReturnBuffer().get0();
            INext.processResult(context, index, result);
        }

        private static void processResult(ExecutionContext context, long index, Object o) throws ResolvedControlThrowable {
            if (o != null) {
                context.getReturnBuffer().setTo(index, o);
            } else {
                context.getReturnBuffer().setTo(null);
            }
        }
    }

    static class Next
    extends AbstractLibFunction {
        Next() {
        }

        @Override
        protected String name() {
            return "next";
        }

        @Override
        protected void invoke(ExecutionContext context, ArgumentIterator args) throws ResolvedControlThrowable {
            Table table = args.nextTable();
            Object index = args.nextOptionalAny(null);
            Object nxt = index != null ? table.successorKeyOf(index) : table.initialKey();
            if (nxt == null) {
                context.getReturnBuffer().setTo(null);
            } else {
                Object value = table.rawget(nxt);
                context.getReturnBuffer().setTo(nxt, value);
            }
        }
    }

    static class Type
    extends AbstractLibFunction {
        Type() {
        }

        @Override
        protected String name() {
            return "type";
        }

        @Override
        protected void invoke(ExecutionContext context, ArgumentIterator args) throws ResolvedControlThrowable {
            ByteString typeName = PlainValueTypeNamer.INSTANCE.typeNameOf(args.nextAny());
            context.getReturnBuffer().setTo(typeName);
        }
    }

    static class Print
    extends AbstractLibFunction {
        private final OutputStream out;
        private final Object envTable;

        public Print(OutputStream out, Object envTable) {
            this.out = Objects.requireNonNull(out);
            this.envTable = Objects.requireNonNull(envTable);
        }

        @Override
        protected String name() {
            return "print";
        }

        private void run(ExecutionContext context, int state, Object tostring, Object[] args) throws ResolvedControlThrowable {
            switch (state) {
                case 0: {
                    try {
                        Dispatch.index(context, this.envTable, (Object)ToString.KEY);
                    }
                    catch (UnresolvedControlThrowable ct) {
                        throw ct.resolve(this, new SuspendedState(1, null, args));
                    }
                }
                case 1: {
                    tostring = context.getReturnBuffer().get0();
                }
                case 2: {
                    try {
                        for (int i = 0; i < args.length; ++i) {
                            Object a = args[i];
                            try {
                                Dispatch.call(context, tostring, a);
                            }
                            catch (UnresolvedControlThrowable ct) {
                                throw ct.resolve(this, new SuspendedState(2, tostring, Arrays.copyOfRange(args, i + 1, args.length)));
                            }
                            Object s = context.getReturnBuffer().get0();
                            s = Conversions.canonicalRepresentationOf(s);
                            if (!(s instanceof ByteString)) {
                                throw new LuaRuntimeException((Object)"error calling 'print' ('tostring' must return a string to 'print')");
                            }
                            ((ByteString)s).writeTo(this.out);
                            if (i + 1 >= args.length) continue;
                            this.out.write(9);
                        }
                        this.out.write(10);
                        this.out.flush();
                    }
                    catch (IOException ex) {
                        throw new LuaRuntimeException(ex);
                    }
                    context.getReturnBuffer().setTo();
                    return;
                }
            }
            throw new IllegalStateException("Illegal state: " + state);
        }

        @Override
        protected void invoke(ExecutionContext context, ArgumentIterator args) throws ResolvedControlThrowable {
            this.run(context, 0, null, args.copyAll());
        }

        @Override
        public void resume(ExecutionContext context, Object suspendedState) throws ResolvedControlThrowable {
            SuspendedState ss = (SuspendedState)suspendedState;
            this.run(context, ss.state, ss.tostring, ss.args);
        }

        static class SuspendedState {
            private final int state;
            private final Object tostring;
            private final Object[] args;

            SuspendedState(int state, Object tostring, Object[] args) {
                this.state = state;
                this.tostring = tostring;
                this.args = args;
            }
        }
    }
}

