/*
 * Decompiled with CFR 0.152.
 */
package org.classdump.luna.lib;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import org.classdump.luna.StateContext;
import org.classdump.luna.Table;
import org.classdump.luna.lib.AbstractLibFunction;
import org.classdump.luna.lib.ArgumentIterator;
import org.classdump.luna.lib.ModuleLib;
import org.classdump.luna.runtime.AbstractFunctionAnyArg;
import org.classdump.luna.runtime.Coroutine;
import org.classdump.luna.runtime.ExecutionContext;
import org.classdump.luna.runtime.LuaFunction;
import org.classdump.luna.runtime.ProtectedResumable;
import org.classdump.luna.runtime.ResolvedControlThrowable;
import org.classdump.luna.runtime.ReturnBuffer;
import org.classdump.luna.runtime.UnresolvedControlThrowable;

public final class CoroutineLib {
    static final LuaFunction CREATE = new Create();
    static final LuaFunction ISYIELDABLE = new IsYieldable();
    static final LuaFunction RESUME = new Resume();
    static final LuaFunction RUNNING = new Running();
    static final LuaFunction STATUS = new Status();
    static final LuaFunction WRAP = new Wrap();
    static final LuaFunction YIELD = new Yield();

    public static LuaFunction create() {
        return CREATE;
    }

    public static LuaFunction isyieldable() {
        return ISYIELDABLE;
    }

    public static LuaFunction resume() {
        return RESUME;
    }

    public static LuaFunction running() {
        return RUNNING;
    }

    public static LuaFunction status() {
        return STATUS;
    }

    public static LuaFunction wrap() {
        return WRAP;
    }

    public static LuaFunction yield() {
        return YIELD;
    }

    private CoroutineLib() {
    }

    public static void installInto(StateContext context, Table env) {
        Objects.requireNonNull(context);
        Objects.requireNonNull(env);
        Table t = context.newTable();
        t.rawset("create", (Object)CoroutineLib.create());
        t.rawset("resume", (Object)CoroutineLib.resume());
        t.rawset("yield", (Object)CoroutineLib.yield());
        t.rawset("isyieldable", (Object)CoroutineLib.isyieldable());
        t.rawset("status", (Object)CoroutineLib.status());
        t.rawset("running", (Object)CoroutineLib.running());
        t.rawset("wrap", (Object)CoroutineLib.wrap());
        ModuleLib.install(env, "coroutine", t);
    }

    static class WrappedCoroutine
    extends AbstractFunctionAnyArg {
        private final Coroutine coroutine;

        public WrappedCoroutine(LuaFunction function, ExecutionContext context) {
            Objects.requireNonNull(function);
            Objects.requireNonNull(context);
            this.coroutine = context.newCoroutine(function);
        }

        @Override
        public void invoke(ExecutionContext context, Object[] args) throws ResolvedControlThrowable {
            context.getReturnBuffer().setTo();
            try {
                context.resume(this.coroutine, args);
            }
            catch (UnresolvedControlThrowable ct) {
                throw ct.resolve(this, null);
            }
        }

        @Override
        public void resume(ExecutionContext context, Object suspendedState) throws ResolvedControlThrowable {
        }
    }

    static class Wrap
    extends AbstractLibFunction {
        Wrap() {
        }

        @Override
        protected String name() {
            return "wrap";
        }

        @Override
        protected void invoke(ExecutionContext context, ArgumentIterator args) throws ResolvedControlThrowable {
            LuaFunction f = args.nextFunction();
            WrappedCoroutine result = new WrappedCoroutine(f, context);
            context.getReturnBuffer().setTo(result);
        }
    }

    static class Running
    extends AbstractLibFunction {
        Running() {
        }

        @Override
        protected String name() {
            return "running";
        }

        @Override
        protected void invoke(ExecutionContext context, ArgumentIterator args) throws ResolvedControlThrowable {
            Coroutine c = context.getCurrentCoroutine();
            context.getReturnBuffer().setTo(c, !context.isInMainCoroutine());
        }
    }

    static class Status
    extends AbstractLibFunction {
        public static final String STATUS_RUNNING = "running";
        public static final String STATUS_SUSPENDED = "suspended";
        public static final String STATUS_NORMAL = "normal";
        public static final String STATUS_DEAD = "dead";

        Status() {
        }

        public static String status(ExecutionContext context, Coroutine coroutine) {
            switch (context.getCoroutineStatus(coroutine)) {
                case SUSPENDED: {
                    return STATUS_SUSPENDED;
                }
                case RUNNING: {
                    return STATUS_RUNNING;
                }
                case NORMAL: {
                    return STATUS_NORMAL;
                }
                case DEAD: {
                    return STATUS_DEAD;
                }
            }
            throw new AssertionError();
        }

        @Override
        protected String name() {
            return "status";
        }

        @Override
        protected void invoke(ExecutionContext context, ArgumentIterator args) throws ResolvedControlThrowable {
            Coroutine coroutine = args.nextCoroutine();
            context.getReturnBuffer().setTo(Status.status(context, coroutine));
        }
    }

    static class IsYieldable
    extends AbstractLibFunction {
        IsYieldable() {
        }

        @Override
        protected String name() {
            return "isyieldable";
        }

        @Override
        protected void invoke(ExecutionContext context, ArgumentIterator args) throws ResolvedControlThrowable {
            context.getReturnBuffer().setTo(context.isInMainCoroutine());
        }
    }

    static class Yield
    extends AbstractLibFunction {
        Yield() {
        }

        @Override
        protected String name() {
            return "yield";
        }

        @Override
        protected void invoke(ExecutionContext context, ArgumentIterator args) throws ResolvedControlThrowable {
            try {
                context.yield(args.copyAll());
            }
            catch (UnresolvedControlThrowable ct) {
                throw ct.resolve(this, null);
            }
        }

        @Override
        public void resume(ExecutionContext context, Object suspendedState) throws ResolvedControlThrowable {
        }
    }

    static class Resume
    extends AbstractLibFunction
    implements ProtectedResumable {
        Resume() {
        }

        @Override
        protected String name() {
            return "resume";
        }

        @Override
        protected void invoke(ExecutionContext context, ArgumentIterator args) throws ResolvedControlThrowable {
            Coroutine coroutine = args.nextCoroutine();
            Object[] resumeArgs = args.copyRemaining();
            context.getReturnBuffer().setTo();
            try {
                context.resume(coroutine, resumeArgs);
            }
            catch (UnresolvedControlThrowable ct) {
                throw ct.resolve(this, null);
            }
        }

        @Override
        public void resume(ExecutionContext context, Object suspendedState) throws ResolvedControlThrowable {
            ReturnBuffer rbuf = context.getReturnBuffer();
            ArrayList<Object> result = new ArrayList<Object>();
            result.add(Boolean.TRUE);
            result.addAll(Arrays.asList(rbuf.getAsArray()));
            rbuf.setToContentsOf(result);
        }

        @Override
        public void resumeError(ExecutionContext context, Object suspendedState, Object error) throws ResolvedControlThrowable {
            context.getReturnBuffer().setTo(Boolean.FALSE, error);
        }
    }

    static class Create
    extends AbstractLibFunction {
        Create() {
        }

        @Override
        protected String name() {
            return "create";
        }

        @Override
        protected void invoke(ExecutionContext context, ArgumentIterator args) throws ResolvedControlThrowable {
            LuaFunction func = args.nextFunction();
            Coroutine c = context.newCoroutine(func);
            context.getReturnBuffer().setTo(c);
        }
    }
}

