/*
 * Decompiled with CFR 0.152.
 */
package org.classdump.luna.lib;

import java.util.Objects;
import java.util.Random;
import org.classdump.luna.Conversions;
import org.classdump.luna.StateContext;
import org.classdump.luna.Table;
import org.classdump.luna.lib.AbstractLibFunction;
import org.classdump.luna.lib.ArgumentIterator;
import org.classdump.luna.lib.BadArgumentException;
import org.classdump.luna.lib.ModuleLib;
import org.classdump.luna.runtime.Dispatch;
import org.classdump.luna.runtime.ExecutionContext;
import org.classdump.luna.runtime.LuaFunction;
import org.classdump.luna.runtime.ResolvedControlThrowable;
import org.classdump.luna.runtime.UnresolvedControlThrowable;
import org.classdump.luna.util.Check;

public final class MathLib {
    static final LuaFunction ABS = new Abs();
    static final LuaFunction ACOS = new ACos();
    static final LuaFunction ASIN = new ASin();
    static final LuaFunction ATAN = new ATan();
    static final LuaFunction CEIL = new Ceil();
    static final LuaFunction COS = new Cos();
    static final LuaFunction DEG = new Deg();
    static final LuaFunction EXP = new Exp();
    static final LuaFunction FLOOR = new Floor();
    static final LuaFunction FMOD = new FMod();
    static final LuaFunction LOG = new Log();
    static final LuaFunction MAX = new MaxMin(true);
    static final LuaFunction MIN = new MaxMin(false);
    static final LuaFunction MODF = new ModF();
    static final LuaFunction RAD = new Rad();
    static final LuaFunction SIN = new Sin();
    static final LuaFunction SQRT = new Sqrt();
    static final LuaFunction TAN = new Tan();
    static final LuaFunction TOINTEGER = new ToInteger();
    static final LuaFunction TYPE = new Type();
    static final LuaFunction ULT = new ULt();
    public static final Double HUGE = Double.POSITIVE_INFINITY;
    public static final Long MAXINTEGER = Long.MAX_VALUE;
    public static final Long MININTEGER = Long.MIN_VALUE;
    public static final Double PI = Math.PI;

    public static LuaFunction abs() {
        return ABS;
    }

    public static LuaFunction acos() {
        return ACOS;
    }

    public static LuaFunction asin() {
        return ASIN;
    }

    public static LuaFunction atan() {
        return ATAN;
    }

    public static LuaFunction ceil() {
        return CEIL;
    }

    public static LuaFunction cos() {
        return COS;
    }

    public static LuaFunction deg() {
        return DEG;
    }

    public static LuaFunction exp() {
        return EXP;
    }

    public static LuaFunction floor() {
        return FLOOR;
    }

    public static LuaFunction fmod() {
        return FMOD;
    }

    public static LuaFunction log() {
        return LOG;
    }

    public static LuaFunction max() {
        return MAX;
    }

    public static LuaFunction min() {
        return MIN;
    }

    public static LuaFunction modf() {
        return MODF;
    }

    public static LuaFunction rad() {
        return RAD;
    }

    public static LuaFunction random(Random random) {
        return new Rand(random);
    }

    public static LuaFunction randomseed(Random random) {
        return new RandSeed(random);
    }

    public static LuaFunction sin() {
        return SIN;
    }

    public static LuaFunction sqrt() {
        return SQRT;
    }

    public static LuaFunction tan() {
        return TAN;
    }

    public static LuaFunction tointeger() {
        return TOINTEGER;
    }

    public static LuaFunction type() {
        return TYPE;
    }

    public static LuaFunction ult() {
        return ULT;
    }

    private MathLib() {
    }

    public static void installInto(StateContext context, Table env, Random random) {
        Objects.requireNonNull(context);
        Objects.requireNonNull(env);
        Table t = context.newTable();
        t.rawset("abs", (Object)MathLib.abs());
        t.rawset("acos", (Object)MathLib.acos());
        t.rawset("asin", (Object)MathLib.asin());
        t.rawset("atan", (Object)MathLib.atan());
        t.rawset("ceil", (Object)MathLib.ceil());
        t.rawset("cos", (Object)MathLib.cos());
        t.rawset("deg", (Object)MathLib.deg());
        t.rawset("exp", (Object)MathLib.exp());
        t.rawset("floor", (Object)MathLib.floor());
        t.rawset("fmod", (Object)MathLib.fmod());
        t.rawset("huge", (Object)HUGE);
        t.rawset("log", (Object)MathLib.log());
        t.rawset("max", (Object)MathLib.max());
        t.rawset("maxinteger", (Object)MAXINTEGER);
        t.rawset("min", (Object)MathLib.min());
        t.rawset("mininteger", (Object)MININTEGER);
        t.rawset("modf", (Object)MathLib.modf());
        t.rawset("pi", (Object)PI);
        t.rawset("rad", (Object)MathLib.rad());
        if (random != null) {
            t.rawset("random", (Object)MathLib.random(random));
        }
        if (random != null) {
            t.rawset("randomseed", (Object)MathLib.randomseed(random));
        }
        t.rawset("sin", (Object)MathLib.sin());
        t.rawset("sqrt", (Object)MathLib.sqrt());
        t.rawset("tan", (Object)MathLib.tan());
        t.rawset("tointeger", (Object)MathLib.tointeger());
        t.rawset("type", (Object)MathLib.type());
        t.rawset("ult", (Object)MathLib.ult());
        ModuleLib.install(env, "math", t);
    }

    public static void installInto(StateContext context, Table env) {
        MathLib.installInto(context, env, new Random());
    }

    static class ULt
    extends AbstractLibFunction {
        ULt() {
        }

        @Override
        protected String name() {
            return "ult";
        }

        @Override
        protected void invoke(ExecutionContext context, ArgumentIterator args) throws ResolvedControlThrowable {
            long x = args.nextInteger();
            long y = args.nextInteger();
            context.getReturnBuffer().setTo(x - y < 0L);
        }
    }

    static class Type
    extends AbstractLibFunction {
        Type() {
        }

        @Override
        protected String name() {
            return "type";
        }

        @Override
        protected void invoke(ExecutionContext context, ArgumentIterator args) throws ResolvedControlThrowable {
            Object x = args.nextAny();
            String result = x instanceof Number ? (x instanceof Float || x instanceof Double ? "float" : "integer") : null;
            context.getReturnBuffer().setTo(result);
        }
    }

    static class ToInteger
    extends AbstractLibFunction {
        ToInteger() {
        }

        @Override
        protected String name() {
            return "tointeger";
        }

        @Override
        protected void invoke(ExecutionContext context, ArgumentIterator args) throws ResolvedControlThrowable {
            Object x = args.nextAny();
            context.getReturnBuffer().setTo(Conversions.integerValueOf(x));
        }
    }

    static class Tan
    extends AbstractMathFunction1 {
        Tan() {
        }

        @Override
        protected String name() {
            return "tan";
        }

        @Override
        protected Number op(double x) {
            return Math.tan(x);
        }
    }

    static class Sqrt
    extends AbstractMathFunction1 {
        Sqrt() {
        }

        @Override
        protected String name() {
            return "sqrt";
        }

        @Override
        protected Number op(double x) {
            return Math.sqrt(x);
        }
    }

    static class Sin
    extends AbstractMathFunction1 {
        Sin() {
        }

        @Override
        protected String name() {
            return "sin";
        }

        @Override
        protected Number op(double x) {
            return Math.sin(x);
        }
    }

    static class RandSeed
    extends AbstractLibFunction {
        protected final Random random;

        public RandSeed(Random random) {
            this.random = Objects.requireNonNull(random);
        }

        @Override
        protected String name() {
            return "randomseed";
        }

        @Override
        protected void invoke(ExecutionContext context, ArgumentIterator args) throws ResolvedControlThrowable {
            Number arg = args.nextNumber();
            long seed = arg instanceof Double || arg instanceof Float ? Double.doubleToLongBits(arg.doubleValue()) : arg.longValue();
            this.random.setSeed(seed);
            context.getReturnBuffer().setTo();
        }
    }

    static class Rand
    extends AbstractLibFunction {
        protected final Random random;

        public Rand(Random random) {
            this.random = Objects.requireNonNull(random);
        }

        @Override
        protected String name() {
            return "random";
        }

        protected long nextLong(long n) {
            long val;
            long bits;
            Check.nonNegative(n);
            if (n <= Integer.MAX_VALUE) {
                return this.random.nextInt((int)n);
            }
            while ((bits = this.random.nextLong() & Long.MAX_VALUE) - (val = bits % n) + (n - 1L) < 0L) {
            }
            return val;
        }

        @Override
        protected void invoke(ExecutionContext context, ArgumentIterator args) throws ResolvedControlThrowable {
            Number result;
            if (!args.hasNext()) {
                result = this.random.nextDouble();
            } else {
                long m = args.nextInteger();
                if (!args.hasNext()) {
                    if (m < 1L) {
                        throw new BadArgumentException(1, this.name(), "interval is empty");
                    }
                    result = 1L + this.nextLong(m);
                } else {
                    long n = args.nextInteger();
                    if (n < m) {
                        throw new BadArgumentException(1, this.name(), "interval is empty");
                    }
                    long limit = n - m + 1L;
                    if (limit <= 0L) {
                        throw new BadArgumentException(1, this.name(), "interval too large");
                    }
                    result = m + this.nextLong(limit);
                }
            }
            context.getReturnBuffer().setTo(result);
        }
    }

    static class Rad
    extends AbstractMathFunction1 {
        Rad() {
        }

        @Override
        protected String name() {
            return "rad";
        }

        @Override
        protected Number op(double x) {
            return Math.toRadians(x);
        }
    }

    static class ModF
    extends AbstractLibFunction {
        ModF() {
        }

        @Override
        protected String name() {
            return "modf";
        }

        @Override
        protected void invoke(ExecutionContext context, ArgumentIterator args) throws ResolvedControlThrowable {
            Number fltPart;
            Number intPart;
            Number x = args.nextNumber();
            double d = x.doubleValue();
            if (!Double.isNaN(d)) {
                long l;
                double dd = d < 0.0 ? Math.ceil(d) : Math.floor(d);
                if (dd == (double)(l = (long)dd)) {
                    intPart = l;
                    fltPart = d - (double)l;
                } else {
                    intPart = x;
                    fltPart = 0.0;
                }
            } else {
                intPart = x;
                fltPart = x;
            }
            context.getReturnBuffer().setTo(intPart, fltPart);
        }
    }

    static class MaxMin
    extends AbstractLibFunction {
        private final boolean isMax;

        public MaxMin(boolean isMax) {
            this.isMax = isMax;
        }

        @Override
        protected String name() {
            return this.isMax ? "max" : "min";
        }

        private void run(ExecutionContext context, Object[] args, int idx, Object best) throws ResolvedControlThrowable {
            while (idx < args.length) {
                Object o = args[idx];
                try {
                    if (this.isMax) {
                        Dispatch.lt(context, best, o);
                    } else {
                        Dispatch.lt(context, o, best);
                    }
                }
                catch (UnresolvedControlThrowable ct) {
                    throw ct.resolve(this, new State(args, idx, best));
                }
                if (Conversions.booleanValueOf(context.getReturnBuffer().get0())) {
                    best = o;
                }
                ++idx;
            }
            context.getReturnBuffer().setTo(best);
        }

        @Override
        protected void invoke(ExecutionContext context, ArgumentIterator args) throws ResolvedControlThrowable {
            Object initial = args.nextAny();
            this.run(context, args.copyAll(), 1, initial);
        }

        @Override
        public void resume(ExecutionContext context, Object suspendedState) throws ResolvedControlThrowable {
            State ss = (State)suspendedState;
            Object[] args = ss.args;
            int idx = ss.idx;
            Object best = ss.best;
            if (Conversions.booleanValueOf(context.getReturnBuffer().get0())) {
                best = args[idx];
            }
            this.run(context, args, idx + 1, best);
        }

        private static class State {
            public final Object[] args;
            public final int idx;
            public final Object best;

            public State(Object[] args, int idx, Object best) {
                this.args = args;
                this.idx = idx;
                this.best = best;
            }
        }
    }

    static class Log
    extends AbstractLibFunction {
        Log() {
        }

        @Override
        protected String name() {
            return "log";
        }

        @Override
        protected void invoke(ExecutionContext context, ArgumentIterator args) throws ResolvedControlThrowable {
            double result;
            Number x = args.nextNumber();
            double ln = Math.log(x.doubleValue());
            if (args.hasNext()) {
                double base = args.nextNumber().doubleValue();
                result = ln / Math.log(base);
            } else {
                result = ln;
            }
            context.getReturnBuffer().setTo(result);
        }
    }

    static class FMod
    extends AbstractLibFunction {
        FMod() {
        }

        @Override
        protected String name() {
            return "fmod";
        }

        @Override
        protected void invoke(ExecutionContext context, ArgumentIterator args) throws ResolvedControlThrowable {
            Number result;
            Number x = args.nextNumber();
            Number y = args.nextNumber();
            if (x instanceof Float || x instanceof Double || y instanceof Float || y instanceof Double) {
                result = Math.IEEEremainder(x.doubleValue(), y.doubleValue());
            } else {
                long xi = x.longValue();
                long yi = y.longValue();
                if (yi != 0L) {
                    result = xi % yi;
                } else {
                    throw new BadArgumentException(2, this.name(), "zero");
                }
            }
            context.getReturnBuffer().setTo(result);
        }
    }

    static class Floor
    extends AbstractMathFunction1 {
        Floor() {
        }

        @Override
        protected String name() {
            return "floor";
        }

        @Override
        protected Number op(double x) {
            long l;
            double d = Math.floor(x);
            return d == (double)(l = (long)d) ? (Number)l : (Number)d;
        }

        @Override
        protected Number op(long x) {
            return x;
        }
    }

    static class Exp
    extends AbstractMathFunction1 {
        Exp() {
        }

        @Override
        protected String name() {
            return "exp";
        }

        @Override
        protected Number op(double x) {
            return Math.exp(x);
        }
    }

    static class Deg
    extends AbstractMathFunction1 {
        Deg() {
        }

        @Override
        protected String name() {
            return "deg";
        }

        @Override
        protected Number op(double x) {
            return Math.toDegrees(x);
        }
    }

    static class Cos
    extends AbstractMathFunction1 {
        Cos() {
        }

        @Override
        protected String name() {
            return "cos";
        }

        @Override
        protected Number op(double x) {
            return Math.cos(x);
        }
    }

    static class Ceil
    extends AbstractMathFunction1 {
        Ceil() {
        }

        @Override
        protected String name() {
            return "ceil";
        }

        @Override
        protected Number op(double x) {
            long l;
            double d = Math.ceil(x);
            return d == (double)(l = (long)d) ? (double)l : d;
        }

        @Override
        protected Number op(long x) {
            return x;
        }
    }

    static class ATan
    extends AbstractMathFunction1 {
        ATan() {
        }

        @Override
        protected String name() {
            return "atan";
        }

        @Override
        protected Number op(double x) {
            return Math.atan(x);
        }
    }

    static class ASin
    extends AbstractMathFunction1 {
        ASin() {
        }

        @Override
        protected String name() {
            return "asin";
        }

        @Override
        protected Number op(double x) {
            return Math.asin(x);
        }
    }

    static class ACos
    extends AbstractMathFunction1 {
        ACos() {
        }

        @Override
        protected String name() {
            return "acos";
        }

        @Override
        protected Number op(double x) {
            return Math.acos(x);
        }
    }

    static class Abs
    extends AbstractMathFunction1 {
        Abs() {
        }

        @Override
        protected String name() {
            return "abs";
        }

        @Override
        protected Number op(double x) {
            return Math.abs(x);
        }

        @Override
        protected Number op(long x) {
            return Math.abs(x);
        }
    }

    static abstract class AbstractMathFunction1
    extends AbstractLibFunction {
        AbstractMathFunction1() {
        }

        protected abstract Number op(double var1);

        protected Number op(long x) {
            return this.op((double)x);
        }

        @Override
        protected void invoke(ExecutionContext context, ArgumentIterator args) throws ResolvedControlThrowable {
            Number x = args.nextNumber();
            Number result = x instanceof Float || x instanceof Double ? (Number)this.op(x.doubleValue()) : (Number)this.op(x.longValue());
            context.getReturnBuffer().setTo(result);
        }
    }
}

