/*
 * Decompiled with CFR 0.152.
 */
package org.classdump.luna.lib;

import java.util.Objects;
import org.classdump.luna.ByteString;
import org.classdump.luna.StateContext;
import org.classdump.luna.Table;
import org.classdump.luna.env.RuntimeEnvironment;
import org.classdump.luna.impl.NonsuspendableFunctionException;
import org.classdump.luna.impl.UnimplementedFunction;
import org.classdump.luna.lib.AbstractLibFunction;
import org.classdump.luna.lib.ArgumentIterator;
import org.classdump.luna.lib.ModuleLib;
import org.classdump.luna.runtime.AbstractFunction0;
import org.classdump.luna.runtime.ExecutionContext;
import org.classdump.luna.runtime.LuaFunction;
import org.classdump.luna.runtime.ResolvedControlThrowable;

public final class OsLib {
    static final LuaFunction DIFFTIME = new DiffTime();

    public static LuaFunction clock(RuntimeEnvironment runtimeEnvironment) {
        return new Clock(runtimeEnvironment);
    }

    static LuaFunction date(RuntimeEnvironment runtimeEnvironment) {
        return new Date(runtimeEnvironment);
    }

    static LuaFunction difftime() {
        return DIFFTIME;
    }

    static LuaFunction execute(RuntimeEnvironment runtimeEnvironment) {
        return new Execute(runtimeEnvironment);
    }

    static LuaFunction exit(RuntimeEnvironment runtimeEnvironment) {
        return new Exit(runtimeEnvironment);
    }

    public static LuaFunction getenv(RuntimeEnvironment runtimeEnvironment) {
        return new GetEnv(runtimeEnvironment);
    }

    static LuaFunction remove(RuntimeEnvironment runtimeEnvironment) {
        return new Remove(runtimeEnvironment);
    }

    static LuaFunction rename(RuntimeEnvironment runtimeEnvironment) {
        return new Rename(runtimeEnvironment);
    }

    static LuaFunction setlocale(RuntimeEnvironment runtimeEnvironment) {
        return new SetLocale(runtimeEnvironment);
    }

    static LuaFunction time() {
        return new Time();
    }

    static LuaFunction tmpname(RuntimeEnvironment runtimeEnvironment) {
        return new TmpName(runtimeEnvironment);
    }

    private OsLib() {
    }

    public static void installInto(StateContext context, Table env, RuntimeEnvironment runtimeEnvironment) {
        Objects.requireNonNull(context);
        Objects.requireNonNull(env);
        Table t = context.newTable();
        if (runtimeEnvironment != null) {
            t.rawset("clock", (Object)OsLib.clock(runtimeEnvironment));
            t.rawset("date", (Object)OsLib.date(runtimeEnvironment));
            t.rawset("difftime", (Object)OsLib.difftime());
            t.rawset("execute", (Object)OsLib.execute(runtimeEnvironment));
            t.rawset("exit", (Object)OsLib.exit(runtimeEnvironment));
            t.rawset("getenv", (Object)OsLib.getenv(runtimeEnvironment));
            t.rawset("remove", (Object)OsLib.remove(runtimeEnvironment));
            t.rawset("rename", (Object)OsLib.rename(runtimeEnvironment));
            t.rawset("setlocale", (Object)OsLib.setlocale(runtimeEnvironment));
            t.rawset("time", (Object)OsLib.time());
            t.rawset("tmpname", (Object)OsLib.tmpname(runtimeEnvironment));
        }
        ModuleLib.install(env, "os", t);
    }

    static class TmpName
    extends UnimplementedFunction {
        public TmpName(RuntimeEnvironment runtimeEnvironment) {
            super("os.tmpname");
            Objects.requireNonNull(runtimeEnvironment);
        }
    }

    static class Time
    extends AbstractLibFunction {
        Time() {
        }

        @Override
        protected void invoke(ExecutionContext context, ArgumentIterator args) throws ResolvedControlThrowable {
            if (args.hasNext()) {
                throw new UnsupportedOperationException("os.time does not support passing a date table yet");
            }
            context.getReturnBuffer().setTo(System.currentTimeMillis() / 1000L);
        }

        @Override
        protected String name() {
            return "os.time";
        }
    }

    static class SetLocale
    extends UnimplementedFunction {
        public SetLocale(RuntimeEnvironment runtimeEnvironment) {
            super("os.setlocale");
            Objects.requireNonNull(runtimeEnvironment);
        }
    }

    static class Rename
    extends UnimplementedFunction {
        public Rename(RuntimeEnvironment runtimeEnvironment) {
            super("os.rename");
            Objects.requireNonNull(runtimeEnvironment);
        }
    }

    static class Remove
    extends UnimplementedFunction {
        public Remove(RuntimeEnvironment runtimeEnvironment) {
            super("os.remove");
            Objects.requireNonNull(runtimeEnvironment);
        }
    }

    static class GetEnv
    extends AbstractLibFunction {
        private final RuntimeEnvironment environment;

        public GetEnv(RuntimeEnvironment environment) {
            this.environment = Objects.requireNonNull(environment);
        }

        @Override
        protected String name() {
            return "getenv";
        }

        @Override
        protected void invoke(ExecutionContext context, ArgumentIterator args) throws ResolvedControlThrowable {
            ByteString name = args.nextString();
            String value = this.environment.getEnv(name.toString());
            context.getReturnBuffer().setTo(value);
        }
    }

    static class Exit
    extends UnimplementedFunction {
        public Exit(RuntimeEnvironment runtimeEnvironment) {
            super("os.exit");
            Objects.requireNonNull(runtimeEnvironment);
        }
    }

    static class Execute
    extends UnimplementedFunction {
        public Execute(RuntimeEnvironment runtimeEnvironment) {
            super("os.execute");
            Objects.requireNonNull(runtimeEnvironment);
        }
    }

    static class DiffTime
    extends UnimplementedFunction {
        public DiffTime() {
            super("os.difftime");
        }
    }

    static class Date
    extends UnimplementedFunction {
        Date(RuntimeEnvironment runtimeEnvironment) {
            super("os.date");
            Objects.requireNonNull(runtimeEnvironment);
        }
    }

    static class Clock
    extends AbstractFunction0 {
        private final RuntimeEnvironment environment;

        public Clock(RuntimeEnvironment environment) {
            this.environment = Objects.requireNonNull(environment);
        }

        @Override
        public void invoke(ExecutionContext context) throws ResolvedControlThrowable {
            context.getReturnBuffer().setTo(this.environment.getCpuTime());
        }

        @Override
        public void resume(ExecutionContext context, Object suspendedState) throws ResolvedControlThrowable {
            throw new NonsuspendableFunctionException(this.getClass());
        }
    }
}

