/*
 * Decompiled with CFR 0.152.
 */
package org.classdump.luna.lib;

import org.classdump.luna.Metatables;
import org.classdump.luna.Ordering;
import org.classdump.luna.Table;

final class TableUtil {
    private TableUtil() {
    }

    public static boolean hasLenMetamethod(Table t) {
        return Metatables.getMetamethod(Metatables.MT_LEN, t) != null;
    }

    public static boolean hasIndexMetamethod(Table t) {
        return Metatables.getMetamethod(Metatables.MT_INDEX, t) != null;
    }

    public static boolean hasNewIndexMetamethod(Table t) {
        return Metatables.getMetamethod(Metatables.MT_NEWINDEX, t) != null;
    }

    public static Ordering<Object> rawSequenceOrderingOf(Table t, long firstIdx, long lastIdx) {
        long count = lastIdx - firstIdx + 1L;
        if (count < 2L) {
            throw new IllegalArgumentException("Interval is empty: [" + firstIdx + ", " + lastIdx + "]");
        }
        Object first = t.rawget(firstIdx);
        Ordering<Object> result = Ordering.of(first, t.rawget(firstIdx + 1L));
        if (count % 2L == 1L && result != Ordering.of(first, t.rawget(lastIdx))) {
            return null;
        }
        long idx = firstIdx + 2L;
        while (idx + 1L <= lastIdx) {
            if (result != Ordering.of(t.rawget(idx), t.rawget(idx + 1L))) {
                return null;
            }
            idx += 2L;
        }
        return result;
    }
}

