/*
 * Decompiled with CFR 0.152.
 */
package org.classdump.luna.lib.io;

import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import org.classdump.luna.ByteString;
import org.classdump.luna.Table;
import org.classdump.luna.lib.IoFile;
import org.classdump.luna.lib.io.SeekableInputStream;

public class InputStreamIoFile
extends IoFile<SeekableInputStream> {
    public InputStreamIoFile(InputStream in, Table metatable) {
        super(metatable, new SeekableInputStream(Objects.requireNonNull(in)));
    }

    @Override
    public boolean isClosed() {
        return false;
    }

    @Override
    public void close() throws IOException {
        throw new UnsupportedOperationException("cannot close standard file");
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public void write(ByteString s) throws IOException {
        throw new UnsupportedOperationException("Bad file descriptor");
    }

    @Override
    public long seek(IoFile.Whence whence, long offset) throws IOException {
        switch (whence) {
            case BEGINNING: 
            case END: {
                return this.inputStream().setPosition(offset);
            }
            case CURRENT_POSITION: {
                return this.inputStream().addPosition(offset);
            }
        }
        throw new IllegalArgumentException("Illegal whence: " + (Object)((Object)whence));
    }

    private SeekableInputStream inputStream() {
        return (SeekableInputStream)this.getUserValue();
    }
}

