/*
 * Decompiled with CFR 0.152.
 */
package org.classdump.luna.lib.io;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Objects;
import org.classdump.luna.ByteString;
import org.classdump.luna.Table;
import org.classdump.luna.lib.IoFile;
import org.classdump.luna.lib.io.SeekableOutputStream;

public class OutputStreamIoFile
extends IoFile<SeekableOutputStream> {
    public OutputStreamIoFile(OutputStream out, Table metatable) {
        super(metatable, new SeekableOutputStream(Objects.requireNonNull(out)));
    }

    @Override
    public boolean isClosed() {
        return false;
    }

    @Override
    public void close() throws IOException {
        throw new UnsupportedOperationException("cannot close standard file");
    }

    @Override
    public void flush() throws IOException {
        this.outputStream().flush();
    }

    @Override
    public void write(ByteString s) throws IOException {
        s.writeTo(this.outputStream());
    }

    @Override
    public long seek(IoFile.Whence whence, long offset) throws IOException {
        switch (whence) {
            case BEGINNING: 
            case END: {
                return this.outputStream().setPosition(offset);
            }
            case CURRENT_POSITION: {
                return this.outputStream().addPosition(offset);
            }
        }
        throw new IllegalArgumentException("Illegal whence: " + (Object)((Object)whence));
    }

    private SeekableOutputStream outputStream() {
        return (SeekableOutputStream)this.getUserValue();
    }
}

