/*
 * Decompiled with CFR 0.152.
 */
package org.classdump.luna.lib.io;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Objects;
import org.classdump.luna.lib.io.SeekableStream;

public class SeekableOutputStream
extends OutputStream
implements SeekableStream {
    private final OutputStream out;
    private long position;

    public SeekableOutputStream(OutputStream out) {
        this.out = Objects.requireNonNull(out);
        this.position = 0L;
    }

    @Override
    public void write(int b) throws IOException {
        this.out.write(b);
        ++this.position;
    }

    @Override
    public long getPosition() {
        return this.position;
    }

    @Override
    public long setPosition(long newPosition) {
        this.position = newPosition;
        return this.position;
    }

    @Override
    public long addPosition(long offset) {
        long newPosition = this.position + offset;
        if (this.position < 0L) {
            throw new IllegalArgumentException("Illegal argument");
        }
        return this.setPosition(newPosition);
    }
}

