/*
 * Decompiled with CFR 0.152.
 */
package org.classdump.luna.parser.analysis;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.classdump.luna.parser.analysis.LabelAnnotatorTransformer;
import org.classdump.luna.parser.analysis.NameResolutionException;
import org.classdump.luna.parser.analysis.ResolvedLabel;
import org.classdump.luna.parser.ast.Block;
import org.classdump.luna.parser.ast.BodyStatement;
import org.classdump.luna.parser.ast.Chunk;
import org.classdump.luna.parser.ast.Expr;
import org.classdump.luna.parser.ast.FunctionDefExpr;
import org.classdump.luna.parser.ast.GotoStatement;
import org.classdump.luna.parser.ast.LabelStatement;
import org.classdump.luna.parser.ast.LocalDeclStatement;
import org.classdump.luna.parser.ast.Name;
import org.classdump.luna.parser.ast.ReturnStatement;
import org.classdump.luna.parser.ast.Statement;
import org.classdump.luna.parser.ast.Transformer;

class LabelResolutionTransformer
extends Transformer {
    private final Deque<Scope> scopes = new ArrayDeque<Scope>();
    private final Map<LabelStatement, ResolvedLabel> defs = new HashMap<LabelStatement, ResolvedLabel>();
    private final Map<GotoStatement, ResolvedLabel> uses = new HashMap<GotoStatement, ResolvedLabel>();

    private static boolean isVoidStatement(Statement stat) {
        return stat instanceof LabelStatement || stat instanceof GotoStatement;
    }

    private void enterBlock() {
        this.scopes.push(new Scope());
    }

    private void endBlockScopes() {
        this.scopes.peek().clearLocals();
    }

    private void leaveBlock() {
        Scope s = this.scopes.pop();
        if (!this.scopes.isEmpty()) {
            Scope current = this.scopes.peek();
            current.addGotos(s.pending);
        } else if (!s.pending.isEmpty()) {
            GotoStatement gs = ((PendingGoto)s.pending.get(0)).statement;
            throw new NameResolutionException("no visible label '" + gs.labelName().value() + "' for <goto> at line " + gs.line());
        }
    }

    private void defLabel(LabelStatement node) {
        this.scopes.peek().defLabel(node);
    }

    private void useLabel(GotoStatement node) {
        this.scopes.peek().useLabel(node);
    }

    private void defLocal(Name name) {
        this.scopes.peek().defLocal(name);
    }

    private Block annotate(Block b) {
        LabelAnnotatorTransformer annotator = new LabelAnnotatorTransformer(){

            @Override
            protected Object annotation(LabelStatement node) {
                ResolvedLabel rl = (ResolvedLabel)LabelResolutionTransformer.this.defs.get(node);
                if (rl == null) {
                    throw new IllegalStateException("unresolved label '" + node.labelName().value() + "' in label statement at line " + node.line());
                }
                return rl;
            }

            @Override
            protected Object annotation(GotoStatement node) {
                ResolvedLabel rl = (ResolvedLabel)LabelResolutionTransformer.this.uses.get(node);
                if (rl == null) {
                    throw new IllegalStateException("unresolved label '" + node.labelName().value() + "' in goto statement at line " + node.line());
                }
                return rl;
            }
        };
        return annotator.transform(b);
    }

    private Block transformTopBlock(Block b) {
        b = this.transform(b);
        return this.annotate(b);
    }

    @Override
    public Chunk transform(Chunk chunk) {
        return chunk.update(this.transformTopBlock(chunk.block()));
    }

    @Override
    public Expr transform(FunctionDefExpr e) {
        LabelResolutionTransformer child = new LabelResolutionTransformer();
        return e.update(e.params(), child.transformTopBlock(e.block()));
    }

    private static Statement lastNonVoidStatement(Block block) {
        Statement result = null;
        for (BodyStatement bs : block.statements()) {
            if (LabelResolutionTransformer.isVoidStatement(bs)) continue;
            result = bs;
        }
        if (block.returnStatement() != null) {
            result = block.returnStatement();
        }
        return result;
    }

    @Override
    public Block transform(Block block) {
        this.enterBlock();
        Statement localScopeEnd = LabelResolutionTransformer.lastNonVoidStatement(block);
        ArrayList<BodyStatement> stats = new ArrayList<BodyStatement>();
        for (BodyStatement bs : block.statements()) {
            stats.add(bs.accept(this));
            if (!Objects.equals(localScopeEnd, bs)) continue;
            this.endBlockScopes();
        }
        ReturnStatement ret = block.returnStatement() != null ? block.returnStatement().accept(this) : null;
        this.leaveBlock();
        return block.update(Collections.unmodifiableList(stats), ret);
    }

    @Override
    public BodyStatement transform(LabelStatement node) {
        this.defLabel(node);
        return node;
    }

    @Override
    public BodyStatement transform(GotoStatement node) {
        this.useLabel(node);
        return node;
    }

    @Override
    public BodyStatement transform(LocalDeclStatement node) {
        this.defLocal(node.names().get(0));
        return node;
    }

    private class Scope {
        private final Map<Name, LabelDef> definedHere = new HashMap<Name, LabelDef>();
        private final List<PendingGoto> pending = new ArrayList<PendingGoto>();
        private final Set<Name> locals = new HashSet<Name>();

        public void defLabel(LabelStatement node) {
            Name labelName = node.labelName();
            ResolvedLabel rl = new ResolvedLabel();
            LabelDef prevDef = this.definedHere.put(labelName, new LabelDef(node.line(), rl));
            if (prevDef != null) {
                throw new NameResolutionException("label '" + labelName.value() + "' already defined on line " + prevDef.line);
            }
            ResolvedLabel old = LabelResolutionTransformer.this.defs.put(node, rl);
            assert (old == null);
            ArrayList<PendingGoto> resolvedGotos = new ArrayList<PendingGoto>();
            for (PendingGoto pg : this.pending) {
                GotoStatement gotoStat = pg.statement;
                if (!gotoStat.labelName().equals(labelName)) continue;
                if (!pg.localsSince.isEmpty()) {
                    Name localName = (Name)pg.localsSince.get(0);
                    throw new NameResolutionException("<goto " + labelName.value() + "> at line " + gotoStat.line() + " jumps into the scope of local '" + localName.value() + "'");
                }
                ResolvedLabel old2 = LabelResolutionTransformer.this.uses.put(gotoStat, rl);
                assert (old2 == null);
                resolvedGotos.add(pg);
            }
            this.pending.removeAll(resolvedGotos);
        }

        public void useLabel(GotoStatement node) {
            LabelDef ldef = this.definedHere.get(node.labelName());
            if (ldef != null) {
                ResolvedLabel old = LabelResolutionTransformer.this.uses.put(node, ldef.labelObject);
                assert (old == null);
            } else {
                this.pending.add(new PendingGoto(node));
            }
        }

        public void addGotos(Iterable<PendingGoto> gotos) {
            for (PendingGoto pg : gotos) {
                this.useLabel(pg.statement);
            }
        }

        public void defLocal(Name name) {
            this.locals.add(name);
            for (PendingGoto pg : this.pending) {
                pg.addLocal(name);
            }
        }

        public void clearLocals() {
            for (Name n : this.locals) {
                for (PendingGoto pg : this.pending) {
                    pg.localsSince.remove(n);
                }
            }
            this.locals.clear();
        }
    }

    private static class PendingGoto {
        private final GotoStatement statement;
        private final List<Name> localsSince;

        private PendingGoto(GotoStatement statement) {
            this.statement = Objects.requireNonNull(statement);
            this.localsSince = new ArrayList<Name>();
        }

        public void addLocal(Name local) {
            this.localsSince.add(local);
        }
    }

    private static class LabelDef {
        public final int line;
        public final ResolvedLabel labelObject;

        private LabelDef(int line, ResolvedLabel labelObject) {
            this.line = line;
            this.labelObject = Objects.requireNonNull(labelObject);
        }
    }
}

