/*
 * Decompiled with CFR 0.152.
 */
package org.classdump.luna.parser.ast;

import java.util.List;
import java.util.Objects;
import org.classdump.luna.parser.ast.Attributes;
import org.classdump.luna.parser.ast.BodyStatement;
import org.classdump.luna.parser.ast.Expr;
import org.classdump.luna.parser.ast.Name;
import org.classdump.luna.parser.ast.Transformer;

public class LocalDeclStatement
extends BodyStatement {
    private final List<Name> names;
    private final List<Expr> initialisers;

    public LocalDeclStatement(Attributes attr, List<Name> names, List<Expr> initialisers) {
        super(attr);
        this.names = Objects.requireNonNull(names);
        if (names.isEmpty()) {
            throw new IllegalArgumentException("name list must not be empty");
        }
        this.initialisers = Objects.requireNonNull(initialisers);
    }

    public List<Name> names() {
        return this.names;
    }

    public List<Expr> initialisers() {
        return this.initialisers;
    }

    public LocalDeclStatement update(List<Name> names, List<Expr> initialisers) {
        if (this.names.equals(names) && this.initialisers.equals(initialisers)) {
            return this;
        }
        return new LocalDeclStatement(this.attributes(), names, initialisers);
    }

    public LocalDeclStatement withAttributes(Attributes attr) {
        if (this.attributes().equals(attr)) {
            return this;
        }
        return new LocalDeclStatement(attr, this.names, this.initialisers);
    }

    public LocalDeclStatement with(Object o) {
        return this.withAttributes(this.attributes().with(o));
    }

    @Override
    public BodyStatement accept(Transformer tf) {
        return tf.transform(this);
    }
}

