/*
 * Decompiled with CFR 0.152.
 */
package org.classdump.luna.parser.ast;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import org.classdump.luna.ByteString;
import org.classdump.luna.ByteStringBuilder;
import org.classdump.luna.parser.ast.Literal;
import org.classdump.luna.parser.ast.Name;
import org.classdump.luna.parser.ast.Transformer;

public class StringLiteral
extends Literal {
    private final ByteString value;

    private StringLiteral(ByteString value) {
        this.value = value;
    }

    private static int decValueOf(int c) {
        return c >= 48 && c <= 57 ? c - 48 : -1;
    }

    private static int hexValueOf(int c) {
        return c >= 48 && c <= 57 ? c - 48 : (c >= 97 && c <= 102 ? 10 + c - 97 : (c >= 65 && c <= 70 ? 10 + c - 65 : -1));
    }

    private static boolean isWhitespace(int c) {
        return c <= 255 && Character.isWhitespace(c);
    }

    private static void appendBytes(ByteStringBuilder builder, CharsetEncoder encoder, int codePoint) {
        ByteBuffer bytes;
        try {
            bytes = encoder.encode(CharBuffer.wrap(Character.toChars(codePoint)));
        }
        catch (CharacterCodingException ex) {
            throw new IllegalStateException(ex);
        }
        while (bytes.hasRemaining()) {
            builder.append(bytes.get());
        }
    }

    private static ByteString stringValueOf(InputStream in) throws IOException {
        int c;
        Objects.requireNonNull(in);
        BufferedInputStream stream = new BufferedInputStream(in);
        CharsetEncoder utf8Encoder = StandardCharsets.UTF_8.newEncoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);
        ByteStringBuilder bld = new ByteStringBuilder();
        int qmark = stream.read();
        if (qmark == -1) {
            throw new IllegalArgumentException("string is empty");
        }
        int pos = 1;
        while ((c = stream.read()) != -1) {
            ++pos;
            if (c == 92) {
                int d;
                int digit;
                int oldPos = pos - 1;
                c = stream.read();
                if (StringLiteral.decValueOf(c) != -1) {
                    int dec = StringLiteral.decValueOf(c);
                    int rem = 2;
                    do {
                        stream.mark(rem);
                        c = stream.read();
                        ++pos;
                        digit = StringLiteral.decValueOf(c);
                        if (digit == -1) {
                            stream.reset();
                            --pos;
                            break;
                        }
                        dec = dec * 10 + digit;
                    } while (--rem > 0);
                    if (dec > 255) {
                        throw new IllegalArgumentException("decimal escape too large at index " + oldPos);
                    }
                    bld.append((byte)dec);
                    continue;
                }
                if (c == 120) {
                    int hex = 0;
                    for (int j = 0; j < 2; ++j) {
                        c = stream.read();
                        ++pos;
                        digit = StringLiteral.hexValueOf(c);
                        if (digit == -1) {
                            throw new IllegalArgumentException("hexadecimal digit expected at index " + pos);
                        }
                        hex = (hex << 4) + digit;
                    }
                    bld.append((byte)hex);
                    continue;
                }
                if (c == 117) {
                    if (stream.read() != 123) {
                        throw new IllegalArgumentException("missing '{' at index " + (oldPos + 2));
                    }
                    ++pos;
                    c = stream.read();
                    ++pos;
                    int digit2 = StringLiteral.hexValueOf(c);
                    if (digit2 == -1) {
                        throw new IllegalArgumentException("hexadecimal digit expected at index " + (pos - 1));
                    }
                    int value = digit2;
                    do {
                        c = stream.read();
                        ++pos;
                        digit2 = StringLiteral.hexValueOf(c);
                        if (c == 125) continue;
                        if (digit2 == -1) {
                            throw new IllegalArgumentException("hexadecimal digit expected at index " + (pos - 1));
                        }
                        if ((value = (value << 4) + digit2) < 0x10FFFF) continue;
                        throw new IllegalArgumentException("UTF-8 value too large at index " + (pos - 1));
                    } while (c != 125);
                    StringLiteral.appendBytes(bld, utf8Encoder, value);
                    continue;
                }
                if (c == 122) {
                    while (StringLiteral.isWhitespace(stream.read())) {
                        ++pos;
                    }
                    continue;
                }
                if (c == 10 || c == 13) {
                    if (c == 13) {
                        if (stream.read() != 10) {
                            throw new IllegalArgumentException("\\n expected at index " + oldPos);
                        }
                        ++pos;
                    }
                    bld.append((byte)10);
                    continue;
                }
                switch (c) {
                    case 97: {
                        d = 7;
                        break;
                    }
                    case 98: {
                        d = 8;
                        break;
                    }
                    case 102: {
                        d = 12;
                        break;
                    }
                    case 110: {
                        d = 10;
                        break;
                    }
                    case 114: {
                        d = 13;
                        break;
                    }
                    case 116: {
                        d = 9;
                        break;
                    }
                    case 118: {
                        d = 11;
                        break;
                    }
                    case 92: {
                        d = 92;
                        break;
                    }
                    case 39: {
                        d = 39;
                        break;
                    }
                    case 34: {
                        d = 34;
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("invalid escape sequence at index " + oldPos + " (\\" + c + ")");
                    }
                }
                bld.append((byte)d);
                continue;
            }
            if (c == qmark) continue;
            bld.append((byte)c);
        }
        return bld.toByteString();
    }

    private static ByteString stringValueOf(ByteString s) {
        try {
            return StringLiteral.stringValueOf(s.asInputStream());
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static StringLiteral fromString(ByteString s) {
        return new StringLiteral(StringLiteral.stringValueOf(s));
    }

    @Deprecated
    public static StringLiteral fromString(String s) {
        return StringLiteral.fromString(ByteString.of(s));
    }

    public static StringLiteral verbatim(String s) {
        return new StringLiteral(ByteString.of(s));
    }

    public static StringLiteral fromName(Name n) {
        return new StringLiteral(ByteString.of(n.value()));
    }

    public ByteString value() {
        return this.value;
    }

    @Override
    public Literal accept(Transformer tf) {
        return tf.transform(this);
    }
}

