/*
 * Decompiled with CFR 0.152.
 */
package org.classdump.luna.runtime;

import java.util.Arrays;
import java.util.Iterator;
import java.util.Objects;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicInteger;
import org.classdump.luna.StateContext;
import org.classdump.luna.exec.CallEventHandler;
import org.classdump.luna.exec.Continuation;
import org.classdump.luna.exec.InvalidContinuationException;
import org.classdump.luna.exec.OneShotContinuation;
import org.classdump.luna.impl.AbstractStateContext;
import org.classdump.luna.runtime.AsyncTask;
import org.classdump.luna.runtime.ControlThrowablePayload;
import org.classdump.luna.runtime.Coroutine;
import org.classdump.luna.runtime.Errors;
import org.classdump.luna.runtime.ExecutionContext;
import org.classdump.luna.runtime.IllegalCoroutineStateException;
import org.classdump.luna.runtime.LuaFunction;
import org.classdump.luna.runtime.ResolvedControlThrowable;
import org.classdump.luna.runtime.ResumeInfo;
import org.classdump.luna.runtime.ReturnBuffer;
import org.classdump.luna.runtime.ReturnBufferFactory;
import org.classdump.luna.runtime.SchedulingContext;
import org.classdump.luna.runtime.UnresolvedControlThrowable;
import org.classdump.luna.util.Cons;

class Call {
    private final StateContext stateContext;
    private final ReturnBuffer returnBuffer;
    private Cons<Coroutine> coroutineStack;
    private final AtomicInteger currentVersion;
    private static final int VERSION_RUNNING = 0;
    private static final int VERSION_TERMINATED = 1;
    private static final ControlPayload PAUSED_PAYLOAD = new ControlPayload(true, null, null, null);
    private static final ResumeResult PAUSE_RESULT = new ResumeResult(true, null, null, null);

    private Call(StateContext stateContext, ReturnBuffer returnBuffer, Coroutine mainCoroutine) {
        this.stateContext = Objects.requireNonNull(stateContext);
        this.returnBuffer = Objects.requireNonNull(returnBuffer);
        this.coroutineStack = new Cons<Coroutine>(Objects.requireNonNull(mainCoroutine));
        int startingVersion = Call.newPausedVersion(0);
        this.currentVersion = new AtomicInteger(startingVersion);
    }

    public static Call init(StateContext stateContext, ReturnBufferFactory returnBufferFactory, Object fn, Object ... args) {
        ReturnBuffer returnBuffer = returnBufferFactory.newInstance();
        Coroutine c = new Coroutine(fn);
        returnBuffer.setToContentsOf(args);
        return new Call(stateContext, returnBuffer, c);
    }

    private static int newPausedVersion(int oldVersion) {
        int v;
        ThreadLocalRandom versionSource = ThreadLocalRandom.current();
        while (!Call.isPaused(v = ((Random)versionSource).nextInt()) || v == oldVersion) {
        }
        return v;
    }

    private static boolean isPaused(int version) {
        return version != 0 && version != 1;
    }

    private static State versionToState(int version) {
        switch (version) {
            case 0: {
                return State.RUNNING;
            }
            case 1: {
                return State.TERMINATED;
            }
        }
        return State.PAUSED;
    }

    public State getState() {
        return Call.versionToState(this.currentVersion.get());
    }

    public OneShotContinuation getCurrentContinuation() {
        int version = this.currentVersion.get();
        if (!Call.isPaused(version)) {
            State s = Call.versionToState(version);
            throw new IllegalStateException("Cannot get continuation of a " + (Object)((Object)s) + " call");
        }
        return new CallContinuation(version);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resume(CallEventHandler handler, SchedulingContext schedulingContext, int version) {
        Objects.requireNonNull(handler);
        Objects.requireNonNull(schedulingContext);
        if (version == 0 || version == 1) {
            throw new IllegalArgumentException("Illegal version: " + version);
        }
        if (!this.currentVersion.compareAndSet(version, 0)) {
            throw new InvalidContinuationException("Cannot resume call: not in the expected state (0x" + Integer.toHexString(version) + ")");
        }
        int newVersion = 1;
        ResumeResult rr = null;
        CallContinuation cont = null;
        try {
            Resumer resumer = new Resumer(schedulingContext);
            rr = resumer.resume();
            assert (rr != null);
            if (rr.pause || rr.asyncTask != null) {
                newVersion = Call.newPausedVersion(version);
                cont = new CallContinuation(newVersion);
            }
        }
        finally {
            int old = this.currentVersion.getAndSet(newVersion);
            assert (old == 0);
        }
        assert (rr != null);
        rr.fire(handler, this, cont);
    }

    class Resumer
    extends AbstractStateContext
    implements ExecutionContext,
    ControlThrowablePayload.Visitor {
        private final SchedulingContext schedulingContext;
        private ResumeResult result;
        private Throwable error;
        private Cons<ResumeInfo> callStack;

        Resumer(SchedulingContext schedulingContext) {
            super(Call.this.stateContext);
            this.schedulingContext = Objects.requireNonNull(schedulingContext);
            this.result = null;
            this.error = null;
        }

        @Override
        public ReturnBuffer getReturnBuffer() {
            return Call.this.returnBuffer;
        }

        @Override
        public Coroutine getCurrentCoroutine() {
            return (Coroutine)((Call)Call.this).coroutineStack.car;
        }

        @Override
        public Coroutine newCoroutine(LuaFunction function) {
            return new Coroutine(Objects.requireNonNull(function));
        }

        @Override
        public boolean isInMainCoroutine() {
            return ((Call)Call.this).coroutineStack.cdr != null;
        }

        @Override
        public Coroutine.Status getCoroutineStatus(Coroutine coroutine) {
            return coroutine.getStatus();
        }

        @Override
        public void resume(Coroutine coroutine, Object[] args) throws UnresolvedControlThrowable {
            Objects.requireNonNull(coroutine);
            throw new UnresolvedControlThrowable(new ControlPayload(false, Objects.requireNonNull(coroutine), Objects.requireNonNull(args), null));
        }

        @Override
        public void yield(Object[] args) throws UnresolvedControlThrowable {
            throw new UnresolvedControlThrowable(new ControlPayload(false, null, Objects.requireNonNull(args), null));
        }

        @Override
        public void resumeAfter(AsyncTask task) throws UnresolvedControlThrowable {
            throw new UnresolvedControlThrowable(new ControlPayload(false, null, null, Objects.requireNonNull(task)));
        }

        @Override
        public void registerTicks(int ticks) {
            this.schedulingContext.registerTicks(ticks);
        }

        @Override
        public void pauseIfRequested() throws UnresolvedControlThrowable {
            if (this.schedulingContext.shouldPause()) {
                this.pause();
            }
        }

        @Override
        public void pause() throws UnresolvedControlThrowable {
            throw new UnresolvedControlThrowable(PAUSED_PAYLOAD);
        }

        @Override
        public void preempted() {
            this.result = PAUSE_RESULT;
        }

        @Override
        public void coroutineYield(Object[] values) {
            assert (Call.this.coroutineStack != null);
            if (((Call)Call.this).coroutineStack.cdr == null) {
                this.error = Errors.illegalYieldAttempt();
            } else {
                Coroutine top = (Coroutine)((Call)Call.this).coroutineStack.car;
                Coroutine prev = (Coroutine)((Call)Call.this).coroutineStack.cdr.car;
                boolean yielded = false;
                try {
                    this.callStack = Coroutine._yield(prev, top, this.callStack);
                    yielded = true;
                }
                catch (IllegalCoroutineStateException ex) {
                    this.error = ex;
                }
                if (yielded) {
                    Call.this.coroutineStack = ((Call)Call.this).coroutineStack.cdr;
                    this.getReturnBuffer().setToContentsOf(values);
                }
            }
        }

        public void coroutineReturn() {
            assert (Call.this.coroutineStack != null);
            if (((Call)Call.this).coroutineStack.cdr == null) {
                if (this.error == null) {
                    Object[] values = this.getReturnBuffer().getAsArray();
                    this.result = new ResumeResult(false, values, null, null);
                } else {
                    this.result = new ResumeResult(false, null, this.error, null);
                }
            } else {
                Coroutine top = (Coroutine)((Call)Call.this).coroutineStack.car;
                Coroutine prev = (Coroutine)((Call)Call.this).coroutineStack.cdr.car;
                boolean yielded = false;
                try {
                    this.callStack = Coroutine._return(prev, top);
                    yielded = true;
                }
                catch (IllegalCoroutineStateException ex) {
                    this.error = ex;
                }
                if (yielded) {
                    Call.this.coroutineStack = ((Call)Call.this).coroutineStack.cdr;
                }
            }
        }

        @Override
        public void coroutineResume(Coroutine target, Object[] values) {
            assert (Call.this.coroutineStack != null);
            Coroutine prev = (Coroutine)((Call)Call.this).coroutineStack.car;
            boolean resumed = false;
            try {
                this.callStack = Coroutine._resume(prev, target, this.callStack);
                resumed = true;
            }
            catch (IllegalCoroutineStateException ex) {
                this.error = ex;
            }
            if (resumed) {
                Call.this.coroutineStack = new Cons<Coroutine>(target, Call.this.coroutineStack);
                this.getReturnBuffer().setToContentsOf(values);
            }
        }

        @Override
        public void async(AsyncTask task) {
            this.result = new ResumeResult(false, null, null, task);
        }

        private void saveFrames(ResolvedControlThrowable ct) {
            Iterator<ResumeInfo> it = ct.frames();
            while (it.hasNext()) {
                this.callStack = new Cons<ResumeInfo>(it.next(), this.callStack);
            }
        }

        private void continueCurrentCoroutine() {
            while (this.callStack != null) {
                ResumeInfo top = (ResumeInfo)this.callStack.car;
                this.callStack = this.callStack.cdr;
                try {
                    if (!top.resume(this, this.error)) continue;
                    this.error = null;
                }
                catch (ResolvedControlThrowable ct) {
                    this.saveFrames(ct);
                    ct.payload().accept(this);
                    return;
                }
                catch (Exception ex) {
                    this.error = ex;
                }
            }
            assert (this.callStack == null);
            this.coroutineReturn();
        }

        ResumeResult resume() {
            try {
                this.callStack = ((Coroutine)((Call)Call.this).coroutineStack.car).unpause();
                do {
                    this.continueCurrentCoroutine();
                } while (this.result == null);
                ResumeResult resumeResult = this.result;
                return resumeResult;
            }
            finally {
                if (Call.this.coroutineStack != null) {
                    ((Coroutine)((Call)Call.this).coroutineStack.car).pause(this.callStack);
                }
            }
        }
    }

    private static final class ResumeResult {
        private final boolean pause;
        private final Object[] values;
        private final Throwable error;
        private final AsyncTask asyncTask;

        private ResumeResult(boolean pause, Object[] values, Throwable error, AsyncTask asyncTask) {
            if (!(pause && values == null && error == null && asyncTask == null || values != null && !pause && error == null && asyncTask == null || error != null && !pause && values == null && asyncTask == null || asyncTask != null && !pause && values == null && error == null)) {
                throw new IllegalArgumentException("Illegal arguments: (" + pause + ", " + Arrays.toString(values) + ", " + error + ", " + asyncTask + ")");
            }
            this.pause = pause;
            this.values = values;
            this.error = error;
            this.asyncTask = asyncTask;
        }

        void fire(CallEventHandler handler, Call c, Continuation cont) {
            if (this.pause) {
                assert (cont != null);
                handler.paused(c, cont);
            } else if (this.values != null) {
                handler.returned(c, this.values);
            } else if (this.error != null) {
                handler.failed(c, this.error);
            } else if (this.asyncTask != null) {
                assert (cont != null);
                handler.async(c, cont, this.asyncTask);
            } else {
                throw new AssertionError();
            }
        }
    }

    private static class ControlPayload
    extends ControlThrowablePayload {
        private final boolean preempted;
        private final Coroutine target;
        private final Object[] values;
        private final AsyncTask task;

        private ControlPayload(boolean preempted, Coroutine target, Object[] values, AsyncTask task) {
            if (!(preempted && target == null && values == null && task == null || !preempted && values != null && task == null || !preempted && target == null && values == null && task != null)) {
                throw new IllegalArgumentException("Illegal arguments: (" + preempted + ", " + target + ", " + Arrays.toString(values) + ", " + task + ")");
            }
            this.preempted = preempted;
            this.target = target;
            this.values = values;
            this.task = task;
        }

        @Override
        public void accept(ControlThrowablePayload.Visitor visitor) {
            if (this.preempted) {
                visitor.preempted();
            } else if (this.target != null && this.values != null) {
                visitor.coroutineResume(this.target, this.values);
            } else if (this.target == null && this.values != null) {
                visitor.coroutineYield(this.values);
            } else if (this.task != null) {
                visitor.async(this.task);
            } else {
                throw new AssertionError();
            }
        }
    }

    private class CallContinuation
    implements OneShotContinuation {
        private final int version;

        private CallContinuation(int version) {
            this.version = version;
        }

        private Call outer() {
            return Call.this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CallContinuation that = (CallContinuation)o;
            return this.version == that.version && this.outer().equals(that.outer());
        }

        public int hashCode() {
            int result = this.outer().hashCode();
            result = 31 * result + this.version;
            return result;
        }

        @Override
        public Object callIdentifier() {
            return this.outer();
        }

        @Override
        public void resume(CallEventHandler handler, SchedulingContext schedulingContext) {
            Call.this.resume(handler, schedulingContext, this.version);
        }

        @Override
        public boolean isCurrent() {
            return this.version == Call.this.currentVersion.get();
        }
    }

    public static enum State {
        PAUSED,
        RUNNING,
        TERMINATED;

    }
}

