package org.clawiz.bpm.common.metadata.data.process;

import org.clawiz.core.common.system.exchange.annotation.ExchangeAttribute;
import java.lang.Boolean;
import org.clawiz.core.common.system.exchange.annotation.ExchangeElement;
import org.clawiz.core.common.system.exchange.annotation.ExchangeReference;
import java.lang.SuppressWarnings;
import org.clawiz.core.common.system.session.Session;
import org.clawiz.core.common.metadata.node.MetadataNode;
import org.clawiz.core.common.metadata.node.MetadataNodeReferencesList;

public class ProcessPrototype extends org.clawiz.core.common.metadata.node.MetadataNode {
    
    @ExchangeAttribute
    private String description;
    
    @ExchangeAttribute
    private java.lang.Boolean startOnNew;
    
    @ExchangeElement
    private org.clawiz.bpm.common.metadata.data.process.property.ProcessPropertyList properties = new org.clawiz.bpm.common.metadata.data.process.property.ProcessPropertyList();
    
    @ExchangeElement
    private org.clawiz.bpm.common.metadata.data.process.node.ProcessNodeList nodes = new org.clawiz.bpm.common.metadata.data.process.node.ProcessNodeList();
    
    @ExchangeElement
    private org.clawiz.bpm.common.metadata.data.process.swimlane.lane.LaneList lanes = new org.clawiz.bpm.common.metadata.data.process.swimlane.lane.LaneList();
    
    @ExchangeReference
    private org.clawiz.core.common.metadata.data.type.Type rootType;
    
    @ExchangeReference
    private org.clawiz.bpm.common.metadata.data.process.swimlane.pool.Pool pool;
    
    public String getDescription() {
        return this.description;
    }
    
    public void setDescription(String value) {
        this.description = value;
    }
    
    public java.lang.Boolean isStartOnNew() {
        return this.startOnNew;
    }
    
    public void setStartOnNew(java.lang.Boolean value) {
        this.startOnNew = value;
    }
    
    public org.clawiz.bpm.common.metadata.data.process.property.ProcessPropertyList getProperties() {
        return this.properties;
    }
    
    public org.clawiz.bpm.common.metadata.data.process.node.ProcessNodeList getNodes() {
        return this.nodes;
    }
    
    public org.clawiz.bpm.common.metadata.data.process.swimlane.lane.LaneList getLanes() {
        return this.lanes;
    }
    
    public org.clawiz.core.common.metadata.data.type.Type getRootType() {
        return this.rootType;
    }
    
    public void setRootType(org.clawiz.core.common.metadata.data.type.Type value) {
        this.rootType = value;
    }
    
    public org.clawiz.bpm.common.metadata.data.process.swimlane.pool.Pool getPool() {
        return this.pool;
    }
    
    public void setPool(org.clawiz.bpm.common.metadata.data.process.swimlane.pool.Pool value) {
        this.pool = value;
    }
    
    @SuppressWarnings("Duplicates")
    public void prepare(Session session) {
        super.prepare(session);
        if ( isInPrepare() ) { return; }
        setInPrepare(true);
        
        for (MetadataNode node : getProperties()) {
            if ( node != null ) { 
                node.prepare(session);
            }
        }
        for (MetadataNode node : getNodes()) {
            if ( node != null ) { 
                node.prepare(session);
            }
        }
        for (MetadataNode node : getLanes()) {
            if ( node != null ) { 
                node.prepare(session);
            }
        }
        if ( getRootType() != null ) { 
            getRootType().prepare(session);
        }
        if ( getPool() != null ) { 
            getPool().prepare(session);
        }
        
        setInPrepare(false);
    }
    
    public void fillReferences(MetadataNodeReferencesList references) {
        super.fillReferences(references);
        
        for (MetadataNode node : getProperties()) {
            references.add(node);
        }
        
        for (MetadataNode node : getNodes()) {
            references.add(node);
        }
        
        for (MetadataNode node : getLanes()) {
            references.add(node);
        }
        
        references.add(getRootType());
        
        references.add(getPool());
        
    }
}
