package org.clawiz.bpm.common.metadata.data.process.node;

import org.clawiz.core.common.system.exchange.annotation.ExchangeAttribute;
import org.clawiz.core.common.system.exchange.annotation.ExchangeReference;
import org.clawiz.core.common.system.exchange.annotation.ExchangeElement;
import java.lang.SuppressWarnings;
import org.clawiz.core.common.system.session.Session;
import org.clawiz.core.common.metadata.node.MetadataNode;
import org.clawiz.core.common.metadata.node.MetadataNodeReferencesList;

public class AbstractProcessNodePrototype extends org.clawiz.core.common.metadata.node.MetadataNode {
    
    @ExchangeAttribute
    private String description;
    
    @ExchangeReference
    private org.clawiz.bpm.common.metadata.data.process.swimlane.lane.Lane lane;
    
    @ExchangeElement
    private org.clawiz.bpm.common.metadata.data.process.flow.FlowList outgoingFlows = new org.clawiz.bpm.common.metadata.data.process.flow.FlowList();
    
    public String getDescription() {
        return this.description;
    }
    
    public void setDescription(String value) {
        this.description = value;
    }
    
    public org.clawiz.bpm.common.metadata.data.process.swimlane.lane.Lane getLane() {
        return this.lane;
    }
    
    public void setLane(org.clawiz.bpm.common.metadata.data.process.swimlane.lane.Lane value) {
        this.lane = value;
    }
    
    public org.clawiz.bpm.common.metadata.data.process.flow.FlowList getOutgoingFlows() {
        return this.outgoingFlows;
    }
    
    @SuppressWarnings("Duplicates")
    public void prepare(Session session) {
        super.prepare(session);
        if ( isInPrepare() ) { return; }
        setInPrepare(true);
        
        if ( getLane() != null ) { 
            getLane().prepare(session);
        }
        for (MetadataNode node : getOutgoingFlows()) {
            if ( node != null ) { 
                node.prepare(session);
            }
        }
        
        setInPrepare(false);
    }
    
    public void fillReferences(MetadataNodeReferencesList references) {
        super.fillReferences(references);
        
        references.add(getLane());
        
        for (MetadataNode node : getOutgoingFlows()) {
            references.add(node);
        }
        
    }
}
