/*
 * Decompiled with CFR 0.152.
 */
package org.clawiz.bpm.common.generator.helper;

import java.util.HashMap;
import org.clawiz.bpm.common.helper.ProcessHelper;
import org.clawiz.bpm.common.metadata.data.process.Process;
import org.clawiz.bpm.common.metadata.data.process.ProcessList;
import org.clawiz.core.common.metadata.data.type.Type;
import org.clawiz.core.common.system.generator.GeneratorUtils;
import org.clawiz.core.common.system.service.Service;
import org.clawiz.core.common.utils.StringUtils;

public class ProcessGeneratorHelper
extends Service {
    ProcessHelper processHelper;
    HashMap<Process, String> processClassesCommonPrefixes = new HashMap();
    HashMap<Process, String> processServiceVariableNames = new HashMap();

    public ProcessList getProcessesByRootType(Type type) {
        return this.processHelper.getProcessesByRootType(type);
    }

    public String getProcessClassCommonPrefix(Process process) {
        String name = this.processClassesCommonPrefixes.get((Object)process);
        if (name != null) {
            return name;
        }
        name = process.getPackageName() + "." + GeneratorUtils.toJavaName((String)process.getName()).toLowerCase() + "." + StringUtils.toUpperFirstChar((String)GeneratorUtils.toJavaName((String)process.getName()));
        this.processClassesCommonPrefixes.put(process, name);
        return name;
    }

    public String getProcessServiceVariableName(Process process) {
        String name = this.processServiceVariableNames.get((Object)process);
        if (name != null) {
            return name;
        }
        name = StringUtils.toLowerFirstChar((String)process.getJavaVariableName()) + "Service";
        this.processServiceVariableNames.put(process, name);
        return name;
    }

    public void clearCaches() {
        this.processClassesCommonPrefixes.clear();
        this.processServiceVariableNames.clear();
    }
}

