/*
 * Decompiled with CFR 0.152.
 */
package org.clawiz.bpm.common.helper;

import java.math.BigDecimal;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import org.clawiz.bpm.common.manager.ProcessManager;
import org.clawiz.bpm.common.manager.instance.AbstractProcessInstance;
import org.clawiz.bpm.common.manager.instance.ProcessInstanceList;
import org.clawiz.bpm.common.metadata.data.process.ProcessList;
import org.clawiz.bpm.common.metadata.data.process.node.AbstractProcessNode;
import org.clawiz.bpm.common.storage.process.ProcessService;
import org.clawiz.core.common.metadata.data.type.Type;
import org.clawiz.core.common.storage.type.TypeService;
import org.clawiz.core.common.system.database.Statement;
import org.clawiz.core.common.system.object.ObjectService;
import org.clawiz.core.common.system.service.NotInitializeService;
import org.clawiz.core.common.system.service.Service;

public class ProcessHelper
extends Service {
    ObjectService objectService;
    @NotInitializeService
    ProcessManager _processManager;
    @NotInitializeService
    ProcessService _processService;
    TypeService typeService;
    private static ConcurrentHashMap<BigDecimal, ProcessList> processesByRootTypeCache = new ConcurrentHashMap();

    public ProcessManager getProcessManager() {
        if (this._processManager == null) {
            this._processManager = (ProcessManager)this.getService(ProcessManager.class);
        }
        return this._processManager;
    }

    public ProcessService getProcessService() {
        if (this._processService == null) {
            this._processService = (ProcessService)this.getService(ProcessService.class);
        }
        return this._processService;
    }

    public ProcessList getProcessesByRootType(Type type) {
        BigDecimal typeId;
        if (type == null) {
            this.throwException("Cannot get processes list for null root type", new Object[0]);
        }
        if ((typeId = this.typeService.packageNameToId(type.getPackageName(), type.getName())) == null) {
            this.throwException("Type ?.? not found in database", new Object[]{type.getPackageName(), type.getName()});
        }
        return this.getProcessesByRootType(typeId);
    }

    public ProcessList getProcessesByRootType(BigDecimal typeId) {
        ProcessList result;
        if (typeId == null) {
            this.throwException("Cannot get processes list for null root type id", new Object[0]);
        }
        if ((result = processesByRootTypeCache.get(typeId)) != null) {
            return result;
        }
        result = new ProcessList();
        Statement statement = this.executeQuery("select id from cw_bpm_processes where root_type_id = ?", new Object[]{typeId});
        while (statement.next()) {
            result.add(this.getProcessService().getProcess(statement.getBigDecimal(1)));
        }
        processesByRootTypeCache.put(typeId, result);
        return result;
    }

    public void dump(AbstractProcessInstance instance) {
        this.logDebug("<instance " + instance.getId() + ">");
        this.logDebug(" process    : " + instance.getProcess().getFullName());
        StringBuilder sb = new StringBuilder();
        String prefix = "";
        Iterator iterator = instance.getNodes().iterator();
        while (iterator.hasNext()) {
            AbstractProcessNode state = (AbstractProcessNode)((Object)iterator.next());
            sb.append(prefix).append(state.getName());
            prefix = ", ";
        }
        this.logDebug(" nodes      : " + sb.toString());
        prefix = " next flows : ";
        this.logDebug("</process>");
    }

    public void dump(ProcessInstanceList instances) {
        instances.forEach((Consumer<? super AbstractProcessInstance>)((Consumer<AbstractProcessInstance>)this::dump));
    }

    public void dumpObjectInstances(BigDecimal objectId) {
        this.logDebug("");
        this.logDebug("Start dump instances for " + objectId + " : " + this.objectService.idToString(objectId));
        this.dump(this.getProcessManager().getObjectInstanceList(objectId));
        this.logDebug("End   dump instances for " + objectId + " : " + this.objectService.idToString(objectId));
        this.logDebug("");
    }
}

