/*
 * Decompiled with CFR 0.152.
 */
package org.clawiz.bpm.common.install;

import java.math.BigDecimal;
import java.util.Iterator;
import org.clawiz.bpm.common.generator.service.ProcessGenerator;
import org.clawiz.bpm.common.metadata.data.process.Process;
import org.clawiz.bpm.common.metadata.data.process.node.AbstractProcessNode;
import org.clawiz.bpm.common.storage.process.ProcessObject;
import org.clawiz.bpm.common.storage.process.ProcessService;
import org.clawiz.bpm.common.storage.processnode.ProcessNodeObject;
import org.clawiz.bpm.common.storage.processnode.ProcessNodeService;
import org.clawiz.core.common.metadata.install.AbstractMetadataNodeInstaller;

public class ProcessInstaller
extends AbstractMetadataNodeInstaller {
    ProcessService processService;
    ProcessNodeService processNodeService;

    protected void saveProcess(Process process) {
        BigDecimal processId = this.processService.packageNameToId(process.getPackageName(), process.getName());
        ProcessObject po = processId == null ? this.processService.create() : this.processService.load(processId);
        po.setPackageName(process.getPackageName());
        po.setName(process.getName());
        po.setRootTypeId(process.getRootType() != null ? process.getRootType().getId() : null);
        po.save();
        Iterator iterator = process.getNodes().iterator();
        while (iterator.hasNext()) {
            AbstractProcessNode processNode = (AbstractProcessNode)((Object)iterator.next());
            ProcessNodeObject nodeObject = this.processNodeService.load(this.processNodeService.processNameToId(po.getId(), processNode.getName(), true));
            nodeObject.save();
        }
    }

    public void process() {
        this.saveProcess((Process)this.getNode());
        ProcessGenerator generator = (ProcessGenerator)this.getService(ProcessGenerator.class, true);
        generator.setRootDestinationPath(this.getDestinationPath());
        generator.setProcess((Process)this.getNode());
        generator.run();
    }
}

