/*
 * Decompiled with CFR 0.152.
 */
package org.clawiz.bpm.common.manager;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Iterator;
import org.clawiz.bpm.common.helper.ProcessHelper;
import org.clawiz.bpm.common.manager.instance.AbstractProcessInstance;
import org.clawiz.bpm.common.manager.instance.ProcessInstanceList;
import org.clawiz.bpm.common.manager.instance.ProcessInstanceParameterList;
import org.clawiz.bpm.common.metadata.data.process.Process;
import org.clawiz.bpm.common.metadata.data.process.flow.AbstractFlow;
import org.clawiz.bpm.common.metadata.data.process.node.AbstractProcessNode;
import org.clawiz.bpm.common.metadata.data.process.node.event.end.AbstractEndEvent;
import org.clawiz.bpm.common.storage.process.ProcessService;
import org.clawiz.bpm.common.storage.processinstance.ProcessInstanceObject;
import org.clawiz.bpm.common.storage.processinstance.ProcessInstanceService;
import org.clawiz.core.common.system.database.Statement;
import org.clawiz.core.common.system.service.Service;

public class ProcessManager
extends Service {
    ProcessService processService;
    ProcessInstanceService processInstanceService;
    ProcessHelper processHelper;

    public void startProcess(AbstractProcessInstance instance) {
        instance.setSession(this.getSession());
        ProcessInstanceObject instanceObject = this.processInstanceService.create();
        instanceObject.setProcessId(instance.getProcess().getId());
        instanceObject.setObjectId(instance.getObjectId());
        instanceObject.setActive("T");
        instanceObject.save();
        instance.setId(instanceObject.getId());
        if (instance.getNodes().size() > 0) {
            this.throwException("Process instance already active", new Object[0]);
        }
        Iterator iterator = instance.getProcess().getStartNodes().iterator();
        while (iterator.hasNext()) {
            AbstractProcessNode node = (AbstractProcessNode)((Object)iterator.next());
            this.executeUpdate("insert into cw_bpm_pinstance_nodes (instance_id, node_id) values (?, ?)", new Object[]{instanceObject.getId(), node.getId()});
            instance.getNodes().add(node);
        }
        instance.clearCaches();
        this.executePossibleFlows(instance, 0);
    }

    public BigDecimal getObjectProcessInstanceId(BigDecimal objectId, BigDecimal processId) {
        Statement statement = this.executeQuery("select id from cw_bpm_process_instances where object_id = ? and process_id = ? and active=? ", new Object[]{objectId, processId, "T"});
        BigDecimal instanceId = null;
        while (statement.next()) {
            if (instanceId != null) {
                this.throwException("Process ? has more then one active instance for object @ /?/", new Object[]{this.processService.getProcess(processId).getFullName(), objectId, objectId});
            }
            instanceId = statement.getBigDecimal(1);
        }
        statement.close();
        return instanceId;
    }

    public boolean isFlowAllowed(AbstractProcessInstance instance, AbstractFlow flow) {
        return instance.getService().isFlowAllowed(instance, flow);
    }

    public ArrayList<AbstractFlow> getAllowedFlows(AbstractProcessInstance instance) {
        ArrayList<AbstractFlow> result = new ArrayList<AbstractFlow>();
        Iterator iterator = instance.getNodes().iterator();
        while (iterator.hasNext()) {
            AbstractProcessNode node = (AbstractProcessNode)((Object)iterator.next());
            Iterator iterator2 = node.getOutgoingFlows().iterator();
            while (iterator2.hasNext()) {
                AbstractFlow flow = (AbstractFlow)((Object)iterator2.next());
                if (!this.isFlowAllowed(instance, flow)) continue;
                result.add(flow);
            }
        }
        return result;
    }

    public void executeFlow(BigDecimal objectId, String processName, String nodeName, String flowName) {
        AbstractFlow flow;
        Process process;
        AbstractProcessNode node;
        BigDecimal processId = this.processService.fullNameToId(processName);
        if (processId == null) {
            this.throwException("Process '?' not registered in database", new Object[]{processName});
        }
        if ((node = (AbstractProcessNode)(process = this.processService.getProcess(processId)).getNodes().get(nodeName)) == null) {
            this.throwException("Process ? does not contain node '?'", new Object[]{process.getFullName(), node.getName()});
        }
        if ((flow = (AbstractFlow)node.getOutgoingFlows().get(flowName)) == null) {
            this.throwException("Process ? node ? does not contain flow '?'", new Object[]{process.getFullName(), node.getName(), flow.getName()});
        }
        AbstractProcessInstance foundInstance = null;
        for (AbstractProcessInstance instance : this.getObjectInstanceList(objectId)) {
            if (!instance.getProcess().getId().equals(processId)) continue;
            if (foundInstance != null) {
                this.throwException("Object @ /?/ has more than one active instance of process ?", new Object[]{objectId, objectId, process.getFullName()});
            }
            foundInstance = instance;
        }
        if (foundInstance == null) {
            this.throwException("Object @ /?/ has not active instances of process ?", new Object[]{objectId, objectId, process.getFullName()});
        }
        this.executeFlow(foundInstance.getId(), flow);
    }

    public void executeFlow(BigDecimal instanceId, AbstractFlow flow) {
        this.executeFlow(this.getInstance(instanceId), flow);
    }

    private void executePossibleFlows(AbstractProcessInstance instance, int nestedLevel) {
        Iterator iterator = instance.getNodes().iterator();
        while (iterator.hasNext()) {
            AbstractProcessNode node = (AbstractProcessNode)((Object)iterator.next());
            if (!node.isAutoOut()) continue;
            Iterator iterator2 = node.getOutgoingFlows().iterator();
            while (iterator2.hasNext()) {
                AbstractFlow flow = (AbstractFlow)((Object)iterator2.next());
                if (!instance.getService().isFlowAllowed(instance, flow)) continue;
                this.executeFlow(instance, flow, nestedLevel);
            }
        }
    }

    public void executeFlow(AbstractProcessInstance instance, AbstractFlow flow) {
        this.executeFlow(instance, flow, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeFlow(AbstractProcessInstance instance, AbstractFlow flow, int nestedLevel) {
        AbstractProcessInstance abstractProcessInstance = instance;
        synchronized (abstractProcessInstance) {
            if (!instance.getService().isFlowAllowed(instance, flow)) {
                this.throwException("Flow ? of process ? not allowed to run for object @ /?/", new Object[]{flow.getName(), instance.getProcess().getFullName(), instance.getObjectId(), instance.getObjectId()});
            }
            instance.getNodes().add(flow.getTargetNode());
            instance.getNodes().remove(flow.getSourceNode());
            this.executeUpdate("delete from cw_bpm_pinstance_nodes where instance_id = ? and node_id = ?", new Object[]{instance.getId(), flow.getSourceNode().getId()});
            this.executeUpdate("insert into cw_bpm_pinstance_nodes (instance_id, node_id) values (?, ?)", new Object[]{instance.getId(), flow.getTargetNode().getId()});
            instance.getService().processNode(instance, flow.getTargetNode());
            instance.getObject().save();
            this.executePossibleFlows(instance, nestedLevel + 1);
            instance.clearCaches();
            if (AbstractEndEvent.class.isAssignableFrom(((Object)((Object)flow.getTargetNode())).getClass())) {
                this.stopProcess(instance);
            }
        }
    }

    protected void stopProcess(AbstractProcessInstance instance) {
        ProcessInstanceObject instanceObject = this.processInstanceService.load(instance.getId());
        instanceObject.setActive("F");
        instanceObject.save();
    }

    public void callNestedProcess(AbstractProcessInstance sourceInstance, String processName) {
        ProcessInstanceObject sourceInstanceObject = this.processInstanceService.load(sourceInstance.getId());
        sourceInstanceObject.setActive("W");
        sourceInstanceObject.save();
        Process process = this.processService.getProcess(this.processService.fullNameToId(processName));
        AbstractProcessInstance instance = null;
        try {
            instance = process.getInstanceClass().newInstance();
        }
        catch (Exception e) {
            this.throwException("Exception on create process '?' instance ? : ?", new Object[]{process.getFullName(), process.getInstanceClass().getName(), e.getMessage(), e});
        }
        instance.setProcess(process);
        instance.setSession(this.getSession());
        instance.setObjectId(sourceInstance.getObjectId());
        this.startProcess(instance);
        this.executeUpdate("insert into cw_bpm_process_calls (source_instance_id, called_instance_id) values (?,?)", new Object[]{sourceInstance.getId(), instance.getId()});
    }

    public AbstractProcessInstance loadInstance(BigDecimal id) {
        AbstractProcessInstance instance = null;
        Statement statement = this.executeQuery("select process_id, object_id from cw_bpm_process_instances where id = ?", new Object[]{id});
        if (!statement.next()) {
            this.throwException("Process instance with id ? not found", new Object[]{id});
        }
        Process process = this.processService.getProcess(statement.getBigDecimal(1));
        try {
            instance = process.getInstanceClass().newInstance();
            instance.setSession(this.getSession());
        }
        catch (Exception e) {
            this.throwException("Exception on create process ? instance ? : ?", new Object[]{process.getFullName(), process.getInstanceClass().getName(), e.getMessage(), e});
        }
        instance.setId(id);
        instance.setProcess(process);
        instance.setObjectId(statement.getBigDecimal(2));
        statement.close();
        ProcessInstanceParameterList parameters = new ProcessInstanceParameterList();
        statement = this.executeQuery("select name, number_value from cw_bpm_pinstance_parameters where instance_id = ?", new Object[]{id});
        while (statement.next()) {
            parameters.setBigDecimal(statement.getString(1), statement.getBigDecimal(2));
        }
        statement.close();
        instance.fromParameterList(parameters);
        statement = this.executeQuery("select node_id from cw_bpm_pinstance_nodes where instance_id = ?", new Object[]{id});
        while (statement.next()) {
            AbstractProcessNode node = (AbstractProcessNode)process.getNodes().get(statement.getBigDecimal(1));
            if (node == null) {
                this.throwException("Node @ (?) not exists in process ? states", new Object[]{statement.getBigDecimal(1), statement.getBigDecimal(1), process.getFullName()});
            }
            instance.getNodes().add(node);
        }
        statement.close();
        return instance;
    }

    public AbstractProcessInstance getInstance(BigDecimal id) {
        if (id == null) {
            this.throwException("Instance id cannot be null", new Object[0]);
        }
        return this.loadInstance(id);
    }

    public ProcessInstanceList loadObjectInstanceList(BigDecimal objectId) {
        ProcessInstanceList result = new ProcessInstanceList();
        Statement statement = this.executeQuery("select id from cw_bpm_process_instances where object_id = ? and active=?", new Object[]{objectId, "T"});
        while (statement.next()) {
            result.add(this.getInstance(statement.getBigDecimal(1)));
        }
        return result;
    }

    public ProcessInstanceList getObjectInstanceList(BigDecimal objectId) {
        if (objectId == null) {
            return null;
        }
        try {
            return this.loadObjectInstanceList(objectId);
        }
        catch (Exception e) {
            this.throwException("Exception on get object ? instances : ?", new Object[]{objectId, e.getMessage(), e});
            e.printStackTrace();
            return null;
        }
    }
}

