/*
 * Decompiled with CFR 0.152.
 */
package org.clawiz.bpm.common.manager.instance;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Spliterator;
import java.util.function.Consumer;
import org.clawiz.bpm.common.manager.instance.ProcessInstanceParameter;
import org.clawiz.core.common.CoreException;

public class ProcessInstanceParameterList
implements Iterable<ProcessInstanceParameter> {
    ArrayList<ProcessInstanceParameter> list = new ArrayList();
    HashMap<String, ProcessInstanceParameter> namesCache = new HashMap();

    public void set(ProcessInstanceParameter parameter) {
        if (parameter == null) {
            throw new CoreException("Cannot set null process parameter", new Object[0]);
        }
        if (parameter.name == null) {
            throw new CoreException("Cannot set process parameter with null name", new Object[0]);
        }
        if (this.namesCache.get(parameter.name) != null) {
            this.namesCache.remove(parameter.name);
            for (int i = 0; i < this.list.size(); ++i) {
                if (!this.list.get((int)i).name.equals(parameter.name)) continue;
                this.list.remove(i);
                break;
            }
        }
        this.namesCache.put(parameter.name, parameter);
        this.list.add(parameter);
    }

    public ProcessInstanceParameter get(String name) {
        return name != null ? this.namesCache.get(name) : null;
    }

    public void setBigDecimal(String name, BigDecimal objectId) {
        ProcessInstanceParameter parameter = new ProcessInstanceParameter();
        parameter.name = name;
        parameter.bigDecimal = objectId;
        this.set(parameter);
    }

    public BigDecimal getBigDecimal(String name) {
        ProcessInstanceParameter parameter = this.get(name);
        return parameter != null ? parameter.bigDecimal : null;
    }

    @Override
    public Iterator<ProcessInstanceParameter> iterator() {
        return this.list.iterator();
    }

    @Override
    public void forEach(Consumer<? super ProcessInstanceParameter> action) {
        this.list.forEach((Consumer<ProcessInstanceParameter>)action);
    }

    @Override
    public Spliterator<ProcessInstanceParameter> spliterator() {
        return this.list.spliterator();
    }
}

