/*
 * Decompiled with CFR 0.152.
 */
package org.clawiz.bpm.common.metadata.data.process;

import java.util.Iterator;
import org.clawiz.bpm.common.install.ProcessInstaller;
import org.clawiz.bpm.common.manager.instance.AbstractProcessInstance;
import org.clawiz.bpm.common.manager.service.AbstractProcessService;
import org.clawiz.bpm.common.metadata.data.process.ProcessPrototype;
import org.clawiz.bpm.common.metadata.data.process.node.AbstractProcessNode;
import org.clawiz.bpm.common.metadata.data.process.node.ProcessNodeList;
import org.clawiz.bpm.common.metadata.data.process.node.event.start.NoneStartEvent;
import org.clawiz.core.common.Core;
import org.clawiz.core.common.CoreException;
import org.clawiz.core.common.metadata.install.AbstractMetadataNodeInstaller;
import org.clawiz.core.common.system.generator.GeneratorUtils;

public class Process
extends ProcessPrototype {
    private String _servicePackageName;
    private String _javaClassNamePrefix;
    String _instanceClassName;
    private String _serviceClassName;
    private Class<AbstractProcessInstance> _instanceClass;
    private Class<AbstractProcessService> _serviceClass;
    private ProcessNodeList _startNodes;

    public <T extends AbstractMetadataNodeInstaller> Class<T> getInstallerClass() {
        return ProcessInstaller.class;
    }

    public String getServicePackageName() {
        if (this._servicePackageName == null) {
            this._servicePackageName = this.getPackageName() + "." + this.getJavaName().toLowerCase();
        }
        return this._servicePackageName;
    }

    public String getJavaClassName() {
        return super.getJavaClassName();
    }

    private String getJavaClassNamePrefix() {
        if (this._javaClassNamePrefix != null) {
            return this._javaClassNamePrefix;
        }
        this._javaClassNamePrefix = this.getServicePackageName() + "." + GeneratorUtils.toJavaName((String)this.getName(), (boolean)true);
        return this._javaClassNamePrefix;
    }

    public String getInstanceClassName() {
        if (this._instanceClassName == null) {
            this._instanceClassName = this.getJavaClassName() + "Instance";
        }
        return this._instanceClassName;
    }

    public String getServiceClassName() {
        if (this._serviceClassName == null) {
            this._serviceClassName = this.getJavaClassName() + "Service";
        }
        return this._serviceClassName;
    }

    public Class<AbstractProcessInstance> getInstanceClass() {
        if (this._instanceClass != null) {
            return this._instanceClass;
        }
        this._instanceClass = Core.getClassByName((String)(this.getServicePackageName() + "." + this.getInstanceClassName()));
        return this._instanceClass;
    }

    public Class<AbstractProcessService> getServiceClass() {
        if (this._serviceClass != null) {
            return this._serviceClass;
        }
        this._serviceClass = Core.getClassByName((String)(this.getServicePackageName() + "." + this.getServiceClassName()));
        return this._serviceClass;
    }

    public ProcessNodeList getStartNodes() {
        if (this._startNodes == null) {
            ProcessNodeList startNodes = new ProcessNodeList();
            AbstractProcessNode startNode = null;
            Iterator iterator = this.getNodes().iterator();
            while (iterator.hasNext()) {
                AbstractProcessNode node = (AbstractProcessNode)((Object)iterator.next());
                if (!NoneStartEvent.class.isAssignableFrom(((Object)((Object)node)).getClass())) continue;
                if (startNode != null) {
                    throw new CoreException("Process ? have more then one NoneStartEvent node", new Object[]{this.getFullName()});
                }
                startNode = node;
            }
            if (startNode == null) {
                throw new CoreException("Process ? have not NoneStartEvent node", new Object[]{this.getFullName()});
            }
            startNodes.add(startNode);
            this._startNodes = startNodes;
        }
        return this._startNodes;
    }
}

