/*
 * Decompiled with CFR 0.152.
 */
package org.clawiz.bpm.common.storage.message;

import org.clawiz.bpm.common.storage.message.MessageObject;
import org.clawiz.bpm.common.storage.message.MessageService;
import org.clawiz.core.common.CoreException;
import org.clawiz.core.common.system.object.AbstractObject;

public class MessageObjectPrototype
extends AbstractObject {
    private String packageName;
    private String name;
    public MessageService service;

    public String getPackageName() {
        return this.packageName;
    }

    public void setPackageName(String packageName) {
        if (packageName != null && packageName.length() > 250) {
            throw new CoreException("Length of field '?' value cannot be more then ?", new Object[]{"Message.PackageName", "250"});
        }
        this.packageName = packageName;
    }

    public MessageObjectPrototype withPackageName(String packageName) {
        this.setPackageName(packageName);
        return this;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (name != null && name.length() > 128) {
            throw new CoreException("Length of field '?' value cannot be more then ?", new Object[]{"Message.Name", "128"});
        }
        this.name = name;
    }

    public MessageObjectPrototype withName(String name) {
        this.setName(name);
        return this;
    }

    public MessageService getService() {
        return this.service;
    }

    public void setService(MessageService service) {
        this.service = service;
    }

    public void copy(MessageObjectPrototype target) {
        target.setPackageName(this.getPackageName());
        target.setName(this.getName());
    }

    public void fillDefaults() {
        if (this.service == null) {
            throw new CoreException("Service must be defined before fill object default values", new Object[0]);
        }
    }

    public void check() {
        if (this.service == null) {
            throw new CoreException("Service must be defined before check object data", new Object[0]);
        }
        this.service.check((MessageObject)this);
    }

    public void save() {
        if (this.service == null) {
            throw new CoreException("Service must be defined before save object", new Object[0]);
        }
        this.service.save((MessageObject)this);
    }

    public boolean equals(MessageObjectPrototype object) {
        return this.isObjectsEquals(this.getPackageName(), object.getPackageName()) && this.isObjectsEquals(this.getName(), object.getName());
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.getPackageName() != null ? this.getPackageName().hashCode() : 0);
        result = result * 31 + (this.getName() != null ? this.getName().hashCode() : 0);
        return result;
    }

    public String toPackageName() {
        return this.getPackageName() + "," + this.getName();
    }
}

