/*
 * Decompiled with CFR 0.152.
 */
package org.clawiz.bpm.common.storage.message;

import java.math.BigDecimal;
import org.clawiz.bpm.common.storage.message.MessageList;
import org.clawiz.bpm.common.storage.message.MessageObject;
import org.clawiz.bpm.common.storage.message.MessageService;
import org.clawiz.core.common.storage.type.TypeService;
import org.clawiz.core.common.system.database.Statement;
import org.clawiz.core.common.system.session.transaction.TransactionAction;
import org.clawiz.core.common.system.session.transaction.TransactionActionType;
import org.clawiz.core.common.system.type.AbstractTypeService;

public class MessageServicePrototype
extends AbstractTypeService<MessageObject> {
    private static BigDecimal _typeId;

    public void init() {
        super.init();
        if (_typeId == null && (_typeId = ((TypeService)this.getService(TypeService.class)).packageNameToId("org.clawiz.bpm.common.storage", "Message")) == null) {
            this.throwException("Type '?' not registered in database", new Object[]{"org.clawiz.bpm.common.storage.Message"});
        }
        this.setTypeId(_typeId);
    }

    public void check(MessageObject message) {
        if (message == null) {
            this.throwException("Cannot check null ?", new Object[]{"MessageObject"});
        }
        message.fillDefaults();
        if (this.packageNameToId(message.getPackageName(), message.getName(), message.getId()) != null) {
            this.throwException("? '?' already exists", new Object[]{"Message", message.toPackageName()});
        }
    }

    public MessageObject create() {
        MessageObject message = new MessageObject();
        message.setService((MessageService)this);
        message.fillDefaults();
        return message;
    }

    public MessageObject load(BigDecimal id) {
        Statement statement = this.executeQuery("select package_name, name from cw_bpm_messages where id = ?", new Object[]{id});
        if (!statement.next()) {
            statement.close();
            this.throwException("? with id ? not found in database", new Object[]{"Message", id});
        }
        MessageObject result = new MessageObject();
        result.setService((MessageService)this);
        result.setId(id);
        result.setPackageName(statement.getString(1));
        result.setName(statement.getString(2));
        statement.close();
        return result;
    }

    public MessageList loadList(String whereClause, Object ... parameters) {
        return this.loadOrderedList(whereClause, null, parameters);
    }

    public MessageList loadOrderedList(String whereClause, String orderByClause, Object ... parameters) {
        MessageList result = new MessageList();
        Statement statement = this.executeQuery("select id, package_name, name from cw_bpm_messages" + (whereClause != null ? " where " + whereClause : "") + (orderByClause != null ? " order by " + orderByClause : ""), parameters);
        while (statement.next()) {
            MessageObject object = new MessageObject();
            object.setService((MessageService)this);
            object.setId(statement.getBigDecimal(1));
            object.setPackageName(statement.getString(2));
            object.setName(statement.getString(3));
            result.add((Object)object);
        }
        statement.close();
        return result;
    }

    public BigDecimal packageNameToId(String packageName, String name) {
        return this.packageNameToId(packageName, name, null);
    }

    public BigDecimal packageNameToId(String packageName, String name, BigDecimal skipId) {
        if (packageName == null || name == null) {
            return null;
        }
        if (skipId == null) {
            return this.executeQueryBigDecimal("select id from cw_bpm_messages where upper_package_name = ? and upper_name = ?", new Object[]{packageName.toUpperCase(), name.toUpperCase()});
        }
        return this.executeQueryBigDecimal("select id from cw_bpm_messages where upper_package_name = ? and upper_name = ? and id != ?", new Object[]{packageName.toUpperCase(), name.toUpperCase(), skipId});
    }

    public BigDecimal packageNameToId(String packageName, String name, boolean createNewIfNotFound) {
        BigDecimal id = this.packageNameToId(packageName, name, null);
        if (id != null || !createNewIfNotFound) {
            return id;
        }
        MessageObject object = this.create();
        object.setPackageName(packageName);
        object.setName(name);
        this.save(object);
        return object.getId();
    }

    public String idToPackageName(BigDecimal id) {
        if (id == null) {
            return null;
        }
        Statement statement = this.executeQuery("select package_name, name from cw_bpm_messages where id = ?", new Object[]{id});
        if (!statement.next()) {
            statement.close();
            return null;
        }
        MessageObject object = new MessageObject();
        object.setService((MessageService)this);
        object.setId(id);
        object.setPackageName(statement.getString(1));
        object.setName(statement.getString(2));
        statement.close();
        return object.toPackageName();
    }

    public String idToString(BigDecimal id) {
        return this.idToPackageName(id);
    }

    public String objectToString(MessageObject messageObject) {
        return messageObject.toPackageName();
    }

    protected void saveAudit(TransactionAction transactionAction, MessageObject oldMessageObject, MessageObject newMessageObject) {
        MessageObject o = oldMessageObject != null ? oldMessageObject : new MessageObject();
        MessageObject n = newMessageObject != null ? newMessageObject : new MessageObject();
        this.executeUpdate("insert into a_cw_bpm_messages (scn, action_type, id , o_package_name, o_upper_package_name, o_name, o_upper_name, n_package_name, n_upper_package_name, n_name, n_upper_name) values ( ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)", new Object[]{transactionAction.getScn(), transactionAction.getType().toString(), o.getId() != null ? o.getId() : n.getId(), o.getPackageName(), o.getPackageName() != null ? o.getPackageName().toUpperCase() : null, o.getName(), o.getName() != null ? o.getName().toUpperCase() : null, n.getPackageName(), n.getPackageName() != null ? n.getPackageName().toUpperCase() : null, n.getName(), n.getName() != null ? n.getName().toUpperCase() : null});
    }

    public void save(MessageObject message) {
        TransactionAction transactionAction;
        MessageObject oldMessage;
        if (message == null) {
            this.throwException("Cannot save NULL ?", new Object[]{"MessageObject"});
        }
        if (message.getService() == null) {
            message.setService((MessageService)this);
        }
        this.check(message);
        if (message.getId() == null) {
            message.setId(this.getObjectService().createObject(this.getTypeId()));
            oldMessage = null;
            transactionAction = this.getSession().newObjectTransactionAction(TransactionActionType.NEW, message.getId());
            this.executeUpdate("insert into cw_bpm_messages( id, package_name, upper_package_name, name, upper_name ) values(?, ?, ?, ?, ?)", new Object[]{message.getId(), message.getPackageName(), message.getPackageName() != null ? message.getPackageName().toUpperCase() : null, message.getName(), message.getName() != null ? message.getName().toUpperCase() : null});
        } else {
            oldMessage = this.load(message.getId());
            if (oldMessage.equals(message)) {
                return;
            }
            transactionAction = this.getSession().newObjectTransactionAction(TransactionActionType.CHANGE, message.getId());
            this.executeUpdate("update cw_bpm_messages set package_name = ?, upper_package_name = ?, name = ?, upper_name = ? where id = ?", new Object[]{message.getPackageName(), message.getPackageName() != null ? message.getPackageName().toUpperCase() : null, message.getName(), message.getName() != null ? message.getName().toUpperCase() : null, message.getId()});
        }
        this.saveAudit(transactionAction, oldMessage, message);
    }

    public void delete(BigDecimal id) {
        MessageObject oldMessageObject = this.load(id);
        TransactionAction transactionAction = this.getSession().newObjectTransactionAction(TransactionActionType.DELETE, id);
        this.saveAudit(transactionAction, oldMessageObject, null);
        this.getObjectService().deleteObject(id);
        this.executeUpdate("delete from cw_bpm_messages where id = ?", new Object[]{id});
    }
}

