/*
 * Decompiled with CFR 0.152.
 */
package org.clawiz.bpm.common.storage.pool;

import java.math.BigDecimal;
import org.clawiz.bpm.common.storage.pool.PoolList;
import org.clawiz.bpm.common.storage.pool.PoolObject;
import org.clawiz.bpm.common.storage.pool.PoolService;
import org.clawiz.core.common.storage.type.TypeService;
import org.clawiz.core.common.system.database.Statement;
import org.clawiz.core.common.system.session.transaction.TransactionAction;
import org.clawiz.core.common.system.session.transaction.TransactionActionType;
import org.clawiz.core.common.system.type.AbstractTypeService;

public class PoolServicePrototype
extends AbstractTypeService<PoolObject> {
    private static BigDecimal _typeId;

    public void init() {
        super.init();
        if (_typeId == null && (_typeId = ((TypeService)this.getService(TypeService.class)).packageNameToId("org.clawiz.bpm.common.storage", "Pool")) == null) {
            this.throwException("Type '?' not registered in database", new Object[]{"org.clawiz.bpm.common.storage.Pool"});
        }
        this.setTypeId(_typeId);
    }

    public void check(PoolObject pool) {
        if (pool == null) {
            this.throwException("Cannot check null ?", new Object[]{"PoolObject"});
        }
        pool.fillDefaults();
        if (this.packageNameToId(pool.getPackageName(), pool.getName(), pool.getId()) != null) {
            this.throwException("? '?' already exists", new Object[]{"Pool", pool.toPackageName()});
        }
    }

    public PoolObject create() {
        PoolObject pool = new PoolObject();
        pool.setService((PoolService)this);
        pool.fillDefaults();
        return pool;
    }

    public PoolObject load(BigDecimal id) {
        Statement statement = this.executeQuery("select package_name, name from cw_bpm_pools where id = ?", new Object[]{id});
        if (!statement.next()) {
            statement.close();
            this.throwException("? with id ? not found in database", new Object[]{"Pool", id});
        }
        PoolObject result = new PoolObject();
        result.setService((PoolService)this);
        result.setId(id);
        result.setPackageName(statement.getString(1));
        result.setName(statement.getString(2));
        statement.close();
        return result;
    }

    public PoolList loadList(String whereClause, Object ... parameters) {
        return this.loadOrderedList(whereClause, null, parameters);
    }

    public PoolList loadOrderedList(String whereClause, String orderByClause, Object ... parameters) {
        PoolList result = new PoolList();
        Statement statement = this.executeQuery("select id, package_name, name from cw_bpm_pools" + (whereClause != null ? " where " + whereClause : "") + (orderByClause != null ? " order by " + orderByClause : ""), parameters);
        while (statement.next()) {
            PoolObject object = new PoolObject();
            object.setService((PoolService)this);
            object.setId(statement.getBigDecimal(1));
            object.setPackageName(statement.getString(2));
            object.setName(statement.getString(3));
            result.add((Object)object);
        }
        statement.close();
        return result;
    }

    public BigDecimal packageNameToId(String packageName, String name) {
        return this.packageNameToId(packageName, name, null);
    }

    public BigDecimal packageNameToId(String packageName, String name, BigDecimal skipId) {
        if (packageName == null || name == null) {
            return null;
        }
        if (skipId == null) {
            return this.executeQueryBigDecimal("select id from cw_bpm_pools where upper_package_name = ? and upper_name = ?", new Object[]{packageName.toUpperCase(), name.toUpperCase()});
        }
        return this.executeQueryBigDecimal("select id from cw_bpm_pools where upper_package_name = ? and upper_name = ? and id != ?", new Object[]{packageName.toUpperCase(), name.toUpperCase(), skipId});
    }

    public BigDecimal packageNameToId(String packageName, String name, boolean createNewIfNotFound) {
        BigDecimal id = this.packageNameToId(packageName, name, null);
        if (id != null || !createNewIfNotFound) {
            return id;
        }
        PoolObject object = this.create();
        object.setPackageName(packageName);
        object.setName(name);
        this.save(object);
        return object.getId();
    }

    public String idToPackageName(BigDecimal id) {
        if (id == null) {
            return null;
        }
        Statement statement = this.executeQuery("select package_name, name from cw_bpm_pools where id = ?", new Object[]{id});
        if (!statement.next()) {
            statement.close();
            return null;
        }
        PoolObject object = new PoolObject();
        object.setService((PoolService)this);
        object.setId(id);
        object.setPackageName(statement.getString(1));
        object.setName(statement.getString(2));
        statement.close();
        return object.toPackageName();
    }

    public String idToString(BigDecimal id) {
        return this.idToPackageName(id);
    }

    public String objectToString(PoolObject poolObject) {
        return poolObject.toPackageName();
    }

    protected void saveAudit(TransactionAction transactionAction, PoolObject oldPoolObject, PoolObject newPoolObject) {
        PoolObject o = oldPoolObject != null ? oldPoolObject : new PoolObject();
        PoolObject n = newPoolObject != null ? newPoolObject : new PoolObject();
        this.executeUpdate("insert into a_cw_bpm_pools (scn, action_type, id , o_package_name, o_upper_package_name, o_name, o_upper_name, n_package_name, n_upper_package_name, n_name, n_upper_name) values ( ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)", new Object[]{transactionAction.getScn(), transactionAction.getType().toString(), o.getId() != null ? o.getId() : n.getId(), o.getPackageName(), o.getPackageName() != null ? o.getPackageName().toUpperCase() : null, o.getName(), o.getName() != null ? o.getName().toUpperCase() : null, n.getPackageName(), n.getPackageName() != null ? n.getPackageName().toUpperCase() : null, n.getName(), n.getName() != null ? n.getName().toUpperCase() : null});
    }

    public void save(PoolObject pool) {
        TransactionAction transactionAction;
        PoolObject oldPool;
        if (pool == null) {
            this.throwException("Cannot save NULL ?", new Object[]{"PoolObject"});
        }
        if (pool.getService() == null) {
            pool.setService((PoolService)this);
        }
        this.check(pool);
        if (pool.getId() == null) {
            pool.setId(this.getObjectService().createObject(this.getTypeId()));
            oldPool = null;
            transactionAction = this.getSession().newObjectTransactionAction(TransactionActionType.NEW, pool.getId());
            this.executeUpdate("insert into cw_bpm_pools( id, package_name, upper_package_name, name, upper_name ) values(?, ?, ?, ?, ?)", new Object[]{pool.getId(), pool.getPackageName(), pool.getPackageName() != null ? pool.getPackageName().toUpperCase() : null, pool.getName(), pool.getName() != null ? pool.getName().toUpperCase() : null});
        } else {
            oldPool = this.load(pool.getId());
            if (oldPool.equals(pool)) {
                return;
            }
            transactionAction = this.getSession().newObjectTransactionAction(TransactionActionType.CHANGE, pool.getId());
            this.executeUpdate("update cw_bpm_pools set package_name = ?, upper_package_name = ?, name = ?, upper_name = ? where id = ?", new Object[]{pool.getPackageName(), pool.getPackageName() != null ? pool.getPackageName().toUpperCase() : null, pool.getName(), pool.getName() != null ? pool.getName().toUpperCase() : null, pool.getId()});
        }
        this.saveAudit(transactionAction, oldPool, pool);
    }

    public void delete(BigDecimal id) {
        PoolObject oldPoolObject = this.load(id);
        TransactionAction transactionAction = this.getSession().newObjectTransactionAction(TransactionActionType.DELETE, id);
        this.saveAudit(transactionAction, oldPoolObject, null);
        this.getObjectService().deleteObject(id);
        this.executeUpdate("delete from cw_bpm_pools where id = ?", new Object[]{id});
    }
}

