/*
 * Decompiled with CFR 0.152.
 */
package org.clawiz.bpm.common.storage.process;

import java.math.BigDecimal;
import org.clawiz.bpm.common.storage.process.ProcessObject;
import org.clawiz.bpm.common.storage.process.ProcessService;
import org.clawiz.core.common.CoreException;
import org.clawiz.core.common.system.object.AbstractObject;

public class ProcessObjectPrototype
extends AbstractObject {
    private String packageName;
    private String name;
    private BigDecimal rootTypeId;
    public ProcessService service;

    public String getPackageName() {
        return this.packageName;
    }

    public void setPackageName(String packageName) {
        if (packageName != null && packageName.length() > 250) {
            throw new CoreException("Length of field '?' value cannot be more then ?", new Object[]{"Process.PackageName", "250"});
        }
        this.packageName = packageName;
    }

    public ProcessObjectPrototype withPackageName(String packageName) {
        this.setPackageName(packageName);
        return this;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (name != null && name.length() > 128) {
            throw new CoreException("Length of field '?' value cannot be more then ?", new Object[]{"Process.Name", "128"});
        }
        this.name = name;
    }

    public ProcessObjectPrototype withName(String name) {
        this.setName(name);
        return this;
    }

    public BigDecimal getRootTypeId() {
        return this.rootTypeId;
    }

    public void setRootTypeId(BigDecimal rootTypeId) {
        this.rootTypeId = rootTypeId;
    }

    public ProcessObjectPrototype withRootTypeId(BigDecimal rootTypeId) {
        this.setRootTypeId(rootTypeId);
        return this;
    }

    public ProcessService getService() {
        return this.service;
    }

    public void setService(ProcessService service) {
        this.service = service;
    }

    public void copy(ProcessObjectPrototype target) {
        target.setPackageName(this.getPackageName());
        target.setName(this.getName());
        target.setRootTypeId(this.getRootTypeId());
    }

    public void fillDefaults() {
        if (this.service == null) {
            throw new CoreException("Service must be defined before fill object default values", new Object[0]);
        }
    }

    public void check() {
        if (this.service == null) {
            throw new CoreException("Service must be defined before check object data", new Object[0]);
        }
        this.service.check((ProcessObject)this);
    }

    public void save() {
        if (this.service == null) {
            throw new CoreException("Service must be defined before save object", new Object[0]);
        }
        this.service.save((ProcessObject)this);
    }

    public boolean equals(ProcessObjectPrototype object) {
        return this.isObjectsEquals(this.getPackageName(), object.getPackageName()) && this.isObjectsEquals(this.getName(), object.getName()) && this.isObjectsEquals(this.getRootTypeId(), object.getRootTypeId());
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.getPackageName() != null ? this.getPackageName().hashCode() : 0);
        result = result * 31 + (this.getName() != null ? this.getName().hashCode() : 0);
        result = result * 31 + (this.getRootTypeId() != null ? this.getRootTypeId().hashCode() : 0);
        return result;
    }

    public String toPackageName() {
        return this.getPackageName() + "," + this.getName();
    }

    public String toRootType() {
        return this.service.getObjectService().idToString(this.getRootTypeId());
    }
}

