/*
 * Decompiled with CFR 0.152.
 */
package org.clawiz.bpm.common.storage.process;

import java.math.BigDecimal;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import org.clawiz.bpm.common.metadata.data.process.Process;
import org.clawiz.bpm.common.metadata.data.process.node.AbstractProcessNode;
import org.clawiz.bpm.common.storage.process.ProcessObject;
import org.clawiz.bpm.common.storage.process.ProcessServicePrototype;
import org.clawiz.bpm.common.storage.processnode.ProcessNodeService;
import org.clawiz.core.common.metadata.MetadataBase;
import org.clawiz.core.common.system.service.NotInitializeService;
import org.clawiz.core.common.utils.StringUtils;

public class ProcessService
extends ProcessServicePrototype {
    private static ConcurrentHashMap<String, BigDecimal> _fullNamesCache = new ConcurrentHashMap();
    private static ConcurrentHashMap<BigDecimal, Process> _processesCache = new ConcurrentHashMap();
    @NotInitializeService
    private MetadataBase _metadataBase;
    @NotInitializeService
    ProcessNodeService _processNodeService;

    public BigDecimal fullNameToId(String name) {
        if (name == null) {
            return null;
        }
        String[] tokens = StringUtils.splitByLastTokenOccurrence((String)name, (String)"\\.");
        if (tokens.length < 2) {
            return null;
        }
        BigDecimal id = this.packageNameToId(tokens[0], tokens[1]);
        if (id != null) {
            _fullNamesCache.put(name, id);
        }
        return id;
    }

    public MetadataBase getMetadataBase() {
        if (this._metadataBase == null) {
            this._metadataBase = (MetadataBase)this.getService(MetadataBase.class);
        }
        return this._metadataBase;
    }

    public ProcessNodeService getProcessNodeService() {
        if (this._processNodeService == null) {
            this._processNodeService = (ProcessNodeService)this.getService(ProcessNodeService.class);
        }
        return this._processNodeService;
    }

    public Process getProcess(BigDecimal processId) {
        if (processId == null) {
            return null;
        }
        Process process = _processesCache.get(processId);
        if (process != null) {
            return process;
        }
        ProcessObject processObject = this.load(processId);
        if (processObject == null) {
            this.throwException("Process with id ? not found in database", new Object[]{processId});
        }
        process = (Process)this.getMetadataBase().getNode(Process.class, processObject.getPackageName(), processObject.getName(), true);
        process.setId(processId);
        Iterator iterator = process.getNodes().iterator();
        while (iterator.hasNext()) {
            AbstractProcessNode processNode = (AbstractProcessNode)((Object)iterator.next());
            BigDecimal id = this.getProcessNodeService().processNameToId(processId, processNode.getName());
            if (id == null) {
                this.throwException("Process ? node '?' not registered in database. Attempt to reinstall module", new Object[]{process.getFullName(), processNode.getName()});
            }
            processNode.setId(id);
        }
        _processesCache.put(processId, process);
        return process;
    }

    public static void clearStaticCaches() {
        _fullNamesCache.clear();
        _processesCache.clear();
    }

    @Override
    public void save(ProcessObject processObject) {
        super.save(processObject);
        ProcessService.clearStaticCaches();
    }

    @Override
    public void delete(BigDecimal id) {
        super.delete(id);
        ProcessService.clearStaticCaches();
    }
}

