/*
 * Decompiled with CFR 0.152.
 */
package org.clawiz.bpm.common.storage.process;

import java.math.BigDecimal;
import org.clawiz.bpm.common.storage.process.ProcessList;
import org.clawiz.bpm.common.storage.process.ProcessObject;
import org.clawiz.bpm.common.storage.process.ProcessService;
import org.clawiz.core.common.storage.type.TypeService;
import org.clawiz.core.common.system.database.Statement;
import org.clawiz.core.common.system.session.transaction.TransactionAction;
import org.clawiz.core.common.system.session.transaction.TransactionActionType;
import org.clawiz.core.common.system.type.AbstractTypeService;

public class ProcessServicePrototype
extends AbstractTypeService<ProcessObject> {
    private static BigDecimal _typeId;

    public void init() {
        super.init();
        if (_typeId == null && (_typeId = ((TypeService)this.getService(TypeService.class)).packageNameToId("org.clawiz.bpm.common.storage", "Process")) == null) {
            this.throwException("Type '?' not registered in database", new Object[]{"org.clawiz.bpm.common.storage.Process"});
        }
        this.setTypeId(_typeId);
    }

    public void check(ProcessObject process) {
        if (process == null) {
            this.throwException("Cannot check null ?", new Object[]{"ProcessObject"});
        }
        process.fillDefaults();
        if (this.packageNameToId(process.getPackageName(), process.getName(), process.getId()) != null) {
            this.throwException("? '?' already exists", new Object[]{"Process", process.toPackageName()});
        }
    }

    public ProcessObject create() {
        ProcessObject process = new ProcessObject();
        process.setService((ProcessService)this);
        process.fillDefaults();
        return process;
    }

    public ProcessObject load(BigDecimal id) {
        Statement statement = this.executeQuery("select package_name, name, root_type_id from cw_bpm_processes where id = ?", new Object[]{id});
        if (!statement.next()) {
            statement.close();
            this.throwException("? with id ? not found in database", new Object[]{"Process", id});
        }
        ProcessObject result = new ProcessObject();
        result.setService((ProcessService)this);
        result.setId(id);
        result.setPackageName(statement.getString(1));
        result.setName(statement.getString(2));
        result.setRootTypeId(statement.getBigDecimal(3));
        statement.close();
        return result;
    }

    public ProcessList loadList(String whereClause, Object ... parameters) {
        return this.loadOrderedList(whereClause, null, parameters);
    }

    public ProcessList loadOrderedList(String whereClause, String orderByClause, Object ... parameters) {
        ProcessList result = new ProcessList();
        Statement statement = this.executeQuery("select id, package_name, name, root_type_id from cw_bpm_processes" + (whereClause != null ? " where " + whereClause : "") + (orderByClause != null ? " order by " + orderByClause : ""), parameters);
        while (statement.next()) {
            ProcessObject object = new ProcessObject();
            object.setService((ProcessService)this);
            object.setId(statement.getBigDecimal(1));
            object.setPackageName(statement.getString(2));
            object.setName(statement.getString(3));
            object.setRootTypeId(statement.getBigDecimal(4));
            result.add((Object)object);
        }
        statement.close();
        return result;
    }

    public BigDecimal packageNameToId(String packageName, String name) {
        return this.packageNameToId(packageName, name, null);
    }

    public BigDecimal packageNameToId(String packageName, String name, BigDecimal skipId) {
        if (packageName == null || name == null) {
            return null;
        }
        if (skipId == null) {
            return this.executeQueryBigDecimal("select id from cw_bpm_processes where upper_package_name = ? and upper_name = ?", new Object[]{packageName.toUpperCase(), name.toUpperCase()});
        }
        return this.executeQueryBigDecimal("select id from cw_bpm_processes where upper_package_name = ? and upper_name = ? and id != ?", new Object[]{packageName.toUpperCase(), name.toUpperCase(), skipId});
    }

    public BigDecimal packageNameToId(String packageName, String name, boolean createNewIfNotFound) {
        BigDecimal id = this.packageNameToId(packageName, name, null);
        if (id != null || !createNewIfNotFound) {
            return id;
        }
        ProcessObject object = this.create();
        object.setPackageName(packageName);
        object.setName(name);
        this.save(object);
        return object.getId();
    }

    public String idToPackageName(BigDecimal id) {
        if (id == null) {
            return null;
        }
        Statement statement = this.executeQuery("select package_name, name from cw_bpm_processes where id = ?", new Object[]{id});
        if (!statement.next()) {
            statement.close();
            return null;
        }
        ProcessObject object = new ProcessObject();
        object.setService((ProcessService)this);
        object.setId(id);
        object.setPackageName(statement.getString(1));
        object.setName(statement.getString(2));
        statement.close();
        return object.toPackageName();
    }

    public String idToRootType(BigDecimal id) {
        if (id == null) {
            return null;
        }
        Statement statement = this.executeQuery("select root_type_id from cw_bpm_processes where id = ?", new Object[]{id});
        if (!statement.next()) {
            statement.close();
            return null;
        }
        ProcessObject object = new ProcessObject();
        object.setService((ProcessService)this);
        object.setId(id);
        object.setRootTypeId(statement.getBigDecimal(1));
        statement.close();
        return object.toRootType();
    }

    public String idToString(BigDecimal id) {
        return this.idToPackageName(id);
    }

    public String objectToString(ProcessObject processObject) {
        return processObject.toPackageName();
    }

    protected void saveAudit(TransactionAction transactionAction, ProcessObject oldProcessObject, ProcessObject newProcessObject) {
        ProcessObject o = oldProcessObject != null ? oldProcessObject : new ProcessObject();
        ProcessObject n = newProcessObject != null ? newProcessObject : new ProcessObject();
        this.executeUpdate("insert into a_cw_bpm_processes (scn, action_type, id , o_package_name, o_upper_package_name, o_name, o_upper_name, o_root_type_id, n_package_name, n_upper_package_name, n_name, n_upper_name, n_root_type_id) values ( ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)", new Object[]{transactionAction.getScn(), transactionAction.getType().toString(), o.getId() != null ? o.getId() : n.getId(), o.getPackageName(), o.getPackageName() != null ? o.getPackageName().toUpperCase() : null, o.getName(), o.getName() != null ? o.getName().toUpperCase() : null, o.getRootTypeId(), n.getPackageName(), n.getPackageName() != null ? n.getPackageName().toUpperCase() : null, n.getName(), n.getName() != null ? n.getName().toUpperCase() : null, n.getRootTypeId()});
    }

    public void save(ProcessObject process) {
        TransactionAction transactionAction;
        ProcessObject oldProcess;
        if (process == null) {
            this.throwException("Cannot save NULL ?", new Object[]{"ProcessObject"});
        }
        if (process.getService() == null) {
            process.setService((ProcessService)this);
        }
        this.check(process);
        if (process.getId() == null) {
            process.setId(this.getObjectService().createObject(this.getTypeId()));
            oldProcess = null;
            transactionAction = this.getSession().newObjectTransactionAction(TransactionActionType.NEW, process.getId());
            this.executeUpdate("insert into cw_bpm_processes( id, package_name, upper_package_name, name, upper_name, root_type_id ) values(?, ?, ?, ?, ?, ?)", new Object[]{process.getId(), process.getPackageName(), process.getPackageName() != null ? process.getPackageName().toUpperCase() : null, process.getName(), process.getName() != null ? process.getName().toUpperCase() : null, process.getRootTypeId()});
            if (process.getRootTypeId() != null) {
                this.getObjectService().setLink(process.getRootTypeId(), process.getId());
            }
        } else {
            oldProcess = this.load(process.getId());
            if (oldProcess.equals(process)) {
                return;
            }
            transactionAction = this.getSession().newObjectTransactionAction(TransactionActionType.CHANGE, process.getId());
            this.executeUpdate("update cw_bpm_processes set package_name = ?, upper_package_name = ?, name = ?, upper_name = ?, root_type_id = ? where id = ?", new Object[]{process.getPackageName(), process.getPackageName() != null ? process.getPackageName().toUpperCase() : null, process.getName(), process.getName() != null ? process.getName().toUpperCase() : null, process.getRootTypeId(), process.getId()});
            this.getObjectService().changeLinkParent(oldProcess.getRootTypeId(), process.getRootTypeId(), process.getId());
        }
        this.saveAudit(transactionAction, oldProcess, process);
    }

    public void delete(BigDecimal id) {
        ProcessObject oldProcessObject = this.load(id);
        TransactionAction transactionAction = this.getSession().newObjectTransactionAction(TransactionActionType.DELETE, id);
        this.saveAudit(transactionAction, oldProcessObject, null);
        this.getObjectService().deleteObject(id);
        if (oldProcessObject.getRootTypeId() != null) {
            this.getObjectService().deleteLink(oldProcessObject.getRootTypeId(), id);
        }
        this.executeUpdate("delete from cw_bpm_processes where id = ?", new Object[]{id});
    }
}

