/*
 * Decompiled with CFR 0.152.
 */
package org.clawiz.bpm.common.storage.processinstance;

import java.math.BigDecimal;
import org.clawiz.bpm.common.storage.processinstance.ProcessInstanceObject;
import org.clawiz.bpm.common.storage.processinstance.ProcessInstanceService;
import org.clawiz.core.common.CoreException;
import org.clawiz.core.common.system.object.AbstractObject;

public class ProcessInstanceObjectPrototype
extends AbstractObject {
    private BigDecimal processId;
    private BigDecimal objectId;
    private String active;
    public ProcessInstanceService service;

    public BigDecimal getProcessId() {
        return this.processId;
    }

    public void setProcessId(BigDecimal processId) {
        this.processId = processId;
    }

    public ProcessInstanceObjectPrototype withProcessId(BigDecimal processId) {
        this.setProcessId(processId);
        return this;
    }

    public BigDecimal getObjectId() {
        return this.objectId;
    }

    public void setObjectId(BigDecimal objectId) {
        this.objectId = objectId;
    }

    public ProcessInstanceObjectPrototype withObjectId(BigDecimal objectId) {
        this.setObjectId(objectId);
        return this;
    }

    public String getActive() {
        return this.active;
    }

    public void setActive(String active) {
        if (active != null && active.length() > 1) {
            throw new CoreException("Length of field '?' value cannot be more then ?", new Object[]{"ProcessInstance.active", "1"});
        }
        this.active = active;
    }

    public ProcessInstanceObjectPrototype withActive(String active) {
        this.setActive(active);
        return this;
    }

    public ProcessInstanceService getService() {
        return this.service;
    }

    public void setService(ProcessInstanceService service) {
        this.service = service;
    }

    public void copy(ProcessInstanceObjectPrototype target) {
        target.setProcessId(this.getProcessId());
        target.setObjectId(this.getObjectId());
        target.setActive(this.getActive());
    }

    public void fillDefaults() {
        if (this.service == null) {
            throw new CoreException("Service must be defined before fill object default values", new Object[0]);
        }
    }

    public void check() {
        if (this.service == null) {
            throw new CoreException("Service must be defined before check object data", new Object[0]);
        }
        this.service.check((ProcessInstanceObject)this);
    }

    public void save() {
        if (this.service == null) {
            throw new CoreException("Service must be defined before save object", new Object[0]);
        }
        this.service.save((ProcessInstanceObject)this);
    }

    public boolean equals(ProcessInstanceObjectPrototype object) {
        return this.isObjectsEquals(this.getProcessId(), object.getProcessId()) && this.isObjectsEquals(this.getObjectId(), object.getObjectId()) && this.isObjectsEquals(this.getActive(), object.getActive());
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.getProcessId() != null ? this.getProcessId().hashCode() : 0);
        result = result * 31 + (this.getObjectId() != null ? this.getObjectId().hashCode() : 0);
        result = result * 31 + (this.getActive() != null ? this.getActive().hashCode() : 0);
        return result;
    }

    public String toProcessObject() {
        return this.service.getObjectService().idToString(this.getProcessId()) + "," + this.service.getObjectService().idToString(this.getObjectId());
    }
}

