/*
 * Decompiled with CFR 0.152.
 */
package org.clawiz.bpm.common.storage.processinstance;

import java.math.BigDecimal;
import org.clawiz.bpm.common.storage.processinstance.ProcessInstanceList;
import org.clawiz.bpm.common.storage.processinstance.ProcessInstanceObject;
import org.clawiz.bpm.common.storage.processinstance.ProcessInstanceService;
import org.clawiz.core.common.storage.type.TypeService;
import org.clawiz.core.common.system.database.Statement;
import org.clawiz.core.common.system.session.transaction.TransactionAction;
import org.clawiz.core.common.system.session.transaction.TransactionActionType;
import org.clawiz.core.common.system.type.AbstractTypeService;

public class ProcessInstanceServicePrototype
extends AbstractTypeService<ProcessInstanceObject> {
    private static BigDecimal _typeId;

    public void init() {
        super.init();
        if (_typeId == null && (_typeId = ((TypeService)this.getService(TypeService.class)).packageNameToId("org.clawiz.bpm.common.storage", "ProcessInstance")) == null) {
            this.throwException("Type '?' not registered in database", new Object[]{"org.clawiz.bpm.common.storage.ProcessInstance"});
        }
        this.setTypeId(_typeId);
    }

    public void check(ProcessInstanceObject processInstance) {
        if (processInstance == null) {
            this.throwException("Cannot check null ?", new Object[]{"ProcessInstanceObject"});
        }
        processInstance.fillDefaults();
    }

    public ProcessInstanceObject create() {
        ProcessInstanceObject processInstance = new ProcessInstanceObject();
        processInstance.setService((ProcessInstanceService)this);
        processInstance.fillDefaults();
        return processInstance;
    }

    public ProcessInstanceObject load(BigDecimal id) {
        Statement statement = this.executeQuery("select process_id, object_id, active from cw_bpm_process_instances where id = ?", new Object[]{id});
        if (!statement.next()) {
            statement.close();
            this.throwException("? with id ? not found in database", new Object[]{"ProcessInstance", id});
        }
        ProcessInstanceObject result = new ProcessInstanceObject();
        result.setService((ProcessInstanceService)this);
        result.setId(id);
        result.setProcessId(statement.getBigDecimal(1));
        result.setObjectId(statement.getBigDecimal(2));
        result.setActive(statement.getString(3));
        statement.close();
        return result;
    }

    public ProcessInstanceList loadList(String whereClause, Object ... parameters) {
        return this.loadOrderedList(whereClause, null, parameters);
    }

    public ProcessInstanceList loadOrderedList(String whereClause, String orderByClause, Object ... parameters) {
        ProcessInstanceList result = new ProcessInstanceList();
        Statement statement = this.executeQuery("select id, process_id, object_id, active from cw_bpm_process_instances" + (whereClause != null ? " where " + whereClause : "") + (orderByClause != null ? " order by " + orderByClause : ""), parameters);
        while (statement.next()) {
            ProcessInstanceObject object = new ProcessInstanceObject();
            object.setService((ProcessInstanceService)this);
            object.setId(statement.getBigDecimal(1));
            object.setProcessId(statement.getBigDecimal(2));
            object.setObjectId(statement.getBigDecimal(3));
            object.setActive(statement.getString(4));
            result.add((Object)object);
        }
        statement.close();
        return result;
    }

    public String idToProcessObject(BigDecimal id) {
        if (id == null) {
            return null;
        }
        Statement statement = this.executeQuery("select process_id, object_id from cw_bpm_process_instances where id = ?", new Object[]{id});
        if (!statement.next()) {
            statement.close();
            return null;
        }
        ProcessInstanceObject object = new ProcessInstanceObject();
        object.setService((ProcessInstanceService)this);
        object.setId(id);
        object.setProcessId(statement.getBigDecimal(1));
        object.setObjectId(statement.getBigDecimal(2));
        statement.close();
        return object.toProcessObject();
    }

    public String idToString(BigDecimal id) {
        return this.idToProcessObject(id);
    }

    public String objectToString(ProcessInstanceObject processInstanceObject) {
        return processInstanceObject.toProcessObject();
    }

    protected void saveAudit(TransactionAction transactionAction, ProcessInstanceObject oldProcessInstanceObject, ProcessInstanceObject newProcessInstanceObject) {
        ProcessInstanceObject o = oldProcessInstanceObject != null ? oldProcessInstanceObject : new ProcessInstanceObject();
        ProcessInstanceObject n = newProcessInstanceObject != null ? newProcessInstanceObject : new ProcessInstanceObject();
        this.executeUpdate("insert into a_cw_bpm_process_instances (scn, action_type, id , o_process_id, o_object_id, o_active, n_process_id, n_object_id, n_active) values ( ?, ?, ?, ?, ?, ?, ?, ?, ?)", new Object[]{transactionAction.getScn(), transactionAction.getType().toString(), o.getId() != null ? o.getId() : n.getId(), o.getProcessId(), o.getObjectId(), o.getActive(), n.getProcessId(), n.getObjectId(), n.getActive()});
    }

    public void save(ProcessInstanceObject processInstance) {
        TransactionAction transactionAction;
        ProcessInstanceObject oldProcessInstance;
        if (processInstance == null) {
            this.throwException("Cannot save NULL ?", new Object[]{"ProcessInstanceObject"});
        }
        if (processInstance.getService() == null) {
            processInstance.setService((ProcessInstanceService)this);
        }
        this.check(processInstance);
        if (processInstance.getId() == null) {
            processInstance.setId(this.getObjectService().createObject(this.getTypeId()));
            oldProcessInstance = null;
            transactionAction = this.getSession().newObjectTransactionAction(TransactionActionType.NEW, processInstance.getId());
            this.executeUpdate("insert into cw_bpm_process_instances( id, process_id, object_id, active ) values(?, ?, ?, ?)", new Object[]{processInstance.getId(), processInstance.getProcessId(), processInstance.getObjectId(), processInstance.getActive()});
            if (processInstance.getProcessId() != null) {
                this.getObjectService().setLink(processInstance.getProcessId(), processInstance.getId());
            }
            if (processInstance.getObjectId() != null) {
                this.getObjectService().setLink(processInstance.getObjectId(), processInstance.getId());
            }
        } else {
            oldProcessInstance = this.load(processInstance.getId());
            if (oldProcessInstance.equals(processInstance)) {
                return;
            }
            transactionAction = this.getSession().newObjectTransactionAction(TransactionActionType.CHANGE, processInstance.getId());
            this.executeUpdate("update cw_bpm_process_instances set process_id = ?, object_id = ?, active = ? where id = ?", new Object[]{processInstance.getProcessId(), processInstance.getObjectId(), processInstance.getActive(), processInstance.getId()});
            this.getObjectService().changeLinkParent(oldProcessInstance.getProcessId(), processInstance.getProcessId(), processInstance.getId());
            this.getObjectService().changeLinkParent(oldProcessInstance.getObjectId(), processInstance.getObjectId(), processInstance.getId());
        }
        this.saveAudit(transactionAction, oldProcessInstance, processInstance);
    }

    public void delete(BigDecimal id) {
        ProcessInstanceObject oldProcessInstanceObject = this.load(id);
        TransactionAction transactionAction = this.getSession().newObjectTransactionAction(TransactionActionType.DELETE, id);
        this.saveAudit(transactionAction, oldProcessInstanceObject, null);
        this.getObjectService().deleteObject(id);
        if (oldProcessInstanceObject.getProcessId() != null) {
            this.getObjectService().deleteLink(oldProcessInstanceObject.getProcessId(), id);
        }
        if (oldProcessInstanceObject.getObjectId() != null) {
            this.getObjectService().deleteLink(oldProcessInstanceObject.getObjectId(), id);
        }
        this.executeUpdate("delete from cw_bpm_process_instances where id = ?", new Object[]{id});
    }
}

