/*
 * Decompiled with CFR 0.152.
 */
package org.clawiz.bpm.common.storage.processnode;

import java.math.BigDecimal;
import org.clawiz.bpm.common.storage.processnode.ProcessNodeObject;
import org.clawiz.bpm.common.storage.processnode.ProcessNodeService;
import org.clawiz.core.common.CoreException;
import org.clawiz.core.common.system.object.AbstractObject;

public class ProcessNodeObjectPrototype
extends AbstractObject {
    private BigDecimal processId;
    private String name;
    public ProcessNodeService service;

    public BigDecimal getProcessId() {
        return this.processId;
    }

    public void setProcessId(BigDecimal processId) {
        this.processId = processId;
    }

    public ProcessNodeObjectPrototype withProcessId(BigDecimal processId) {
        this.setProcessId(processId);
        return this;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (name != null && name.length() > 128) {
            throw new CoreException("Length of field '?' value cannot be more then ?", new Object[]{"ProcessNode.Name", "128"});
        }
        this.name = name;
    }

    public ProcessNodeObjectPrototype withName(String name) {
        this.setName(name);
        return this;
    }

    public ProcessNodeService getService() {
        return this.service;
    }

    public void setService(ProcessNodeService service) {
        this.service = service;
    }

    public void copy(ProcessNodeObjectPrototype target) {
        target.setProcessId(this.getProcessId());
        target.setName(this.getName());
    }

    public void fillDefaults() {
        if (this.service == null) {
            throw new CoreException("Service must be defined before fill object default values", new Object[0]);
        }
    }

    public void check() {
        if (this.service == null) {
            throw new CoreException("Service must be defined before check object data", new Object[0]);
        }
        this.service.check((ProcessNodeObject)this);
    }

    public void save() {
        if (this.service == null) {
            throw new CoreException("Service must be defined before save object", new Object[0]);
        }
        this.service.save((ProcessNodeObject)this);
    }

    public boolean equals(ProcessNodeObjectPrototype object) {
        return this.isObjectsEquals(this.getProcessId(), object.getProcessId()) && this.isObjectsEquals(this.getName(), object.getName());
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.getProcessId() != null ? this.getProcessId().hashCode() : 0);
        result = result * 31 + (this.getName() != null ? this.getName().hashCode() : 0);
        return result;
    }

    public String toProcessName() {
        return this.service.getObjectService().idToString(this.getProcessId()) + "," + this.getName();
    }
}

