/*
 * Decompiled with CFR 0.152.
 */
package org.clawiz.bpm.common.storage.processnode;

import java.math.BigDecimal;
import org.clawiz.bpm.common.storage.processnode.ProcessNodeList;
import org.clawiz.bpm.common.storage.processnode.ProcessNodeObject;
import org.clawiz.bpm.common.storage.processnode.ProcessNodeService;
import org.clawiz.core.common.storage.type.TypeService;
import org.clawiz.core.common.system.database.Statement;
import org.clawiz.core.common.system.session.transaction.TransactionAction;
import org.clawiz.core.common.system.session.transaction.TransactionActionType;
import org.clawiz.core.common.system.type.AbstractTypeService;

public class ProcessNodeServicePrototype
extends AbstractTypeService<ProcessNodeObject> {
    private static BigDecimal _typeId;

    public void init() {
        super.init();
        if (_typeId == null && (_typeId = ((TypeService)this.getService(TypeService.class)).packageNameToId("org.clawiz.bpm.common.storage", "ProcessNode")) == null) {
            this.throwException("Type '?' not registered in database", new Object[]{"org.clawiz.bpm.common.storage.ProcessNode"});
        }
        this.setTypeId(_typeId);
    }

    public void check(ProcessNodeObject processNode) {
        if (processNode == null) {
            this.throwException("Cannot check null ?", new Object[]{"ProcessNodeObject"});
        }
        processNode.fillDefaults();
        if (this.processNameToId(processNode.getProcessId(), processNode.getName(), processNode.getId()) != null) {
            this.throwException("? '?' already exists", new Object[]{"ProcessNode", processNode.toProcessName()});
        }
    }

    public ProcessNodeObject create() {
        ProcessNodeObject processNode = new ProcessNodeObject();
        processNode.setService((ProcessNodeService)this);
        processNode.fillDefaults();
        return processNode;
    }

    public ProcessNodeObject load(BigDecimal id) {
        Statement statement = this.executeQuery("select process_id, name from cw_bpm_process_nodes where id = ?", new Object[]{id});
        if (!statement.next()) {
            statement.close();
            this.throwException("? with id ? not found in database", new Object[]{"ProcessNode", id});
        }
        ProcessNodeObject result = new ProcessNodeObject();
        result.setService((ProcessNodeService)this);
        result.setId(id);
        result.setProcessId(statement.getBigDecimal(1));
        result.setName(statement.getString(2));
        statement.close();
        return result;
    }

    public ProcessNodeList loadList(String whereClause, Object ... parameters) {
        return this.loadOrderedList(whereClause, null, parameters);
    }

    public ProcessNodeList loadOrderedList(String whereClause, String orderByClause, Object ... parameters) {
        ProcessNodeList result = new ProcessNodeList();
        Statement statement = this.executeQuery("select id, process_id, name from cw_bpm_process_nodes" + (whereClause != null ? " where " + whereClause : "") + (orderByClause != null ? " order by " + orderByClause : ""), parameters);
        while (statement.next()) {
            ProcessNodeObject object = new ProcessNodeObject();
            object.setService((ProcessNodeService)this);
            object.setId(statement.getBigDecimal(1));
            object.setProcessId(statement.getBigDecimal(2));
            object.setName(statement.getString(3));
            result.add((Object)object);
        }
        statement.close();
        return result;
    }

    public BigDecimal processNameToId(BigDecimal processId, String name) {
        return this.processNameToId(processId, name, null);
    }

    public BigDecimal processNameToId(BigDecimal processId, String name, BigDecimal skipId) {
        if (processId == null || name == null) {
            return null;
        }
        if (skipId == null) {
            return this.executeQueryBigDecimal("select id from cw_bpm_process_nodes where process_id = ? and upper_name = ?", new Object[]{processId, name.toUpperCase()});
        }
        return this.executeQueryBigDecimal("select id from cw_bpm_process_nodes where process_id = ? and upper_name = ? and id != ?", new Object[]{processId, name.toUpperCase(), skipId});
    }

    public BigDecimal processNameToId(BigDecimal processId, String name, boolean createNewIfNotFound) {
        BigDecimal id = this.processNameToId(processId, name, null);
        if (id != null || !createNewIfNotFound) {
            return id;
        }
        ProcessNodeObject object = this.create();
        object.setProcessId(processId);
        object.setName(name);
        this.save(object);
        return object.getId();
    }

    public String idToProcessName(BigDecimal id) {
        if (id == null) {
            return null;
        }
        Statement statement = this.executeQuery("select process_id, name from cw_bpm_process_nodes where id = ?", new Object[]{id});
        if (!statement.next()) {
            statement.close();
            return null;
        }
        ProcessNodeObject object = new ProcessNodeObject();
        object.setService((ProcessNodeService)this);
        object.setId(id);
        object.setProcessId(statement.getBigDecimal(1));
        object.setName(statement.getString(2));
        statement.close();
        return object.toProcessName();
    }

    public String idToString(BigDecimal id) {
        return this.idToProcessName(id);
    }

    public String objectToString(ProcessNodeObject processNodeObject) {
        return processNodeObject.toProcessName();
    }

    protected void saveAudit(TransactionAction transactionAction, ProcessNodeObject oldProcessNodeObject, ProcessNodeObject newProcessNodeObject) {
        ProcessNodeObject o = oldProcessNodeObject != null ? oldProcessNodeObject : new ProcessNodeObject();
        ProcessNodeObject n = newProcessNodeObject != null ? newProcessNodeObject : new ProcessNodeObject();
        this.executeUpdate("insert into a_cw_bpm_process_nodes (scn, action_type, id , o_process_id, o_name, o_upper_name, n_process_id, n_name, n_upper_name) values ( ?, ?, ?, ?, ?, ?, ?, ?, ?)", new Object[]{transactionAction.getScn(), transactionAction.getType().toString(), o.getId() != null ? o.getId() : n.getId(), o.getProcessId(), o.getName(), o.getName() != null ? o.getName().toUpperCase() : null, n.getProcessId(), n.getName(), n.getName() != null ? n.getName().toUpperCase() : null});
    }

    public void save(ProcessNodeObject processNode) {
        TransactionAction transactionAction;
        ProcessNodeObject oldProcessNode;
        if (processNode == null) {
            this.throwException("Cannot save NULL ?", new Object[]{"ProcessNodeObject"});
        }
        if (processNode.getService() == null) {
            processNode.setService((ProcessNodeService)this);
        }
        this.check(processNode);
        if (processNode.getId() == null) {
            processNode.setId(this.getObjectService().createObject(this.getTypeId()));
            oldProcessNode = null;
            transactionAction = this.getSession().newObjectTransactionAction(TransactionActionType.NEW, processNode.getId());
            this.executeUpdate("insert into cw_bpm_process_nodes( id, process_id, name, upper_name ) values(?, ?, ?, ?)", new Object[]{processNode.getId(), processNode.getProcessId(), processNode.getName(), processNode.getName() != null ? processNode.getName().toUpperCase() : null});
            if (processNode.getProcessId() != null) {
                this.getObjectService().setLink(processNode.getProcessId(), processNode.getId());
            }
        } else {
            oldProcessNode = this.load(processNode.getId());
            if (oldProcessNode.equals(processNode)) {
                return;
            }
            transactionAction = this.getSession().newObjectTransactionAction(TransactionActionType.CHANGE, processNode.getId());
            this.executeUpdate("update cw_bpm_process_nodes set process_id = ?, name = ?, upper_name = ? where id = ?", new Object[]{processNode.getProcessId(), processNode.getName(), processNode.getName() != null ? processNode.getName().toUpperCase() : null, processNode.getId()});
            this.getObjectService().changeLinkParent(oldProcessNode.getProcessId(), processNode.getProcessId(), processNode.getId());
        }
        this.saveAudit(transactionAction, oldProcessNode, processNode);
    }

    public void delete(BigDecimal id) {
        ProcessNodeObject oldProcessNodeObject = this.load(id);
        TransactionAction transactionAction = this.getSession().newObjectTransactionAction(TransactionActionType.DELETE, id);
        this.saveAudit(transactionAction, oldProcessNodeObject, null);
        this.getObjectService().deleteObject(id);
        if (oldProcessNodeObject.getProcessId() != null) {
            this.getObjectService().deleteLink(oldProcessNodeObject.getProcessId(), id);
        }
        this.executeUpdate("delete from cw_bpm_process_nodes where id = ?", new Object[]{id});
    }
}

