/*
 * Decompiled with CFR 0.152.
 */
package org.clawiz.bpm.common.ui.helper;

import java.math.BigDecimal;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import org.clawiz.bpm.common.helper.ProcessHelper;
import org.clawiz.bpm.common.manager.ProcessManager;
import org.clawiz.bpm.common.manager.instance.AbstractProcessInstance;
import org.clawiz.bpm.common.metadata.data.process.Process;
import org.clawiz.bpm.common.metadata.data.process.flow.AbstractFlow;
import org.clawiz.bpm.common.metadata.data.process.node.AbstractProcessNode;
import org.clawiz.bpm.common.ui.helper.response.ProcessInstanceResponse;
import org.clawiz.bpm.common.ui.helper.response.ProcessInstanceResponseFlow;
import org.clawiz.bpm.common.ui.helper.response.ProcessInstanceResponseNode;
import org.clawiz.bpm.common.ui.helper.response.ProcessInstancesResponseContext;
import org.clawiz.core.common.system.service.Service;

public class UiProcessHelper
extends Service {
    ProcessManager processManager;
    ProcessHelper processHelper;
    private static ConcurrentHashMap<BigDecimal, ProcessInstancesResponseContext> newObjectsResponseCache = new ConcurrentHashMap();

    private ProcessInstancesResponseContext getObjectInstancesResponseContext(BigDecimal objectId) {
        ProcessInstancesResponseContext response = new ProcessInstancesResponseContext();
        for (AbstractProcessInstance instance : this.processManager.getObjectInstanceList(objectId)) {
            ProcessInstanceResponse responseInstance = new ProcessInstanceResponse(instance.getProcess().getFullName());
            response.getInstances().add(responseInstance);
            Iterator<AbstractFlow> iterator = instance.getNodes().iterator();
            while (iterator.hasNext()) {
                AbstractProcessNode node = (AbstractProcessNode)((Object)iterator.next());
                responseInstance.getNodes().add(new ProcessInstanceResponseNode(node.getName(), node.getDescription()));
            }
            for (AbstractFlow flow : this.processManager.getAllowedFlows(instance)) {
                responseInstance.getAllowedFlows().add(new ProcessInstanceResponseFlow(flow.getSourceNode().getName(), flow.getName(), flow.getDescription()));
            }
        }
        return response;
    }

    private ProcessInstancesResponseContext getNewObjectResponse(BigDecimal typeId) {
        ProcessInstancesResponseContext response = new ProcessInstancesResponseContext();
        Iterator iterator = this.processHelper.getProcessesByRootType(typeId).iterator();
        while (iterator.hasNext()) {
            Process process = (Process)((Object)iterator.next());
            if (!process.isStartOnNew().booleanValue()) continue;
            ProcessInstanceResponse responseInstance = new ProcessInstanceResponse(process.getFullName());
            response.getInstances().add(responseInstance);
            Iterator iterator2 = process.getStartNodes().iterator();
            while (iterator2.hasNext()) {
                AbstractProcessNode node = (AbstractProcessNode)((Object)iterator2.next());
                responseInstance.getNodes().add(new ProcessInstanceResponseNode(node.getName(), node.getDescription()));
                if (node.isAutoOut()) continue;
                Iterator iterator3 = node.getOutgoingFlows().iterator();
                while (iterator3.hasNext()) {
                    AbstractFlow flow = (AbstractFlow)((Object)iterator3.next());
                    responseInstance.getAllowedFlows().add(new ProcessInstanceResponseFlow(node.getName(), flow.getName(), flow.getDescription()));
                }
            }
        }
        return response;
    }

    private ProcessInstancesResponseContext getTypeInstancesResponseContext(BigDecimal typeId) {
        ProcessInstancesResponseContext cached = newObjectsResponseCache.get(typeId);
        if (cached == null) {
            cached = this.getNewObjectResponse(typeId);
            newObjectsResponseCache.put(typeId, cached);
        }
        ProcessInstancesResponseContext response = new ProcessInstancesResponseContext();
        for (ProcessInstanceResponse cachedInstance : cached.getInstances()) {
            ProcessInstanceResponse responseInstance = new ProcessInstanceResponse(cachedInstance.getProcessName());
            response.getInstances().add(responseInstance);
            responseInstance.getNodes().addAll(cachedInstance.getNodes());
            for (ProcessInstanceResponseFlow cachedRule : cachedInstance.getAllowedFlows()) {
                responseInstance.getAllowedFlows().add(cachedRule);
            }
        }
        return response;
    }

    public ProcessInstancesResponseContext getInstancesResponseContext(BigDecimal objectId, BigDecimal typeId) {
        return objectId != null ? this.getObjectInstancesResponseContext(objectId) : this.getTypeInstancesResponseContext(typeId);
    }
}

