package org.clawiz.etl.common.storage.jobstep;

import org.clawiz.core.common.metadata.data.type.Type;
import org.clawiz.core.common.metadata.data.type.field.TypeField;
import org.clawiz.core.common.system.type.model.TypeModel;
import org.clawiz.core.common.system.type.model.TypeFieldModel;
import org.clawiz.core.common.system.type.model.TypeRecordIdModel;

public class JobStepModelPrototype extends TypeModel {
    
    private static TypeField JOB_ID_FIELD;
    
    private static TypeField NAME_FIELD;
    
    private static TypeField DESCRIPTION_FIELD;
    
    private static TypeField ACTIVE_FIELD;
    
    private static Type type;
    
    private JobStepService typeService;
    
    private static boolean staticMembersInitialized;
    
    public Type getType() {
        return this.type;
    }
    
    public JobStepService getTypeService() {
        return this.typeService;
    }
    
    public void init() {
        super.init();
        
        if ( staticMembersInitialized ) { 
            return;
        }
        
        type = getService(JobStepService.class).getType();
        
        
        JOB_ID_FIELD = type.getFields().get("Job");
        if ( JOB_ID_FIELD == null ) { throwException("Type field '?' not registered in database", new Object[]{"org.clawiz.etl.common.storage.JobStep.Job"}); }
        
        NAME_FIELD = type.getFields().get("Name");
        if ( NAME_FIELD == null ) { throwException("Type field '?' not registered in database", new Object[]{"org.clawiz.etl.common.storage.JobStep.Name"}); }
        
        DESCRIPTION_FIELD = type.getFields().get("Description");
        if ( DESCRIPTION_FIELD == null ) { throwException("Type field '?' not registered in database", new Object[]{"org.clawiz.etl.common.storage.JobStep.Description"}); }
        
        ACTIVE_FIELD = type.getFields().get("active");
        if ( ACTIVE_FIELD == null ) { throwException("Type field '?' not registered in database", new Object[]{"org.clawiz.etl.common.storage.JobStep.active"}); }
        
        staticMembersInitialized = true;
    }
    
    public TypeRecordIdModel id() {
        
        if ( _id == null ) {
            _id = new TypeRecordIdModel(this);
        }
        
        return _id;
    }
    
    private TypeRecordIdModel _id;
    
    private TypeFieldModel _jobId;
    
    public TypeFieldModel jobId() {
        
        if ( _jobId != null ) {
            return _jobId;
        }
        
        _jobId = new TypeFieldModel(this, JOB_ID_FIELD);
        return _jobId;
        
    }
    
    private TypeFieldModel _name;
    
    public TypeFieldModel name() {
        
        if ( _name != null ) {
            return _name;
        }
        
        _name = new TypeFieldModel(this, NAME_FIELD);
        return _name;
        
    }
    
    private TypeFieldModel _description;
    
    public TypeFieldModel description() {
        
        if ( _description != null ) {
            return _description;
        }
        
        _description = new TypeFieldModel(this, DESCRIPTION_FIELD);
        return _description;
        
    }
    
    private TypeFieldModel _active;
    
    public TypeFieldModel active() {
        
        if ( _active != null ) {
            return _active;
        }
        
        _active = new TypeFieldModel(this, ACTIVE_FIELD);
        return _active;
        
    }
    
    public TypeFieldModel getByFieldName(String fieldName) {
        if ( fieldName == null ) {
            throwException("Cannot return field model for null field name");
        }
        switch (fieldName.toUpperCase()) {
        case "JOB" : return jobId();
        case "NAME" : return name();
        case "DESCRIPTION" : return description();
        case "ACTIVE" : return active();
            default : throwException("Wrong field name '?' in call to get model field of '?'", new Object[]{fieldName, getType().getFullName()});
        }
        return null;
    }
}
