/*
 * Decompiled with CFR 0.152.
 */
package org.clawiz.etl.common.generator.service;

import java.util.HashMap;
import java.util.Iterator;
import org.clawiz.core.common.system.generator.java.AbstractJavaClassGenerator;
import org.clawiz.etl.common.generator.helper.JobGeneratorHelper;
import org.clawiz.etl.common.generator.service.component.job.instance.JobInstanceComponent;
import org.clawiz.etl.common.generator.service.component.job.instance.JobInstancePrototypeComponent;
import org.clawiz.etl.common.generator.service.component.job.service.JobServiceComponent;
import org.clawiz.etl.common.generator.service.component.job.service.JobServicePrototypeComponent;
import org.clawiz.etl.common.generator.service.component.step.instance.JobStepInstanceComponent;
import org.clawiz.etl.common.generator.service.component.step.instance.JobStepInstancePrototypeComponent;
import org.clawiz.etl.common.generator.service.component.step.service.JobStepServiceComponent;
import org.clawiz.etl.common.generator.service.component.step.service.JobStepServicePrototypeComponent;
import org.clawiz.etl.common.generator.service.component.step.service.element.action.AbstractJobStepServicePrototypeActionMethodElement;
import org.clawiz.etl.common.generator.service.component.step.service.element.action.extract.JobStepServicePrototypeExtractTableDataActionMethodElement;
import org.clawiz.etl.common.generator.service.component.step.service.element.action.load.JobStepServicePrototypeLoadTypeDataActionMethodElement;
import org.clawiz.etl.common.metadata.data.job.Job;
import org.clawiz.etl.common.metadata.data.job.step.JobStep;
import org.clawiz.etl.common.metadata.data.job.step.action.AbstractJobStepAction;
import org.clawiz.etl.common.metadata.data.job.step.action.extract.table.ExtractTableDataJobStepAction;
import org.clawiz.etl.common.metadata.data.job.step.action.load.type.LoadTypeDataJobStepAction;

public class JobServiceGenerator
extends AbstractJavaClassGenerator {
    public static final String AFTER_PREPARE_EXTENSION_NAME = "afterPrepare";
    JobGeneratorHelper jobGeneratorHelper;
    Job job;
    HashMap<Class, Class> actionsMap = new HashMap();

    public Job getJob() {
        return this.job;
    }

    public void setJob(Job job) {
        this.job = job;
        this.setPackageName(job.getPackageName() + "." + job.getName().toLowerCase());
    }

    public JobGeneratorHelper getJobGeneratorHelper() {
        return this.jobGeneratorHelper;
    }

    public <A extends AbstractJobStepAction, E extends AbstractJobStepServicePrototypeActionMethodElement> void addActionMap(Class<A> actionClass, Class<E> elemetClass) {
        this.actionsMap.put(actionClass, elemetClass);
    }

    public <A extends AbstractJobStepAction, E extends AbstractJobStepServicePrototypeActionMethodElement> Class<E> getActionMap(Class<A> actionClass) {
        return this.actionsMap.get(actionClass);
    }

    protected void prepare() {
        super.prepare();
        this.addActionMap(ExtractTableDataJobStepAction.class, JobStepServicePrototypeExtractTableDataActionMethodElement.class);
        this.addActionMap(LoadTypeDataJobStepAction.class, JobStepServicePrototypeLoadTypeDataActionMethodElement.class);
        this.processExtensions(AFTER_PREPARE_EXTENSION_NAME, new Object[0]);
    }

    protected void process() {
        this.logInfo("Start generating job service " + this.job.getFullName());
        super.process();
        this.addComponent(JobInstanceComponent.class);
        this.addComponent(JobInstancePrototypeComponent.class);
        this.addComponent(JobServiceComponent.class);
        this.addComponent(JobServicePrototypeComponent.class);
        Iterator iterator = this.job.getSteps().iterator();
        while (iterator.hasNext()) {
            JobStep step = (JobStep)((Object)iterator.next());
            ((JobStepInstanceComponent)this.addComponent(JobStepInstanceComponent.class)).setStep(step);
            ((JobStepInstancePrototypeComponent)this.addComponent(JobStepInstancePrototypeComponent.class)).setStep(step);
            ((JobStepServiceComponent)this.addComponent(JobStepServiceComponent.class)).setStep(step);
            ((JobStepServicePrototypeComponent)this.addComponent(JobStepServicePrototypeComponent.class)).setStep(step);
        }
    }

    protected void done() {
        super.done();
        this.logInfo("Done  generating job service " + this.job.getFullName());
    }
}

