/*
 * Decompiled with CFR 0.152.
 */
package org.clawiz.etl.common.install.job;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Iterator;
import org.clawiz.core.common.metadata.install.AbstractMetadataNodeInstaller;
import org.clawiz.etl.common.generator.service.JobServiceGenerator;
import org.clawiz.etl.common.metadata.data.job.Job;
import org.clawiz.etl.common.metadata.data.job.step.JobStep;
import org.clawiz.etl.common.storage.job.JobObject;
import org.clawiz.etl.common.storage.job.JobService;
import org.clawiz.etl.common.storage.jobstep.JobStepObject;
import org.clawiz.etl.common.storage.jobstep.JobStepService;

public class JobInstaller
extends AbstractMetadataNodeInstaller {
    JobService jobService;
    JobStepService jobStepService;

    protected void saveJob(Job job) {
        JobObject jobObject = this.jobService.load(this.jobService.packageNameToId(job.getPackageName(), job.getName(), true));
        HashMap<BigDecimal, BigDecimal> stepsCache = new HashMap<BigDecimal, BigDecimal>();
        Iterator iterator = job.getSteps().iterator();
        while (iterator.hasNext()) {
            JobStep jobStep = (JobStep)((Object)iterator.next());
            JobStepObject stepObject = this.jobStepService.load(this.jobStepService.jobNameToId(jobObject.getId(), jobStep.getName(), true));
            stepObject.setActive(true);
            stepObject.save();
            stepsCache.put(stepObject.getId(), stepObject.getId());
        }
        iterator = this.jobStepService.loadList("job_id = ?", jobObject.getId()).iterator();
        while (iterator.hasNext()) {
            JobStepObject stepObject = (JobStepObject)((Object)iterator.next());
            if (stepsCache.containsKey(stepObject.getId())) continue;
            stepObject.setActive(false);
            stepObject.save();
        }
        jobObject.save();
    }

    public void process() {
        Job job = (Job)this.getNode();
        this.saveJob(job);
        JobServiceGenerator generator = (JobServiceGenerator)this.getService(JobServiceGenerator.class, true);
        generator.setRootDestinationPath(this.getDestinationPath());
        generator.setJob(job);
        generator.run();
    }
}

