/*
 * Decompiled with CFR 0.152.
 */
package org.clawiz.etl.common.manager;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import org.clawiz.core.common.system.service.Service;
import org.clawiz.etl.common.helper.JobHelper;
import org.clawiz.etl.common.manager.dataset.AbstractDataSet;
import org.clawiz.etl.common.manager.instance.AbstractJobInstance;
import org.clawiz.etl.common.manager.instance.JobInstanceState;
import org.clawiz.etl.common.manager.instance.step.AbstractJobStepInstance;
import org.clawiz.etl.common.manager.instance.step.JobStepInstanceState;
import org.clawiz.etl.common.manager.instance.step.action.JobStepActionInstance;
import org.clawiz.etl.common.manager.instance.step.action.JobStepActionState;
import org.clawiz.etl.common.manager.service.step.action.JobStepActionThread;
import org.clawiz.etl.common.metadata.data.job.step.JobStep;
import org.clawiz.etl.common.metadata.data.job.step.action.AbstractJobStepAction;
import org.clawiz.etl.common.metadata.data.job.step.action.JobStepActionType;

public class JobManager
extends Service {
    JobHelper jobHelper;
    public static ConcurrentHashMap<AbstractJobInstance, AbstractJobInstance> activeInstances = new ConcurrentHashMap();
    private static ConcurrentLinkedDeque<JobStepActionThread> threadsQueue = new ConcurrentLinkedDeque();
    private static ConcurrentHashMap<AbstractJobInstance, ArrayList<JobStepActionThread>> jobThreadsQueue = new ConcurrentHashMap();
    private static ConcurrentHashMap<JobStepActionThread, JobStepActionThread> activeThreads = new ConcurrentHashMap();
    private static ConcurrentHashMap<AbstractJobInstance, HashMap<JobStepActionThread, JobStepActionThread>> jobActiveThreads = new ConcurrentHashMap();
    private static ConcurrentHashMap<AbstractJobInstance, AbstractJobInstance> lockedJobs = new ConcurrentHashMap();
    private static ConcurrentHashMap<AbstractJobInstance, LinkedList<JobDataSetQueueRecord>> jobsDataSetQueue = new ConcurrentHashMap();
    private int maxThreadsCount = 1;

    protected void registerException(AbstractJobInstance jobInstance, Exception e) {
        jobInstance.setState(JobInstanceState.ERROR);
        jobInstance.setCause(e);
    }

    private synchronized void processThreadQueue() {
        boolean found = true;
        while (activeThreads.size() < this.maxThreadsCount && threadsQueue.size() > 0 && found) {
            found = false;
            JobStepActionThread thread = threadsQueue.getFirst();
            AbstractJobInstance jobInstance = thread.getActionInstance().getStepInstance().getJobInstance();
            if (lockedJobs.containsKey(jobInstance)) continue;
            threadsQueue.removeFirst();
            ArrayList<JobStepActionThread> jobQueue = jobThreadsQueue.get(jobInstance);
            if (jobQueue != null) {
                jobQueue.remove(thread);
            }
            jobActiveThreads.get(jobInstance).put(thread, thread);
            activeThreads.put(thread, thread);
            thread.start();
            found = true;
        }
    }

    private void addActionThread(JobStepActionThread thread) {
        if (jobThreadsQueue.get(thread.getActionInstance().getStepInstance().getJobInstance()) != null) {
            threadsQueue.add(thread);
            jobThreadsQueue.get(thread.getActionInstance().getStepInstance().getJobInstance()).add(thread);
        }
    }

    public void createActionInstance(AbstractJobStepInstance stepInstance, AbstractJobStepAction action) {
        this.createActionInstance(stepInstance, action, null);
    }

    public void createActionInstance(AbstractJobStepInstance stepInstance, AbstractJobStepAction action, AbstractDataSet dataSet) {
        JobStepActionThread thread = new JobStepActionThread();
        JobStepActionInstance actionInstance = new JobStepActionInstance();
        thread.setActionInstance(actionInstance);
        actionInstance.setThread(thread);
        actionInstance.setStepInstance(stepInstance);
        actionInstance.setAction(action);
        actionInstance.setDataSet(dataSet);
        thread.setActionInstance(actionInstance);
        this.addActionThread(thread);
        this.processThreadQueue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startAllowedSteps(AbstractJobInstance jobInstance) {
        AbstractJobInstance abstractJobInstance = jobInstance;
        synchronized (abstractJobInstance) {
            ArrayList<AbstractJobStepInstance> allowedSteps = jobInstance.getAllowedReadySteps();
            for (int i = 0; i < allowedSteps.size(); ++i) {
                AbstractJobStepInstance stepInstance = allowedSteps.get(i);
                stepInstance.setState(JobStepInstanceState.RUN);
                Iterator iterator = stepInstance.getStep().getActions().iterator();
                while (iterator.hasNext()) {
                    AbstractJobStepAction action = (AbstractJobStepAction)((Object)iterator.next());
                    if (action.getType() != JobStepActionType.EXTRACT) continue;
                    this.createActionInstance(stepInstance, action);
                }
            }
            this.processJobDataSetQueue(jobInstance);
        }
    }

    public void start(AbstractJobInstance instance) {
        try {
            instance.prepare();
        }
        catch (Exception e) {
            this.registerException(instance, e);
            throw e;
        }
        instance.setState(JobInstanceState.RUN);
        activeInstances.put(instance, instance);
        jobThreadsQueue.put(instance, new ArrayList());
        jobActiveThreads.put(instance, new HashMap());
        jobsDataSetQueue.put(instance, new LinkedList());
        this.startAllowedSteps(instance);
    }

    public void done(AbstractJobInstance instance) {
        activeInstances.remove(instance);
    }

    private void jobInstanceDone(AbstractJobInstance jobInstance) {
        jobInstance.setState(JobInstanceState.DONE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jobInstanceException(AbstractJobInstance jobInstance, Exception cause) {
        AbstractJobInstance abstractJobInstance = jobInstance;
        synchronized (abstractJobInstance) {
            lockedJobs.put(jobInstance, jobInstance);
            jobsDataSetQueue.remove(jobInstance);
            jobInstance.setState(JobInstanceState.ERROR);
            jobInstance.setCause(cause);
            ArrayList<JobStepActionThread> jobQueue = jobThreadsQueue.get(jobInstance);
            jobThreadsQueue.remove(jobInstance);
            if (jobQueue != null) {
                for (JobStepActionThread thread : jobQueue) {
                    threadsQueue.remove(thread);
                }
            }
            HashMap<JobStepActionThread, JobStepActionThread> jobThreads = jobActiveThreads.get(jobInstance);
            jobActiveThreads.remove(jobInstance);
            if (jobThreads != null) {
                for (JobStepActionThread thread : jobThreads.keySet()) {
                    thread.interrupt();
                    jobActiveThreads.remove(thread);
                }
            }
            lockedJobs.remove(jobInstance);
        }
    }

    private void processJobDataSetQueue(AbstractJobInstance jobInstance) {
        ArrayList<JobDataSetQueueRecord> readyQr = new ArrayList<JobDataSetQueueRecord>();
        LinkedList<JobDataSetQueueRecord> qrList = jobsDataSetQueue.get(jobInstance);
        if (qrList == null) {
            return;
        }
        for (JobDataSetQueueRecord qr : qrList) {
            if (!jobInstance.getAllowedReadyStepsMap().containsKey(qr.stepInstance) && !jobInstance.getRunStepsMap().containsKey(qr.stepInstance)) continue;
            readyQr.add(qr);
        }
        for (JobDataSetQueueRecord qr : readyQr) {
            this.createActionInstance(qr.stepInstance, qr.action, qr.dataSet);
            qrList.remove(qr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkStepInstanceDone(AbstractJobStepInstance stepInstance) {
        AbstractJobInstance jobInstance;
        AbstractJobInstance abstractJobInstance = jobInstance = stepInstance.getJobInstance();
        synchronized (abstractJobInstance) {
            HashMap<JobStepActionThread, JobStepActionThread> jobThreads;
            Iterator iterator = stepInstance.getStep().getPreviousSteps().iterator();
            while (iterator.hasNext()) {
                Object previousStep = (JobStep)((Object)iterator.next());
                if (jobInstance.getStepInstance(previousStep.getName()).getState() == JobStepInstanceState.DONE) continue;
                return;
            }
            ArrayList<JobStepActionThread> jobQueue = jobThreadsQueue.get(jobInstance);
            if (jobQueue != null) {
                for (JobStepActionThread thread : jobQueue) {
                    if (thread.getActionInstance().getStepInstance() != stepInstance) continue;
                    return;
                }
            }
            if ((jobThreads = jobActiveThreads.get(jobInstance)) != null) {
                for (JobStepActionThread thread : jobThreads.keySet()) {
                    if (thread.getActionInstance().getStepInstance() != stepInstance) continue;
                    return;
                }
            }
            stepInstance.setState(JobStepInstanceState.DONE);
            jobInstance.clearCaches();
            this.processJobDataSetQueue(jobInstance);
            this.startAllowedSteps(jobInstance);
            for (AbstractJobStepInstance checkStep : jobInstance.getSteps()) {
                if (checkStep.getState() == JobStepInstanceState.DONE) continue;
                return;
            }
            if (jobsDataSetQueue.get(jobInstance).size() > 0) {
                return;
            }
            this.jobInstanceDone(jobInstance);
        }
    }

    private void stepInstanceException(AbstractJobStepInstance stepInstance, Exception cause) {
        stepInstance.setState(JobStepInstanceState.ERROR);
        stepInstance.setCause(cause);
        stepInstance.getJobInstance().clearCaches();
        this.jobInstanceException(stepInstance.getJobInstance(), cause);
    }

    public void putDataSet(JobStepActionInstance currentActionInstance, AbstractDataSet dataSet) {
        AbstractJobInstance jobInstance = currentActionInstance.getStepInstance().getJobInstance();
        ArrayList<AbstractJobStepAction> actions = jobInstance.getJob().getLoadDataSetActions(dataSet);
        for (int i = 0; i < actions.size(); ++i) {
            AbstractJobStepAction nextAction = actions.get(i);
            if (dataSet.isActionProcessed(nextAction)) continue;
            AbstractJobStepInstance nextStepInstance = jobInstance.getStepInstance(nextAction.getJobStep().getName());
            if (nextStepInstance.getState() == JobStepInstanceState.DONE) {
                nextStepInstance.setState(JobStepInstanceState.RUN);
                jobInstance.clearCaches();
            }
            dataSet.setActionProcessed(nextAction);
            if (jobInstance.getAllowedReadyStepsMap().containsKey(nextStepInstance)) {
                this.createActionInstance(nextStepInstance, nextAction, dataSet);
                continue;
            }
            jobsDataSetQueue.get(jobInstance).add(new JobDataSetQueueRecord(dataSet, nextStepInstance, nextAction));
        }
    }

    public void stepActionThreadDone(JobStepActionThread thread) {
        if (!thread.isProtectedMode()) {
            this.throwException("Wrong call of threadDone method for job action ?", new Object[]{thread.getActionInstance().getAction().getFullName()});
        }
        JobStepActionInstance actionInstance = thread.getActionInstance();
        actionInstance.setState(JobStepActionState.DONE);
        jobActiveThreads.get(actionInstance.getStepInstance().getJobInstance()).remove(thread);
        activeThreads.remove(thread);
        this.processThreadQueue();
        AbstractDataSet dataSet = thread.getActionInstance().getDataSet();
        if (dataSet != null) {
            this.putDataSet(actionInstance, dataSet);
        }
        this.checkStepInstanceDone(thread.getActionInstance().getStepInstance());
    }

    public void stepActionThreadException(JobStepActionThread thread, Exception cause) {
        if (!thread.isProtectedMode()) {
            this.throwException("Wrong call of threadException method for job action ?", new Object[]{thread.getActionInstance().getAction().getFullName()});
        }
        thread.getActionInstance().setState(JobStepActionState.ERROR);
        thread.getActionInstance().setCause(cause);
        HashMap<JobStepActionThread, JobStepActionThread> jobThreads = jobActiveThreads.get(thread.getActionInstance().getStepInstance().getJobInstance());
        if (jobThreads != null) {
            jobThreads.remove(thread);
        }
        activeThreads.remove(thread);
        this.processThreadQueue();
        this.stepInstanceException(thread.getActionInstance().getStepInstance(), cause);
    }

    private class JobDataSetQueueRecord {
        AbstractDataSet dataSet;
        AbstractJobStepInstance stepInstance;
        AbstractJobStepAction action;

        public JobDataSetQueueRecord(AbstractDataSet dataSet, AbstractJobStepInstance stepInstance, AbstractJobStepAction action) {
            this.dataSet = dataSet;
            this.stepInstance = stepInstance;
            this.action = action;
        }
    }
}

